/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class SubscriptedArithmeticOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[3]; a[0]=10; a[1]=50; a[2]=30; ";
    private static final String DECLVEC_INT_B = "int b[3]; b[0]=5; b[1]=50; b[2]=10; ";
    private static final String DECLVEC_FLOAT_A = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; ";
    private static final String DECLVEC_FLOAT_B = "float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; ";
    private static final String DECLVEC_STRING_A = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; ";
    private static final String DECLVEC_STRING_B = "string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAdditions();
            this.testSubtractions();
            this.testMultiplications();
            this.testDivisions();
            this.testRemainders();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAdditions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] + b[2] ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 60L, "int[i] + int[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] + b[2] ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 62.8, "int[i] + float[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a[1] + b[2] ; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "50sasisuseso", "int[i] + string[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] + b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 11.4, "float[i] + int[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] + b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 14.200000000000001, "float[i] + float[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a[1] + b[2] ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "1.4sasisuseso", "float[i] + string[j]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] + b[2] ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "def10", "string[i] + int[j]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] + b[2] ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "def12.8", "string[i] + float[j]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\";  a[1] + b[2] ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "defsasisuseso", "string[i] + string[j]", string);
    }

    private void testSubtractions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] - b[2] ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 40L, "int[i] - int[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] - b[2] ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 37.2, "int[i] - float[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] - b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -8.6, "float[i] - int[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] - b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -11.4, "float[i] - float[j]", string);
    }

    private void testMultiplications() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] * b[2] ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 500L, "int[i] * int[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] * b[2] ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 640.0, "int[i] * float[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] * b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 14.0, "float[i] * int[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] * b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 17.919999999999998, "float[i] * float[j]", string);
    }

    private void testDivisions() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] / b[2] ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "int[i] / int[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] / b[2] ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 3.90625, "int[i] / float[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] / b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.13999999999999999, "float[i] / int[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] / b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.10937499999999999, "float[i] / float[j]", string);
    }

    private void testRemainders() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] % b[2] ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "int[i] % int[j]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] % b[2] ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 11.599999999999998, "int[i] % float[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; int b[3]; b[0]=5; b[1]=50; b[2]=10;  a[1] % b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.4, "float[i] % int[j]", string);
        string = "float a[3]; a[0]=2.2; a[1]=1.4; a[2]=8.2; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8;  a[1] % b[2] ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.4, "float[i] % float[j]", string);
    }
}

