/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VariableDeclarationStatementCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testScalarVariablesWithoutInitexpr();
            this.testScalarVariablesWithInitexpr();
            this.testScalarVariablesInLoopWithoutInitexpr();
            this.testScalarVariablesInLoopWithInitexpr();
            this.testArrayVariablesWithoutInitexpr();
            this.testArrayVariablesWithInitexpr();
            this.testArrayVariablesInLoopWithoutInitexpr();
            this.testArrayVariablesInLoopWithInitexpr();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testScalarVariablesWithoutInitexpr() throws VnanoException {
        String string = "int v; v;";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "int v;", string);
        string = "float v; v;";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.0, "float v;", string);
        string = "bool v; v;";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, false, "bool v;", string);
        string = "string v; v;";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "", "string v;", string);
    }

    private void testScalarVariablesWithInitexpr() throws VnanoException {
        String string = "int v = 123; v;";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int v = 123;", string);
        string = "float v = 2.5; v;";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.5, "float v = 2.5;", string);
        string = "bool v = true; v;";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool v = true;", string);
        string = "string v = \"abc\"; v;";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abc", "string v = \"abc\";", string);
    }

    private void testScalarVariablesInLoopWithoutInitexpr() throws VnanoException {
        String string = "int history[3]; for(int i=0; i<3; i++){ int v; history[i]=v; v=-1; } history;";
        long[] lArray = (long[])this.engine.executeScript(string);
        super.evaluateResult(lArray, new long[]{0L, 0L, 0L}, "for(int i=0; i<3; i++){ int v; history[i]=v; v=-1; };", string);
        string = "float history[3]; for(int i=0; i<3; i++){ float v; history[i]=v; v=-1.0; } history;";
        double[] dArray = (double[])this.engine.executeScript(string);
        super.evaluateResult(dArray, new double[]{0.0, 0.0, 0.0}, "for(int i=0; i<3; i++){ float v; history[i]=v; v=-1.0; };", string);
        string = "bool history[3]; for(int i=0; i<3; i++){ bool v; history[i]=v; v=true; } history;";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        super.evaluateResult(blArray, new boolean[]{false, false, false}, "for(int i=0; i<3; i++){ bool v; history[i]=v; v=true; };", string);
        string = "string history[3]; for(int i=0; i<3; i++){ string v; history[i]=v; v=\"updated\"; } history;";
        String[] stringArray = (String[])this.engine.executeScript(string);
        super.evaluateResult(stringArray, new String[]{"", "", ""}, "for(int i=0; i<3; i++){ string v; history[i]=v; v=\"updated\"; };", string);
    }

    private void testScalarVariablesInLoopWithInitexpr() throws VnanoException {
        String string = "int history[3]; for(int i=0; i<3; i++){ int v=123; history[i]=v; v=-1; } history;";
        long[] lArray = (long[])this.engine.executeScript(string);
        super.evaluateResult(lArray, new long[]{123L, 123L, 123L}, "for(int i=0; i<3; i++){ int v=123; history[i]=v; v=-1; };", string);
        string = "float history[3]; for(int i=0; i<3; i++){ float v=2.5; history[i]=v; v=-1.0; } history;";
        double[] dArray = (double[])this.engine.executeScript(string);
        super.evaluateResult(dArray, new double[]{2.5, 2.5, 2.5}, "for(int i=0; i<3; i++){ float v=2.5; history[i]=v; v=-1.0; };", string);
        string = "bool history[3]; for(int i=0; i<3; i++){ bool v=true; history[i]=v; v=false; } history;";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        super.evaluateResult(blArray, new boolean[]{true, true, true}, "for(int i=0; i<3; i++){ bool v=true; history[i]=v; v=false; };", string);
        string = "string history[3]; for(int i=0; i<3; i++){ string v=\"abc\"; history[i]=v; v=\"updated\"; } history;";
        String[] stringArray = (String[])this.engine.executeScript(string);
        super.evaluateResult(stringArray, new String[]{"abc", "abc", "abc"}, "for(int i=0; i<3; i++){ string v=\"abc\"; history[i]=v; v=\"updated\"; };", string);
    }

    private void testArrayVariablesWithoutInitexpr() throws VnanoException {
        String string = "int v[3]; v;";
        long[] lArray = (long[])this.engine.executeScript(string);
        super.evaluateResult(lArray, new long[]{0L, 0L, 0L}, "int v[3];", string);
        string = "float v[3]; v;";
        double[] dArray = (double[])this.engine.executeScript(string);
        super.evaluateResult(dArray, new double[]{0.0, 0.0, 0.0}, "float v[3];", string);
        string = "bool v[3]; v;";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        super.evaluateResult(blArray, new boolean[]{false, false, false}, "bool v[3];", string);
        string = "string v[3]; v;";
        String[] stringArray = (String[])this.engine.executeScript(string);
        super.evaluateResult(stringArray, new String[]{"", "", ""}, "string v[3];", string);
    }

    private void testArrayVariablesWithInitexpr() throws VnanoException {
        String string = "int v[3] = 123; v;";
        long[] lArray = (long[])this.engine.executeScript(string);
        super.evaluateResult(lArray, new long[]{123L, 123L, 123L}, "int v[3] = 123;", string);
        string = "float v[3] = 2.5; v;";
        double[] dArray = (double[])this.engine.executeScript(string);
        super.evaluateResult(dArray, new double[]{2.5, 2.5, 2.5}, "float v[3] = 2.5;", string);
        string = "bool v[3] = true; v;";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        super.evaluateResult(blArray, new boolean[]{true, true, true}, "bool v[3] = true;", string);
        string = "string v[3] = \"abc\"; v;";
        String[] stringArray = (String[])this.engine.executeScript(string);
        super.evaluateResult(stringArray, new String[]{"abc", "abc", "abc"}, "string v[3] = \"abc\";", string);
    }

    private void testArrayVariablesInLoopWithoutInitexpr() throws VnanoException {
        String string = "int history[3][3]; for(int i=0; i<3; i++){ int v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1; } history;";
        long[][] lArray = (long[][])this.engine.executeScript(string);
        super.evaluateResult(lArray, new long[][]{{0L, 0L, 0L}, {0L, 0L, 0L}, {0L, 0L, 0L}}, "for(int i=0; i<3; i++){ int v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1; };", string);
        string = "float history[3][3]; for(int i=0; i<3; i++){ float v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1.0; } history;";
        double[][] dArray = (double[][])this.engine.executeScript(string);
        super.evaluateResult(dArray, new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}}, "for(int i=0; i<3; i++){ float v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1.0; };", string);
        string = "bool history[3][3]; for(int i=0; i<3; i++){ bool v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=true; } history;";
        boolean[][] blArray = (boolean[][])this.engine.executeScript(string);
        super.evaluateResult(blArray, new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}}, "for(int i=0; i<3; i++){ bool v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=true; };", string);
        string = "string history[3][3]; for(int i=0; i<3; i++){ string v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=\"updated\"; } history;";
        String[][] stringArray = (String[][])this.engine.executeScript(string);
        super.evaluateResult(stringArray, new String[][]{{"", "", ""}, {"", "", ""}, {"", "", ""}}, "for(int i=0; i<3; i++){ string v[3]; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=\"updated\"; };", string);
    }

    private void testArrayVariablesInLoopWithInitexpr() throws VnanoException {
        String string = "int history[3][3]; for(int i=0; i<3; i++){ int v[3]=123; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1; } history;";
        long[][] lArray = (long[][])this.engine.executeScript(string);
        super.evaluateResult(lArray, new long[][]{{123L, 123L, 123L}, {123L, 123L, 123L}, {123L, 123L, 123L}}, "for(int i=0; i<3; i++){ int v[3]=123; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1; };", string);
        string = "float history[3][3]; for(int i=0; i<3; i++){ float v[3]=2.5; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1.0; } history;";
        double[][] dArray = (double[][])this.engine.executeScript(string);
        super.evaluateResult(dArray, new double[][]{{2.5, 2.5, 2.5}, {2.5, 2.5, 2.5}, {2.5, 2.5, 2.5}}, "for(int i=0; i<3; i++){ float v[3]=2.5; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=-1.0; };", string);
        string = "bool history[3][3]; for(int i=0; i<3; i++){ bool v[3]=true; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=false; } history;";
        boolean[][] blArray = (boolean[][])this.engine.executeScript(string);
        super.evaluateResult(blArray, new boolean[][]{{true, true, true}, {true, true, true}, {true, true, true}}, "for(int i=0; i<3; i++){ bool v[3]=true; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=false; };", string);
        string = "string history[3][3]; for(int i=0; i<3; i++){ string v[3]=\"abc\"; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=\"updated\"; } history;";
        String[][] stringArray = (String[][])this.engine.executeScript(string);
        super.evaluateResult(stringArray, new String[][]{{"abc", "abc", "abc"}, {"abc", "abc", "abc"}, {"abc", "abc", "abc"}}, "for(int i=0; i<3; i++){ string v[3]=\"abc\"; history[i][0]=v[0]; history[i][1]=v[1]; history[i][2]=v[2]; v=\"updated\"; };", string);
    }
}

