/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VectorAssignmentOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[3]; a[0]=10; a[1]=50; a[2]=30; ";
    private static final String DECLVEC_INT_B = "int b[3]; b[0]=5; b[1]=50; b[2]=10; ";
    private static final String DECLVEC_INT_C = "int c[3]; c[0]=2; c[1]=20; c[2]=32; ";
    private static final String DECLVEC_FLOAT_A = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; ";
    private static final String DECLVEC_FLOAT_B = "float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; ";
    private static final String DECLVEC_FLOAT_C = "float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8; ";
    private static final String DECLVEC_BOOL_A = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; ";
    private static final String DECLVEC_BOOL_B = "bool b[3]; b[0]=false; b[1]=true; b[2]=false; ";
    private static final String DECLVEC_BOOL_C = "bool c[3]; c[0]=false; c[1]=false; c[2]=true; ";
    private static final String DECLVEC_STRING_A = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; ";
    private static final String DECLVEC_STRING_B = "string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; ";
    private static final String DECLVEC_STRING_C = "string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\"; ";
    private static final String DECLVEC_STRING_D = "string d[3]; d[0]=\"123\"; d[1]=\"456\"; d[2]=\"789\"; ";
    private static final String DECLVEC_STRING_E = "string e[3]; e[0]=\"2.125\"; e[1]=\"2.25\"; e[2]=\"2.5\"; ";
    private static final String DECLVEC_STRING_F = "string f[3]; f[0]=\"true\"; f[1]=\"false\"; f[2]=\"true\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAssignmentOperations();
            this.testMultipleAssignmentOperations();
            this.testAssignmentOperationsWithTypeConversions();
            this.testVectorScalarMixedOperations();
            this.testAssignmentOperationsToConstants();
            this.testAssignmentOperationsToScalarsFromArrays();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30;  int x[]; x = a; x; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{10L, 50L, 30L};
        super.evaluateResult(lArray, lArray2, "int[] = int[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125;  float x[]; x = a; x; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{2.5, 1.25, 8.125};
        super.evaluateResult(dArray, dArray2, "float[] = float[]", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false;  bool x[]; x = a; x; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] = bool[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\";  string x[]; x = a; x; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abc", "def", "ghi"};
        super.evaluateResult(stringArray, stringArray2, "string[] = string[]", string);
    }

    private void testMultipleAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; int c[3]; c[0]=2; c[1]=20; c[2]=32;  int x[]; x = a = b = c; x; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{2L, 20L, 32L};
        super.evaluateResult(lArray, lArray2, "int[] = int[] = int[] = int[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125; float b[3]; b[0]=4.25; b[1]=2.8; b[2]=12.8; float c[3]; c[0]=1.125; c[1]=32.4; c[2]=22.8;  float x[]; x = a = b = c; x; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{1.125, 32.4, 22.8};
        super.evaluateResult(dArray, dArray2, "float[] = float[] = float[] = float[]", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false; bool b[3]; b[0]=false; b[1]=true; b[2]=false; bool c[3]; c[0]=false; c[1]=false; c[2]=true;  bool x[]; x = a = b = c; x; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, false, true};
        super.evaluateResult(blArray, blArray2, "bool[] = bool[] = bool[] = bool[]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; string c[3]; c[0]=\"NaCl\"; c[1]=\"H2O\"; c[2]=\"CaCO3\";  string x[]; x = a = b = c; x; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"NaCl", "H2O", "CaCO3"};
        super.evaluateResult(stringArray, stringArray2, "string[] = string[] = string[] = string[]", string);
    }

    private void testAssignmentOperationsWithTypeConversions() throws VnanoException {
        String string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125;  int x[]; x = a; x; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{2L, 1L, 8L};
        super.evaluateResult(lArray, lArray2, "int[] = float[]", string);
        string = "string d[3]; d[0]=\"123\"; d[1]=\"456\"; d[2]=\"789\";  int x[]; x = d; x; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{123L, 456L, 789L};
        super.evaluateResult(lArray, lArray2, "int[] = string[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30;  float x[]; x = a; x; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{10.0, 50.0, 30.0};
        super.evaluateResult(dArray, dArray2, "float[] = int[]", string);
        string = "string e[3]; e[0]=\"2.125\"; e[1]=\"2.25\"; e[2]=\"2.5\";  float x[]; x = e; x; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{2.125, 2.25, 2.5};
        super.evaluateResult(dArray, dArray2, "float[] = string[]", string);
        string = "string f[3]; f[0]=\"true\"; f[1]=\"false\"; f[2]=\"true\";  bool x[]; x = f; x; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, true};
        super.evaluateResult(blArray, blArray2, "bool[] = string[]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30;  string x[]; x = a; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"10", "50", "30"};
        super.evaluateResult(stringArray, stringArray2, "string[] = int[]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.25; a[2]=8.125;  string x[]; x = a; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"2.5", "1.25", "8.125"};
        super.evaluateResult(stringArray, stringArray2, "string[] = float[]", string);
        string = "bool a[3]; a[0]=true; a[1]=false; a[2]=false;  string x[]; x = a; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"true", "false", "false"};
        super.evaluateResult(stringArray, stringArray2, "string[] = bool[]", string);
    }

    private void testVectorScalarMixedOperations() throws VnanoException {
        String string = " int x[3]; x = 123; x; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{123L, 123L, 123L};
        super.evaluateResult(lArray, lArray2, "int[] = int", string);
        string = " int x[3]; x = 1.23; x; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{1L, 1L, 1L};
        super.evaluateResult(lArray, lArray2, "int[] = float", string);
        string = " int x[3]; x = \"123\"; x; ";
        lArray = (long[])this.engine.executeScript(string);
        lArray2 = new long[]{123L, 123L, 123L};
        super.evaluateResult(lArray, lArray2, "int[] = string", string);
        string = " float x[3]; x = 2.125; x; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{2.125, 2.125, 2.125};
        super.evaluateResult(dArray, dArray2, "float[] = float", string);
        string = " float x[3]; x = 2; x; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{2.0, 2.0, 2.0};
        super.evaluateResult(dArray, dArray2, "float[] = int", string);
        string = " float x[3]; x = \"2.125\"; x; ";
        dArray = (double[])this.engine.executeScript(string);
        dArray2 = new double[]{2.125, 2.125, 2.125};
        super.evaluateResult(dArray, dArray2, "float[] = string", string);
        string = " bool x[3]; x = true; x; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, true, true};
        super.evaluateResult(blArray, blArray2, "bool[] = bool", string);
        string = " bool x[3]; x = \"true\"; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true};
        super.evaluateResult(blArray, blArray2, "bool[] = string", string);
        string = " string x[3]; x = \"abc\"; x; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"abc", "abc", "abc"};
        super.evaluateResult(stringArray, stringArray2, "string[] = string", string);
        string = " string x[3]; x = 123; x; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"123", "123", "123"};
        super.evaluateResult(stringArray, stringArray2, "string[] = int", string);
        string = " string x[3]; x = 2.125; x; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"2.125", "2.125", "2.125"};
        super.evaluateResult(stringArray, stringArray2, "string[] = float", string);
        string = " string x[3]; x = true; x; ";
        stringArray = (String[])this.engine.executeScript(string);
        stringArray2 = new String[]{"true", "true", "true"};
        super.evaluateResult(stringArray, stringArray2, "string[] = bool", string);
    }

    private void testAssignmentOperationsToConstants() throws VnanoException {
        String string = "const int a[3]; int b[3]; a = b;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; int b[3]; a = b; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; int b[3]; a = b; (should be failed) ");
        }
    }

    private void testAssignmentOperationsToScalarsFromArrays() throws VnanoException {
        String string = "int a[1]; a[0]=123; int s=0; s=a; s;";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int = int[] (size is 1) ", string);
        string = "float a[1]; a[0]=1234.5; float s=0; s=a; s;";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1234.5, "float = float[] (size is 1) ", string);
        string = "bool a[1]; a[0]=true; bool s=false; s=a; s;";
        boolean bl = (Boolean)this.engine.executeScript(string);
        super.evaluateResult(bl, true, "bool = bool[] (size is 1) ", string);
        string = "string a[1]; a[0]=\"abc\"; string s=\"\"; s=a; s;";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abc", "string = string[] (size is 1) ", string);
        string = "int a[3]; a[1]=123; int s=0; s=a; s;";
        try {
            l = (Long)this.engine.executeScript(string);
            super.missedExpectedError("int = int[] (size is 3, should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("int = int[] (size is 3, should be failed) ");
        }
        string = "float a[3]; a[1]=1234.5; float s=0; s=a; s;";
        try {
            d = (Double)this.engine.executeScript(string);
            super.missedExpectedError("float = float[] (size is 3, should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("float = float[] (size is 3, should be failed) ");
        }
        string = "bool a[3]; a[1]=true; bool s=false; s=a; s;";
        try {
            bl = (Boolean)this.engine.executeScript(string);
            super.missedExpectedError("bool = bool[] (size is 3, should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("bool = bool[] (size is 3, should be failed) ");
        }
        string = "string a[3]; a[1]=\"abc\"; string s=\"\"; s=a; s;";
        try {
            string2 = (String)this.engine.executeScript(string);
            super.missedExpectedError("string = string[] (size is 3, should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("string = string[] (size is 3, should be failed) ");
        }
    }
}

