/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VectorLogicalOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_A = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; ";
    private static final String DECLVEC_B = "bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; ";
    private static final String DECLVEC_C = "bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; ";
    private static final String DECLVEC_D = "bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false; ";
    private static final String DECLVEC_T = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; ";
    private static final String DECLVEC_F = "bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; ";
    private static final String DECLVEC_X = "bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; ";
    private static final boolean T = true;
    private static final boolean F = false;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testSingleOperations();
            this.testDualOperations();
            this.testTripleOperations();
            this.testVectorScalarMixedOperations();
            this.testShortCircuitEvaluations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testSingleOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a && b ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a || b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false;  ! a ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "! bool[]", string);
    }

    private void testDualOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false;  a && b && c ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false;  a || b || c ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false;  a && b || c ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false;  a || b && c ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false;  !! a ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "!! bool[]", string);
    }

    private void testTripleOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && b && c && d ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || b || c || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && b || c || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] || bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || b && c || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, true, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] && bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || b || c && d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && b && c || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, true, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && b || c && d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] || bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || b && c && d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] && bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false;  !!! a ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "!!! bool[]", string);
    }

    private void testVectorScalarMixedOperations() throws VnanoException {
        String string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a && true ; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a && false ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool   (case 2)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  true && b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool && bool[]   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  false && b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool && bool[]   (case 2)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a || true ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool[] || bool   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  a || false ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool   (case 2)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  true || b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool || bool[]   (case 1)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false;  false || b ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool || bool[]   (case 2)", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  true && b && c && d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, true, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool && bool[] && bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && true && c && d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool && bool[] && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && b && true && d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool && bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a && b && c && true ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] && bool", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  true || b || c || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool || bool[] || bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || true || c || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool[] || bool || bool[] || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || b || true || d ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool || bool[]", string);
        string = "bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool b[6]; b[0]=true; b[1]=false; b[2]=true; b[3]=false; b[4]=false; b[5]=false; bool c[6]; c[0]=true; c[1]=true; c[2]=true; c[3]=true; c[4]=false; c[5]=false; bool d[6]; d[0]=true; d[1]=true; d[2]=true; d[3]=false; d[4]=true; d[5]=false;  a || b || c || true ; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, true, true, true, true};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] || bool", string);
    }

    private void testShortCircuitEvaluations() throws VnanoException {
        String string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f && (x=a); x; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && (bool[] = bool[])   (short-circuit evaluation occurs)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && (bool[] = bool[])   (short-circuit evaluation does not occur)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t || (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || (bool[] = bool[])   (short-circuit evaluation occurs)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || (bool[] = bool[])   (short-circuit evaluation does not occur)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; (f && t) && (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "(bool[] && bool[]) && (bool[] = bool[])   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; (f && f) && (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "(bool[] && bool[]) && (bool[] = bool[])   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; (t && t) && (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "(bool[] && bool[]) && (bool[] = bool[])   (case 3)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f && ( t && (x=a) ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && ( bool[] && (bool[] = bool[]) )   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && ( f && (x=a) ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && ( bool[] && (bool[] = bool[]) )   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && ( t && (x=a) ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && ( bool[] && (bool[] = bool[]) )   (case 3)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f && ( (x=a) && t ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && ( (bool[] = bool[]) && bool[] )   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && ( (x=a) && t ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && ( (bool[] = bool[]) && bool[] )   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f && t && t && (x=a) && t && t; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] && (bool[] = bool[]) && bool[] && bool[]   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && t && f && (x=a) && t && t; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] && (bool[] = bool[]) && bool[] && bool[]   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && t && t && (x=a) && t && t; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] && (bool[] = bool[]) && bool[] && bool[]   (case 3)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t && t && t && (x=a) && f && t; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] && bool[] && bool[] && (bool[] = bool[]) && bool[] && bool[]   (case 4)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; (t || f) || (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "(bool[] || bool[]) || (bool[] = bool[])   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; (t || t) || (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "(bool[] || bool[]) || (bool[] = bool[])   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; (f || f) || (x=a); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "(bool[] || bool[]) || (bool[] = bool[])   (case 3)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t || ( f || (x=a) ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || ( bool[] || (bool[] = bool[]) )   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || ( t || (x=a) ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || ( bool[] || (bool[] = bool[]) )   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || ( f || (x=a) ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || ( bool[] || (bool[] = bool[]) )   (case 3)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t || ( (x=a) || f ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || ( (bool[] = bool[]) || bool[] )   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || ( (x=a) || f ); x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || ( (bool[] = bool[]) || bool[] )   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; t || f || f || (x=a) || f || f; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] || (bool[] = bool[]) || bool[] || bool[]   (case 1)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || f || t || (x=a) || f || f; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{false, false, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] || (bool[] = bool[]) || bool[] || bool[]   (case 2)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || f || f || (x=a) || f || f; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] || (bool[] = bool[]) || bool[] || bool[]   (case 3)", string);
        string = "bool t[6]; t[0]=true; t[1]=true; t[2]=true; t[3]=true; t[4]=true; t[5]=true; bool f[6]; f[0]=false; f[1]=false; f[2]=false; f[3]=false; f[4]=false; f[5]=false; bool a[6]; a[0]=true; a[1]=true; a[2]=false; a[3]=false; a[4]=false; a[5]=false; bool x[6]; x[0]=false; x[1]=false; x[2]=false; x[3]=false; x[4]=false; x[5]=false; f || f || f || (x=a) || t || f; x; ";
        blArray = (boolean[])this.engine.executeScript(string);
        blArray2 = new boolean[]{true, true, false, false, false, false};
        super.evaluateResult(blArray, blArray2, "bool[] || bool[] || bool[] || (bool[] = bool[]) || bool[] || bool[]   (case 4)", string);
    }
}

