/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;

public class AstNodeTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetType() {
        AstNode node = new AstNode(AstNode.Type.EXPRESSION, 123, "Test.vnano");
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)node.getType()));
    }

    @Test
    public void testGetLineNumber() {
        AstNode node = new AstNode(AstNode.Type.EXPRESSION, 123, "Test.vnano");
        Assert.assertEquals((long)123L, (long)node.getLineNumber());
    }

    @Test
    public void testGetFileName() {
        AstNode node = new AstNode(AstNode.Type.EXPRESSION, 123, "Test.vnano");
        Assert.assertEquals((Object)"Test.vnano", (Object)node.getFileName());
    }

    @Test
    public void testAddGetHasChildNodes() {
        AstNode parent = new AstNode(AstNode.Type.BLOCK, 123, "Test.vnano");
        AstNode childA = new AstNode(AstNode.Type.IF, 124, "Test.vnano");
        AstNode childB = new AstNode(AstNode.Type.EXPRESSION, 125, "Test.vnano");
        AstNode childC = new AstNode(AstNode.Type.ELSE, 126, "Test.vnano");
        AstNode childD = new AstNode(AstNode.Type.EXPRESSION, 125, "Test.vnano");
        Assert.assertEquals((Object)false, (Object)parent.hasChildNodes());
        parent.addChildNode(childA);
        parent.addChildNodes(new AstNode[]{childB, childC, childD});
        Assert.assertTrue((boolean)parent.hasChildNodes());
        Assert.assertTrue((boolean)parent.hasChildNodes(AstNode.Type.IF));
        Assert.assertFalse((boolean)parent.hasChildNodes(AstNode.Type.FOR));
        AstNode[] children = parent.getChildNodes();
        Assert.assertEquals((long)4L, (long)children.length);
        Assert.assertEquals((Object)children[0], (Object)childA);
        Assert.assertEquals((Object)children[1], (Object)childB);
        Assert.assertEquals((Object)children[2], (Object)childC);
        Assert.assertEquals((Object)children[3], (Object)childD);
        children = parent.getChildNodes(AstNode.Type.EXPRESSION);
        Assert.assertEquals((long)2L, (long)children.length);
        Assert.assertEquals((Object)children[0], (Object)childB);
        Assert.assertEquals((Object)children[1], (Object)childD);
    }

    @Test
    public void testAddGetHasParentNode() {
        AstNode parent = new AstNode(AstNode.Type.ROOT, 0, "Test.vnano");
        AstNode child = new AstNode(AstNode.Type.BLOCK, 123, "Test.vnano");
        Assert.assertFalse((boolean)child.hasParentNode());
        parent.addChildNode(child);
        Assert.assertTrue((boolean)child.hasParentNode());
        Assert.assertEquals((Object)parent, (Object)child.getParentNode());
    }

    @Test
    public void testGetSiblingIndex() {
        AstNode parent = new AstNode(AstNode.Type.BLOCK, 123, "Test.vnano");
        AstNode childA = new AstNode(AstNode.Type.IF, 124, "Test.vnano");
        AstNode childB = new AstNode(AstNode.Type.EXPRESSION, 125, "Test.vnano");
        AstNode childC = new AstNode(AstNode.Type.ELSE, 126, "Test.vnano");
        AstNode childD = new AstNode(AstNode.Type.EXPRESSION, 125, "Test.vnano");
        parent.addChildNode(childA);
        parent.addChildNode(childB);
        parent.addChildNode(childC);
        parent.addChildNode(childD);
        Assert.assertEquals((long)0L, (long)childA.getSiblingIndex());
        Assert.assertEquals((long)1L, (long)childB.getSiblingIndex());
        Assert.assertEquals((long)2L, (long)childC.getSiblingIndex());
        Assert.assertEquals((long)3L, (long)childD.getSiblingIndex());
    }

    @Test
    public void testGetDepth() {
        AstNode root = new AstNode(AstNode.Type.ROOT, 123, "Test.vnano");
        AstNode childDepth1 = new AstNode(AstNode.Type.BLOCK, 124, "Test.vnano");
        AstNode childDepth2 = new AstNode(AstNode.Type.IF, 125, "Test.vnano");
        AstNode childDepth3 = new AstNode(AstNode.Type.EXPRESSION, 126, "Test.vnano");
        AstNode childDepth4 = new AstNode(AstNode.Type.OPERATOR, 125, "Test.vnano");
        root.addChildNode(childDepth1);
        childDepth1.addChildNode(childDepth2);
        childDepth2.addChildNode(childDepth3);
        childDepth3.addChildNode(childDepth4);
        root.updateDepths();
        Assert.assertEquals((long)0L, (long)root.getDepth());
        Assert.assertEquals((long)1L, (long)childDepth1.getDepth());
        Assert.assertEquals((long)2L, (long)childDepth2.getDepth());
        Assert.assertEquals((long)3L, (long)childDepth3.getDepth());
        Assert.assertEquals((long)4L, (long)childDepth4.getDepth());
    }

    @Test
    public void testSetGetHasAttribute() {
        AstNode node = new AstNode(AstNode.Type.LEAF, 123, "Test.vnano");
        Assert.assertFalse((boolean)node.hasAttribute(AttributeKey.IDENTIFIER_VALUE));
        node.setAttribute(AttributeKey.IDENTIFIER_VALUE, "hello");
        Assert.assertTrue((boolean)node.hasAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"hello", (Object)node.getAttribute(AttributeKey.IDENTIFIER_VALUE));
    }

    @Test
    public void testSetGetDataTypeName() {
        AstNode node = new AstNode(AstNode.Type.OPERATOR, 123, "Test.vnano");
        node.setAttribute(AttributeKey.DATA_TYPE, "int");
        Assert.assertEquals((Object)"int", (Object)node.getDataTypeName());
    }

    @Test
    public void testSetGetRank() {
        AstNode node = new AstNode(AstNode.Type.OPERATOR, 123, "Test.vnano");
        node.setAttribute(AttributeKey.ARRAY_RANK, "3");
        Assert.assertEquals((long)3L, (long)node.getArrayRank());
    }

    @Test
    public void testPreorderTraversal() {
        AstNode r = new AstNode(AstNode.Type.EXPRESSION, 0, "Test.vnano");
        AstNode a = new AstNode(AstNode.Type.OPERATOR, 1, "Test.vnano");
        AstNode b = new AstNode(AstNode.Type.OPERATOR, 2, "Test.vnano");
        AstNode b0 = new AstNode(AstNode.Type.LEAF, 3, "Test.vnano");
        AstNode c = new AstNode(AstNode.Type.OPERATOR, 4, "Test.vnano");
        AstNode c0 = new AstNode(AstNode.Type.LEAF, 5, "Test.vnano");
        AstNode c1 = new AstNode(AstNode.Type.LEAF, 6, "Test.vnano");
        AstNode d = new AstNode(AstNode.Type.OPERATOR, 7, "Test.vnano");
        AstNode d0 = new AstNode(AstNode.Type.LEAF, 8, "Test.vnano");
        AstNode d1 = new AstNode(AstNode.Type.LEAF, 9, "Test.vnano");
        AstNode d2 = new AstNode(AstNode.Type.LEAF, 10, "Test.vnano");
        r.addChildNode(a);
        r.addChildNode(b);
        r.addChildNode(c);
        r.addChildNode(d);
        b.addChildNode(b0);
        c.addChildNode(c0);
        c.addChildNode(c1);
        d.addChildNode(d0);
        d.addChildNode(d1);
        d.addChildNode(d2);
        AstNode node = r;
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)a, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)b, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)b0, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)c, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)c0, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)c1, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)d, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)d0, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)d1, (Object)node);
        Assert.assertFalse((boolean)node.isPreorderDftLastNode());
        node = node.getPreorderDftNextNode();
        Assert.assertEquals((Object)d2, (Object)node);
        Assert.assertTrue((boolean)node.isPreorderDftLastNode());
        Assert.assertNull((Object)node.getPreorderDftNextNode());
    }

    @Test
    public void testPostorderTraversal() {
        AstNode r = new AstNode(AstNode.Type.EXPRESSION, 0, "Test.vnano");
        AstNode a = new AstNode(AstNode.Type.OPERATOR, 1, "Test.vnano");
        AstNode b = new AstNode(AstNode.Type.OPERATOR, 2, "Test.vnano");
        AstNode b0 = new AstNode(AstNode.Type.LEAF, 3, "Test.vnano");
        AstNode c = new AstNode(AstNode.Type.OPERATOR, 4, "Test.vnano");
        AstNode c0 = new AstNode(AstNode.Type.LEAF, 5, "Test.vnano");
        AstNode c1 = new AstNode(AstNode.Type.LEAF, 6, "Test.vnano");
        AstNode d = new AstNode(AstNode.Type.OPERATOR, 7, "Test.vnano");
        AstNode d0 = new AstNode(AstNode.Type.LEAF, 8, "Test.vnano");
        AstNode d1 = new AstNode(AstNode.Type.LEAF, 9, "Test.vnano");
        AstNode d2 = new AstNode(AstNode.Type.LEAF, 10, "Test.vnano");
        r.addChildNode(a);
        r.addChildNode(b);
        r.addChildNode(c);
        r.addChildNode(d);
        b.addChildNode(b0);
        c.addChildNode(c0);
        c.addChildNode(c1);
        d.addChildNode(d0);
        d.addChildNode(d1);
        d.addChildNode(d2);
        AstNode node = r.getPostorderDftFirstNode();
        Assert.assertEquals((Object)a, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)b0, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)b, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)c0, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)c1, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)c, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)d0, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)d1, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)d2, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)d, (Object)node);
        Assert.assertFalse((boolean)node.isPostorderDftLastNode());
        node = node.getPostorderDftNextNode();
        Assert.assertEquals((Object)r, (Object)node);
        Assert.assertTrue((boolean)node.isPostorderDftLastNode());
        Assert.assertNull((Object)node.getPostorderDftNextNode());
    }
}

