/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.CodeGenerator;
import org.vcssl.nano.spec.AssemblyWord;
import org.vcssl.nano.spec.OperationCode;

public class CodeGeneratorTest {
    private static final int RANK_OF_SCALAR = 0;
    private final String EOI = ";" + AssemblyWord.LINE_SEPARATOR;
    private final String WS = "\t";
    private final String VS = ":";
    private final String IND = "\t";
    private final String IINT = "~int";
    private final String IFLOAT = "~float";
    private final char R = (char)82;
    private final String IVA = "_intVectorA";
    private final String IVB = "_intVectorB";
    private final String ISA = "_intScalarA";
    private final String ISB = "_intScalarB";
    private final String FVA = "_floatVectorA";
    private final String FSB = "_floatScalarB";
    private static final String GLOBAL_DIRECTIVE_IVA = "#GLOBAL_VARIABLE\t_intVectorA";
    private static final String GLOBAL_DIRECTIVE_IVB = "#GLOBAL_VARIABLE\t_intVectorB";
    private static final String GLOBAL_DIRECTIVE_ISA = "#GLOBAL_VARIABLE\t_intScalarA";
    private static final String GLOBAL_DIRECTIVE_ISB = "#GLOBAL_VARIABLE\t_intScalarB";
    private static final String GLOBAL_DIRECTIVE_FVA = "#GLOBAL_VARIABLE\t_floatVectorA";
    private static final String GLOBAL_DIRECTIVE_FSB = "#GLOBAL_VARIABLE\t_floatScalarB";
    private final String END_CODE = "\t" + (Object)((Object)OperationCode.END) + "\t" + "void" + "\t" + '-' + this.EOI;
    private final String HEADER = "#ASSEMBLY_LANGUAGE_IDENTIFIER\t\"Vector Register Intermediate Language (VRIL)\"" + this.EOI + "#assemblyLanguageVersion" + "\t" + "\"" + "0.0.1" + "\"" + this.EOI + "#SCRIPT_LANGUAGE_IDENTIFIER" + "\t" + "\"" + "Vnano" + "\"" + this.EOI + "#scriptLanguageVersion" + "\t" + "\"" + "1.1.2" + "\"" + this.EOI + AssemblyWord.LINE_SEPARATOR;
    private final String META = String.valueOf(AssemblyWord.LINE_SEPARATOR) + "#META" + "\t" + "\"line=123, file=Test.vnano\"";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    private AstNode createRootNode() {
        return new AstNode(AstNode.Type.ROOT, 123, "Test.vnano");
    }

    private AstNode createExpressionNode(String dataTypeName, int rank) {
        return new AstNode(AstNode.Type.EXPRESSION, 123, "Test.vnano");
    }

    private AstNode createOperatorNode(String symbol, int priority, String syntax, String executor, String dataTypeName, int rank) {
        AstNode node = new AstNode(AstNode.Type.OPERATOR, 123, "Test.vnano");
        node.setAttribute(AttributeKey.OPERATOR_SYMBOL, symbol);
        node.setAttribute(AttributeKey.OPERATOR_PRECEDENCE, Integer.toString(priority));
        node.setAttribute(AttributeKey.OPERATOR_SYNTAX, syntax);
        node.setAttribute(AttributeKey.OPERATOR_EXECUTOR, executor);
        node.setAttribute(AttributeKey.OPERATOR_EXECUTION_DATA_TYPE, dataTypeName);
        node.setAttribute(AttributeKey.DATA_TYPE, dataTypeName);
        node.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(rank));
        return node;
    }

    private AstNode createLiteralNode(String value, String dataTypeName, int rank) {
        AstNode node = new AstNode(AstNode.Type.LEAF, 123, "Test.vnano");
        node.setAttribute(AttributeKey.LEAF_TYPE, "literal");
        node.setAttribute(AttributeKey.LITERAL_VALUE, value);
        node.setAttribute(AttributeKey.DATA_TYPE, dataTypeName);
        node.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(rank));
        return node;
    }

    private AstNode createVariableIdentifierNode(String identifier, String dataTypeName, int rank, String scope) {
        AstNode node = new AstNode(AstNode.Type.LEAF, 123, "Test.vnano");
        node.setAttribute(AttributeKey.LEAF_TYPE, "variableIdentifier");
        node.setAttribute(AttributeKey.IDENTIFIER_VALUE, identifier);
        node.setAttribute(AttributeKey.DATA_TYPE, dataTypeName);
        node.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(rank));
        node.setAttribute(AttributeKey.SCOPE, scope);
        return node;
    }

    @Test
    public void testGenerateAssignmentOperatorCode() {
        this.testGenerateAssignmentOperatorCodeVector();
    }

    public void testGenerateAssignmentOperatorCodeVector() {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("int", 1);
        AstNode operatorNode = this.createOperatorNode("=", 6000, "binary", "assignment", "int", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("intVectorA", "int", 1, "global"), this.createVariableIdentifierNode("intVectorB", "int", 1, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_IVA + this.EOI + GLOBAL_DIRECTIVE_IVB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "int" + "\t" + "_intVectorA" + "\t" + "_intVectorB" + this.EOI + "\t" + (Object)((Object)OperationCode.MOV) + "\t" + "int" + "\t" + "_intVectorA" + "\t" + "_intVectorB" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    @Test
    public void testGenerateArithmeticBinaryOperatorCode() {
        this.testGenerateArithmeticBinaryOperatorCodeScalar("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeScalar("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeScalar("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeScalar("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeScalar("%", 3000, OperationCode.REM);
        this.testGenerateArithmeticBinaryOperatorCodeScalarCast("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeScalarCast("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeScalarCast("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeScalarCast("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeScalarCast("%", 3000, OperationCode.REM);
        this.testGenerateArithmeticBinaryOperatorCodeVector("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeVector("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeVector("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeVector("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeVector("%", 3000, OperationCode.REM);
        this.testGenerateArithmeticBinaryOperatorCodeVectorCast("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeVectorCast("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeVectorCast("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeVectorCast("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeVectorCast("%", 3000, OperationCode.REM);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixed("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixed("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixed("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixed("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixed("%", 3000, OperationCode.REM);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastVector("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastVector("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastVector("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastVector("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastVector("%", 3000, OperationCode.REM);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastScalar("+", 3100, OperationCode.ADD);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastScalar("-", 3100, OperationCode.SUB);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastScalar("*", 3000, OperationCode.MUL);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastScalar("/", 3000, OperationCode.DIV);
        this.testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastScalar("%", 3000, OperationCode.REM);
    }

    public void testGenerateArithmeticBinaryOperatorCodeScalar(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("int", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "int", 0);
        AstNode[] operandNodes = new AstNode[]{this.createLiteralNode("1", "int", 0), this.createLiteralNode("2", "int", 0)};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOC) + "\t" + "int" + "\t" + 'R' + "0" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "int" + "\t" + 'R' + "0" + "\t" + "~int" + ":" + "1" + "\t" + "~int" + ":" + "2" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticBinaryOperatorCodeScalarCast(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("float", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "float", 0);
        AstNode[] operandNodes = new AstNode[]{this.createLiteralNode("1", "float", 0), this.createLiteralNode("2", "int", 0)};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOC) + "\t" + "float" + "\t" + 'R' + "1" + this.EOI + "\t" + (Object)((Object)OperationCode.CAST) + "\t" + "float" + ":" + "int" + "\t" + 'R' + "1" + "\t" + "~int" + ":" + "2" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOC) + "\t" + "float" + "\t" + 'R' + "0" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + "~float" + ":" + "1" + "\t" + 'R' + "1" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticBinaryOperatorCodeVector(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("int", 1);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "int", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("intVectorA", "int", 1, "global"), this.createVariableIdentifierNode("intVectorB", "int", 1, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_IVA + this.EOI + GLOBAL_DIRECTIVE_IVB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "int" + "\t" + 'R' + "0" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "int" + "\t" + 'R' + "0" + "\t" + "_intVectorA" + "\t" + "_intVectorB" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticBinaryOperatorCodeVectorCast(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("float", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "float", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("floatVectorA", "float", 1, "global"), this.createVariableIdentifierNode("intVectorB", "int", 1, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_FVA + this.EOI + GLOBAL_DIRECTIVE_IVB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "1" + "\t" + "_intVectorB" + this.EOI + "\t" + (Object)((Object)OperationCode.CAST) + "\t" + "float" + ":" + "int" + "\t" + 'R' + "1" + "\t" + "_intVectorB" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + "_floatVectorA" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + "_floatVectorA" + "\t" + 'R' + "1" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticBinaryOperatorCodeVectorScalarMixed(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("int", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "int", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("intVectorA", "int", 1, "global"), this.createVariableIdentifierNode("intScalarB", "int", 0, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_IVA + this.EOI + GLOBAL_DIRECTIVE_ISB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "int" + "\t" + 'R' + "1" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)OperationCode.FILL) + "\t" + "int" + "\t" + 'R' + "1" + "\t" + "_intScalarB" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "int" + "\t" + 'R' + "0" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "int" + "\t" + 'R' + "0" + "\t" + "_intVectorA" + "\t" + 'R' + "1" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastVector(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("float", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "float", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("intVectorA", "int", 1, "global"), this.createVariableIdentifierNode("floatScalarB", "float", 0, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_IVA + this.EOI + GLOBAL_DIRECTIVE_FSB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "1" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)OperationCode.CAST) + "\t" + "float" + ":" + "int" + "\t" + 'R' + "1" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "2" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)OperationCode.FILL) + "\t" + "float" + "\t" + 'R' + "2" + "\t" + "_floatScalarB" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + "_intVectorA" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + 'R' + "1" + "\t" + 'R' + "2" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticBinaryOperatorCodeVectorScalarMixedCastScalar(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("float", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmetic", "float", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("floatVectorA", "float", 1, "global"), this.createVariableIdentifierNode("intScalarB", "int", 0, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_FVA + this.EOI + GLOBAL_DIRECTIVE_ISB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOC) + "\t" + "float" + "\t" + 'R' + "1" + this.EOI + "\t" + (Object)((Object)OperationCode.CAST) + "\t" + "float" + ":" + "int" + "\t" + 'R' + "1" + "\t" + "_intScalarB" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "2" + "\t" + "_floatVectorA" + this.EOI + "\t" + (Object)((Object)OperationCode.FILL) + "\t" + "float" + "\t" + 'R' + "2" + "\t" + 'R' + "1" + this.EOI + "\t" + (Object)((Object)OperationCode.ALLOCR) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + "_floatVectorA" + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "float" + "\t" + 'R' + "0" + "\t" + "_floatVectorA" + "\t" + 'R' + "2" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    @Test
    public void testGenerateArithmeticCompoundAssignmentOperatorCode() {
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeScalar("+=", 6000, OperationCode.ADD);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeScalar("-=", 6000, OperationCode.SUB);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeScalar("*=", 6000, OperationCode.MUL);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeScalar("/=", 6000, OperationCode.DIV);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeScalar("%=", 6000, OperationCode.REM);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeVector("+=", 6000, OperationCode.ADD);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeVector("-=", 6000, OperationCode.SUB);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeVector("*=", 6000, OperationCode.MUL);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeVector("/=", 6000, OperationCode.DIV);
        this.testGenerateArithmeticCompoundAssignmentOperatorCodeVector("%=", 6000, OperationCode.REM);
    }

    public void testGenerateArithmeticCompoundAssignmentOperatorCodeScalar(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("int", 0);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmeticCompoundAssignment", "int", 0);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("intScalarA", "int", 1, "global"), this.createVariableIdentifierNode("intScalarB", "int", 1, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_ISA + this.EOI + GLOBAL_DIRECTIVE_ISB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "int" + "\t" + "_intScalarA" + "\t" + "_intScalarA" + "\t" + "_intScalarB" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }

    public void testGenerateArithmeticCompoundAssignmentOperatorCodeVector(String symbol, int priority, OperationCode operationCode) {
        AstNode rootNode = this.createRootNode();
        AstNode exprNode = this.createExpressionNode("int", 1);
        AstNode operatorNode = this.createOperatorNode(symbol, priority, "binary", "arithmeticCompoundAssignment", "int", 1);
        AstNode[] operandNodes = new AstNode[]{this.createVariableIdentifierNode("intVectorA", "int", 1, "global"), this.createVariableIdentifierNode("intVectorB", "int", 1, "global")};
        rootNode.addChildNode(exprNode);
        exprNode.addChildNode(operatorNode);
        operatorNode.addChildNodes(operandNodes);
        String generatedCode = new CodeGenerator().generate(rootNode);
        String expectedCode = String.valueOf(this.HEADER) + GLOBAL_DIRECTIVE_IVA + this.EOI + GLOBAL_DIRECTIVE_IVB + this.EOI + this.META + this.EOI + "\t" + (Object)((Object)operationCode) + "\t" + "int" + "\t" + "_intVectorA" + "\t" + "_intVectorA" + "\t" + "_intVectorB" + this.EOI + this.END_CODE;
        Assert.assertEquals((Object)expectedCode.replace(AssemblyWord.LINE_SEPARATOR, ""), (Object)generatedCode.replace(AssemblyWord.LINE_SEPARATOR, ""));
    }
}

