/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.CodeGenerator;
import org.vcssl.nano.compiler.LexicalAnalyzer;
import org.vcssl.nano.compiler.Parser;
import org.vcssl.nano.compiler.Preprocessor;
import org.vcssl.nano.compiler.SemanticAnalyzer;
import org.vcssl.nano.compiler.Token;
import org.vcssl.nano.interconnect.Interconnect;

public class Compiler {
    public String compile(String[] stringArray, String[] stringArray2, Interconnect interconnect) throws VnanoException {
        if (stringArray.length != stringArray2.length) {
            throw new VnanoFatalException("Array-lengths of \"scripts\" and \"names\" arguments are mismatching.");
        }
        Map<String, Object> map = interconnect.getOptionMap();
        int n = stringArray.length;
        boolean bl = (Boolean)map.get("EVAL_INT_LITERAL_AS_FLOAT");
        boolean bl2 = (Boolean)map.get("DUMPER_ENABLED");
        String string = (String)map.get("DUMPER_TARGET");
        boolean bl3 = string.equals("ALL");
        PrintStream printStream = (PrintStream)map.get("DUMPER_OUTPUT_STREAM");
        if (bl2 && (bl3 || string.equals("INPUTTED_CODE"))) {
            this.dumpInputtedCode(stringArray, stringArray2, bl3, printStream);
        }
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = new Preprocessor().preprocess(stringArray[i]);
        }
        if (bl2 && (bl3 || string.equals("PREPROCESSED_CODE"))) {
            this.dumpPreprocessedCode(stringArray3, stringArray2, bl3, printStream);
        }
        LexicalAnalyzer lexicalAnalyzer = new LexicalAnalyzer();
        Token[][] tokenArrayArray = new Token[n][];
        for (int i = 0; i < n; ++i) {
            tokenArrayArray[i] = lexicalAnalyzer.analyze(stringArray3[i], stringArray2[i]);
        }
        if (bl) {
            tokenArrayArray[n - 1] = this.replaceDataTypeOfLiteralTokens(tokenArrayArray[n - 1], "int", "float");
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i = 0; i < n; ++i) {
            for (Token token : tokenArrayArray[i]) {
                arrayList.add(token);
            }
        }
        Token[] tokenArray = arrayList.toArray(new Token[0]);
        if (bl2 && (bl3 || string.equals("TOKEN"))) {
            this.dumpTokens(tokenArray, bl3, printStream);
        }
        AstNode astNode = new Parser().parse(tokenArray);
        if (bl2 && (bl3 || string.equals("PARSED_AST"))) {
            this.dumpParsedAst(astNode, bl3, printStream);
        }
        AstNode astNode2 = new SemanticAnalyzer().analyze(astNode, interconnect);
        if (bl2 && (bl3 || string.equals("ANALYZED_AST"))) {
            this.dumpAnalyzedAst(astNode2, bl3, printStream);
        }
        String string2 = new CodeGenerator().generate(astNode2);
        if (bl2 && (bl3 || string.equals("ASSEMBLY_CODE"))) {
            this.dumpAssemblyCode(string2, bl3, printStream);
        }
        return string2;
    }

    private void dumpInputtedCode(String[] stringArray, String[] stringArray2, boolean bl, PrintStream printStream) {
        int n = stringArray2.length;
        if (bl) {
            printStream.println("================================================================================");
            printStream.println("= Inputted Code");
            printStream.println("= - Input  of: org.vcssl.nano.compiler.Preprocessor");
            printStream.println("================================================================================");
        }
        for (int i = 0; i < n; ++i) {
            if (2 <= n) {
                printStream.println("( " + stringArray2[i] + ")");
            }
            printStream.println(stringArray[i]);
        }
        if (bl) {
            printStream.println("");
        }
    }

    private void dumpPreprocessedCode(String[] stringArray, String[] stringArray2, boolean bl, PrintStream printStream) {
        int n = stringArray2.length;
        if (bl) {
            printStream.println("================================================================================");
            printStream.println("= Preprocessed Code");
            printStream.println("= - Output of: org.vcssl.nano.compiler.Preprocessor");
            printStream.println("= - Input  of: org.vcssl.nano.compiler.LexicalAnalyzer");
            printStream.println("================================================================================");
        }
        for (int i = 0; i < n; ++i) {
            if (2 <= n) {
                printStream.println("(" + stringArray2[i] + ")");
            }
            printStream.println(stringArray[i]);
        }
        if (bl) {
            printStream.println("");
        }
    }

    private void dumpTokens(Token[] tokenArray, boolean bl, PrintStream printStream) {
        if (bl) {
            printStream.println("================================================================================");
            printStream.println("= Tokens");
            printStream.println("= - Output of: org.vcssl.nano.compiler.LexicalAnalyzer");
            printStream.println("= - Input  of: org.vcssl.nano.compiler.Parser");
            printStream.println("================================================================================");
        }
        for (Token token : tokenArray) {
            printStream.println(token.toString());
        }
        if (bl) {
            printStream.println("");
        }
    }

    private void dumpParsedAst(AstNode astNode, boolean bl, PrintStream printStream) {
        if (bl) {
            printStream.println("================================================================================");
            printStream.println("= Parsed AST");
            printStream.println("= - Output of: org.vcssl.nano.compiler.Parser");
            printStream.println("= - Input  of: org.vcssl.nano.compiler.SemanticAnalyzer");
            printStream.println("================================================================================");
        }
        printStream.print(astNode.dump());
        if (bl) {
            printStream.println("");
        }
    }

    private void dumpAnalyzedAst(AstNode astNode, boolean bl, PrintStream printStream) {
        if (bl) {
            printStream.println("================================================================================");
            printStream.println("= Analyzed AST");
            printStream.println("= - Output of: org.vcssl.nano.compiler.SemanticAnalyzer");
            printStream.println("= - Input  of: org.vcssl.nano.compiler.CodeGenerator");
            printStream.println("================================================================================");
        }
        printStream.print(astNode.dump());
        if (bl) {
            printStream.println("");
        }
    }

    private void dumpAssemblyCode(String string, boolean bl, PrintStream printStream) {
        if (bl) {
            printStream.println("================================================================================");
            printStream.println("= VRIL Assembly Code");
            printStream.println("= - Output of: org.vcssl.nano.compiler.CodeGenerator");
            printStream.println("= - Input  of: org.vcssl.nano.vm.assembler.Assembler");
            printStream.println("================================================================================");
        }
        printStream.print(string);
        if (bl) {
            printStream.println("");
        }
    }

    private Token[] replaceDataTypeOfLiteralTokens(Token[] tokenArray, String string, String string2) {
        int n = tokenArray.length;
        Token[] tokenArray2 = new Token[n];
        for (int i = 0; i < n; ++i) {
            Token token = tokenArray[i].clone();
            if (token.getType() == Token.Type.LEAF && token.getAttribute(AttributeKey.LEAF_TYPE).equals("literal") && token.getAttribute(AttributeKey.DATA_TYPE).equals("int")) {
                token.setAttribute(AttributeKey.DATA_TYPE, "float");
            }
            tokenArray2[i] = token;
        }
        return tokenArray2;
    }
}

