/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.Token;
import org.vcssl.nano.spec.ErrorType;

public class LexicalChecker {
    protected void checkTokensAfterControlStatement(Token[] tokenArray, int n, boolean bl) throws VnanoException {
        Token token = tokenArray[n];
        String string = token.getValue();
        int n2 = n + 1;
        if (string.equals("if") || string.equals("while") || string.equals("for")) {
            if (tokenArray.length <= n + 1 || !tokenArray[n + 1].getValue().equals("(")) {
                throw new VnanoException(ErrorType.NO_OPEN_PARENTHESIS_OF_CONTROL_STATEMENT, token.getValue(), token.getFileName(), token.getLineNumber());
            }
            int n3 = 0;
            while (true) {
                Token token2;
                if ((token2 = tokenArray[n2]).getValue().equals("(")) {
                    ++n3;
                }
                if (token2.getValue().equals(")")) {
                    --n3;
                }
                if (n3 == 0) break;
                if (n2 == tokenArray.length - 1 || token2.getValue().equals("{") || token2.getValue().equals("}") || !bl && token2.getValue().equals(";")) {
                    throw new VnanoException(ErrorType.NO_CLOSING_PARENTHESIS_OF_CONTROL_STATEMENT, token.getValue(), token.getFileName(), token.getLineNumber());
                }
                ++n2;
            }
            ++n2;
        }
        if (string.equals("else") && tokenArray[n2].getValue().equals("if")) {
            return;
        }
        if (string.equals("if") || string.equals("else") || string.equals("for") || string.equals("while")) {
            if (n2 == tokenArray.length - 1 || !tokenArray[n2].getValue().equals("{")) {
                throw new VnanoException(ErrorType.NO_BLOCK_AFTER_CONTROL_STATEMENT, token.getValue(), token.getFileName(), token.getLineNumber());
            }
            return;
        }
    }

    protected void checkControlStatementTokens(Token[] tokenArray) throws VnanoException {
        Token token = tokenArray[0];
        int n = token.getLineNumber();
        String string = token.getFileName();
        if (token.getValue().equals("if")) {
            if (tokenArray.length == 3) {
                throw new VnanoException(ErrorType.NO_CONDITION_EXPRESSION_OF_IF_STATEMENT, string, n);
            }
        } else if (token.getValue().equals("while")) {
            if (tokenArray.length == 3) {
                throw new VnanoException(ErrorType.NO_CONDITION_EXPRESSION_OF_WHILE_STATEMENT, string, n);
            }
        } else if (token.getValue().equals("for")) {
            int n2 = Token.getIndexOf(tokenArray, ";", 0);
            int n3 = Token.getIndexOf(tokenArray, ";", n2 + 1);
            if (n2 < 0 || n3 < 0) {
                throw new VnanoException(ErrorType.ELEMENTS_OF_FOR_STATEMENT_IS_DEFICIENT, string, n);
            }
        } else if (!token.getValue().equals("return")) {
            if (token.getValue().equals("else") || token.getValue().equals("break") || token.getValue().equals("continue")) {
                if (tokenArray.length > 1) {
                    throw new VnanoException(ErrorType.TOO_MANY_TOKENS_FOR_CONTROL_STATEMENT, token.getValue(), string, n);
                }
            } else {
                throw new VnanoFatalException("Unknown controll statement: " + token.getValue());
            }
        }
    }

    protected void checkTokensInExpression(Token[] tokenArray) throws VnanoException {
        this.checkParenthesisOpeningClosings(tokenArray);
        this.checkSubscriptOpeningClosings(tokenArray);
        this.checkTypeOfTokensInExpression(tokenArray);
        this.checkEmptyParenthesesInExpression(tokenArray);
        this.checkLocationsOfOperatorsAndLeafsInExpression(tokenArray);
    }

    protected void checkParenthesisOpeningClosings(Token[] tokenArray) throws VnanoException {
        int n = tokenArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Token token = tokenArray[i];
            boolean bl2 = token.getType() == Token.Type.PARENTHESIS;
            boolean bl3 = token.getType() == Token.Type.OPERATOR && token.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("call");
            boolean bl4 = bl = token.getType() == Token.Type.OPERATOR && token.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("cast");
            if (bl2 || bl3 || bl) {
                if (token.getValue().equals("(")) {
                    ++n2;
                } else if (token.getValue().equals(")")) {
                    --n2;
                }
            }
            if (n2 >= 0) continue;
            throw new VnanoException(ErrorType.OPENING_PARENTHESES_IS_DEFICIENT, tokenArray[0].getFileName(), tokenArray[0].getLineNumber());
        }
        if (n2 > 0) {
            throw new VnanoException(ErrorType.CLOSING_PARENTHESES_IS_DEFICIENT, tokenArray[0].getFileName(), tokenArray[0].getLineNumber());
        }
    }

    protected void checkSubscriptOpeningClosings(Token[] tokenArray) throws VnanoException {
        int n = tokenArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Token token = tokenArray[i];
            boolean bl2 = bl = token.getType() == Token.Type.OPERATOR && token.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("subscript");
            if (bl) {
                if (token.getValue().equals("[")) {
                    ++n2;
                } else if (token.getValue().equals("]")) {
                    --n2;
                }
            }
            if (n2 >= 0) continue;
            throw new VnanoException(ErrorType.OPENING_SUBSCRIPT_OPERATOR_IS_DEFICIENT, tokenArray[0].getFileName(), tokenArray[0].getLineNumber());
        }
        if (n2 > 0) {
            throw new VnanoException(ErrorType.CLOSING_SUBSCRIPT_OPERATOR_IS_DEFICIENT, tokenArray[0].getFileName(), tokenArray[0].getLineNumber());
        }
    }

    protected void checkTypeOfTokensInExpression(Token[] tokenArray) throws VnanoException {
        block7: for (Token token : tokenArray) {
            switch (token.getType()) {
                case OPERATOR: {
                    continue block7;
                }
                case LEAF: {
                    continue block7;
                }
                case PARENTHESIS: {
                    continue block7;
                }
                case DATA_TYPE: {
                    continue block7;
                }
                case BLOCK: {
                    throw new VnanoException(ErrorType.STATEMENT_END_IS_NOT_FOUND, token.getValue(), token.getFileName(), token.getLineNumber());
                }
                default: {
                    throw new VnanoException(ErrorType.INVALID_TYPE_TOKEN_IN_EXPRESSION, token.getValue(), token.getFileName(), token.getLineNumber());
                }
            }
        }
    }

    protected void checkEmptyParenthesesInExpression(Token[] tokenArray) throws VnanoException {
        int n = tokenArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Token token = tokenArray[i];
            if (token.getType() == Token.Type.PARENTHESIS) {
                if (token.getValue().equals("(")) {
                    n2 = 0;
                    continue;
                }
                if (!token.getValue().equals(")") || n2 != 0) continue;
                throw new VnanoException(ErrorType.NO_PARTIAL_EXPRESSION, token.getFileName(), token.getLineNumber());
            }
            ++n2;
        }
    }

    protected void checkLocationsOfOperatorsAndLeafsInExpression(Token[] tokenArray) throws VnanoException {
        int n = tokenArray.length;
        block0: for (int i = 0; i < n; ++i) {
            boolean bl;
            Token token = tokenArray[i];
            boolean bl2 = i != n - 1 && tokenArray[i + 1].getType() == Token.Type.LEAF;
            boolean bl3 = i != 0 && tokenArray[i - 1].getType() == Token.Type.LEAF;
            boolean bl4 = i < n - 1 && tokenArray[i + 1].getType() == Token.Type.PARENTHESIS && tokenArray[i + 1].getValue().equals("(");
            boolean bl5 = i != 0 && tokenArray[i - 1].getType() == Token.Type.PARENTHESIS && tokenArray[i - 1].getValue().equals(")");
            boolean bl6 = i < n - 1 && tokenArray[i + 1].getType() == Token.Type.OPERATOR && tokenArray[i + 1].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("multiary");
            boolean bl7 = i != 0 && tokenArray[i - 1].getType() == Token.Type.OPERATOR && tokenArray[i - 1].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("multialyEnd");
            boolean bl8 = i < n - 1 && tokenArray[i + 1].getType() == Token.Type.OPERATOR && tokenArray[i + 1].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("prefix");
            boolean bl9 = i != 0 && tokenArray[i - 1].getType() == Token.Type.OPERATOR && tokenArray[i - 1].getAttribute(AttributeKey.OPERATOR_SYNTAX).equals("postfix");
            boolean bl10 = bl = i < n - 1 && tokenArray[i + 1].getType() == Token.Type.DATA_TYPE;
            if (token.getType() == Token.Type.OPERATOR) {
                String string = token.getAttribute(AttributeKey.OPERATOR_SYNTAX);
                String string2 = token.getAttribute(AttributeKey.OPERATOR_EXECUTOR);
                if (string.equals("prefix")) {
                    if (string2.equals("cast") && token.getValue().equals("(")) {
                        if (!bl) {
                            throw new VnanoException(ErrorType.DATA_TYPE_IS_MISSING_AT_RIGHT, token.getValue(), token.getFileName(), token.getLineNumber());
                        }
                        for (int j = i + 2; j < n; ++j) {
                            boolean bl11;
                            Token token2 = tokenArray[j];
                            boolean bl12 = token2.getType() == Token.Type.OPERATOR && token2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("subscript");
                            boolean bl13 = bl11 = token2.getType() == Token.Type.OPERATOR && token2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("cast") && token2.getValue().equals(")");
                            if (bl11) {
                                i = j + 1;
                                continue block0;
                            }
                            if (bl12) continue;
                            throw new VnanoException(ErrorType.CLOSE_PARENTHESIS_IS_MISSING_AT_RIGHT, tokenArray[j - 1].getValue(), token.getFileName(), token.getLineNumber());
                        }
                        continue;
                    }
                    if (!(bl2 || bl4 || bl6 || bl8)) {
                        throw new VnanoException(ErrorType.OPERAND_IS_MISSING_AT_RIGHT, token.getValue(), token.getFileName(), token.getLineNumber());
                    }
                }
                if (!(!string.equals("postfix") || bl3 || bl5 || bl7 || bl9)) {
                    throw new VnanoException(ErrorType.OPERAND_IS_MISSING_AT_LEFT, token.getValue(), token.getFileName(), token.getLineNumber());
                }
                if (string.equals("binary") || string.equals("multialySeparator")) {
                    if (!(bl2 || bl4 || bl8 || bl6)) {
                        throw new VnanoException(ErrorType.OPERAND_IS_MISSING_AT_RIGHT, token.getValue(), token.getFileName(), token.getLineNumber());
                    }
                    if (!(bl3 || bl5 || bl9 || bl7)) {
                        throw new VnanoException(ErrorType.OPERAND_IS_MISSING_AT_LEFT, token.getValue(), token.getFileName(), token.getLineNumber());
                    }
                }
            }
            if (token.getType() != Token.Type.LEAF) continue;
            if (bl4 || bl2) {
                throw new VnanoException(ErrorType.OPERATOR_IS_MISSING_AT_RIGHT, new String[]{token.getValue(), tokenArray[i + 1].getValue()}, token.getFileName(), token.getLineNumber());
            }
            if (!bl5 && !bl3 && !bl7) continue;
            throw new VnanoException(ErrorType.OPERATOR_IS_MISSING_AT_LEFT, new String[]{tokenArray[i - 1].getValue(), token.getValue()}, token.getFileName(), token.getLineNumber());
        }
    }
}

