/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.Parser;
import org.vcssl.nano.compiler.Token;

public class ParserTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    private Token createLiteralToken(String word, String dataTypeName) {
        Token token = new Token(word, 123, "Test.vnano");
        token.setType(Token.Type.LEAF);
        token.setAttribute(AttributeKey.LEAF_TYPE, "literal");
        token.setAttribute(AttributeKey.DATA_TYPE, dataTypeName);
        return token;
    }

    private Token createVariableIdentifierToken(String word) {
        Token token = new Token(word, 123, "Test.vnano");
        token.setType(Token.Type.LEAF);
        token.setAttribute(AttributeKey.LEAF_TYPE, "variableIdentifier");
        return token;
    }

    private Token createDataTypeToken(String word) {
        Token token = new Token(word, 123, "Test.vnano");
        token.setType(Token.Type.DATA_TYPE);
        return token;
    }

    private Token createOperatorToken(String word, int priority, String associativity, String syntax, String executor) {
        Token token = new Token(word, 124, "Test.vnano");
        token.setType(Token.Type.OPERATOR);
        token.setPrecedence(priority);
        token.setAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY, associativity);
        token.setAttribute(AttributeKey.OPERATOR_SYNTAX, syntax);
        token.setAttribute(AttributeKey.OPERATOR_EXECUTOR, executor);
        return token;
    }

    private Token createParenthesisToken(String word) {
        Token token = new Token(word, 124, "Test.vnano");
        token.setType(Token.Type.PARENTHESIS);
        if (word.equals("(")) {
            token.setPrecedence(-1);
        } else {
            token.setPrecedence(10000000);
        }
        return token;
    }

    private Token createBlockToken(String word) {
        Token token = new Token(word, 123, "Test.vnano");
        token.setType(Token.Type.BLOCK);
        return token;
    }

    private Token createControlToken(String word) {
        Token token = new Token(word, 123, "Test.vnano");
        token.setType(Token.Type.CONTROL);
        return token;
    }

    private Token createEndToken() {
        Token token = new Token(";", 123, "Test.vnano");
        token.setType(Token.Type.END_OF_STATEMENT);
        return token;
    }

    private void dumpTokens(Token[] tokens) {
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            System.out.println(token);
            ++n2;
        }
    }

    private void checkLiteralNode(AstNode node, String word) {
        Assert.assertEquals((long)0L, (long)node.getChildNodes().length);
        Assert.assertEquals((Object)((Object)AstNode.Type.LEAF), (Object)((Object)node.getType()));
        Assert.assertEquals((Object)"literal", (Object)node.getAttribute(AttributeKey.LEAF_TYPE));
        Assert.assertEquals((Object)word, (Object)node.getAttribute(AttributeKey.LITERAL_VALUE));
    }

    private void checkVariableIdentifierNode(AstNode node, String word) {
        Assert.assertEquals((long)0L, (long)node.getChildNodes().length);
        Assert.assertEquals((Object)((Object)AstNode.Type.LEAF), (Object)((Object)node.getType()));
        Assert.assertEquals((Object)"variableIdentifier", (Object)node.getAttribute(AttributeKey.LEAF_TYPE));
        Assert.assertEquals((Object)word, (Object)node.getAttribute(AttributeKey.IDENTIFIER_VALUE));
    }

    private void checkOperatorNode(AstNode node, String symbol, int priority, String associativity, String syntax, String executor) {
        Assert.assertEquals((Object)((Object)AstNode.Type.OPERATOR), (Object)((Object)node.getType()));
        Assert.assertEquals((Object)symbol, (Object)node.getAttribute(AttributeKey.OPERATOR_SYMBOL));
        Assert.assertEquals((Object)associativity, (Object)node.getAttribute(AttributeKey.OPERATOR_ASSOCIATIVITY));
        Assert.assertEquals((Object)syntax, (Object)node.getAttribute(AttributeKey.OPERATOR_SYNTAX));
        Assert.assertEquals((Object)executor, (Object)node.getAttribute(AttributeKey.OPERATOR_EXECUTOR));
        Assert.assertEquals((Object)Integer.toString(priority), (Object)node.getAttribute(AttributeKey.OPERATOR_PRECEDENCE));
    }

    @Test
    public void testParseVariableDeclarationStatementScalar() throws VnanoException {
        Token[] tokens = new Token[]{this.createDataTypeToken("int"), this.createVariableIdentifierToken("x"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode varNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.VARIABLE), (Object)((Object)varNode.getType()));
        Assert.assertEquals((Object)"int", (Object)varNode.getAttribute(AttributeKey.DATA_TYPE));
        Assert.assertEquals((Object)"x", (Object)varNode.getAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"0", (Object)varNode.getAttribute(AttributeKey.ARRAY_RANK));
    }

    public void testParseVariableDeclarationStatementArray1D() throws VnanoException {
        Token[] tokens = new Token[]{this.createDataTypeToken("int"), this.createVariableIdentifierToken("x"), this.createOperatorToken("[", 1000, "left", "multiary", "subscript"), this.createLiteralToken("2", "int"), this.createOperatorToken("]", 10000000, "left", "multiary", "subscript"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode varNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.VARIABLE), (Object)((Object)varNode.getType()));
        Assert.assertEquals((Object)"int", (Object)varNode.getAttribute(AttributeKey.DATA_TYPE));
        Assert.assertEquals((Object)"x", (Object)varNode.getAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"1", (Object)varNode.getAttribute(AttributeKey.ARRAY_RANK));
        AstNode lengthNode = varNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.LENGTHS), (Object)((Object)lengthNode.getType()));
        Assert.assertEquals((long)1L, (long)lengthNode.getChildNodes().length);
        AstNode lengthExprNode = lengthNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)lengthExprNode.getType()));
        Assert.assertEquals((long)1L, (long)lengthExprNode.getChildNodes().length);
        this.checkLiteralNode(lengthExprNode.getChildNodes()[0], "2");
    }

    @Test
    public void testParseVariableDeclarationStatementArray1DWithLengthExpr() throws VnanoException {
        Token[] tokens = new Token[]{this.createDataTypeToken("int"), this.createVariableIdentifierToken("x"), this.createOperatorToken("[", 1000, "left", "multiary", "subscript"), this.createLiteralToken("1", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("2", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("3", "int"), this.createOperatorToken("]", 10000000, "left", "multiary", "subscript"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode varNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.VARIABLE), (Object)((Object)varNode.getType()));
        Assert.assertEquals((Object)"int", (Object)varNode.getAttribute(AttributeKey.DATA_TYPE));
        Assert.assertEquals((Object)"x", (Object)varNode.getAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"1", (Object)varNode.getAttribute(AttributeKey.ARRAY_RANK));
        AstNode lengthNode = varNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.LENGTHS), (Object)((Object)lengthNode.getType()));
        Assert.assertEquals((long)1L, (long)lengthNode.getChildNodes().length);
        AstNode lengthExprNode = lengthNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)lengthExprNode.getType()));
        Assert.assertEquals((long)1L, (long)lengthExprNode.getChildNodes().length);
        AstNode addNode = lengthExprNode.getChildNodes()[0];
        this.checkOperatorNode(addNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(addNode.getChildNodes()[0], "1");
        AstNode mulNode = addNode.getChildNodes()[1];
        this.checkOperatorNode(mulNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(mulNode.getChildNodes()[0], "2");
        this.checkLiteralNode(mulNode.getChildNodes()[1], "3");
    }

    @Test
    public void testParseVariableDeclarationStatementArray3D() throws VnanoException {
        Token[] tokens = new Token[]{this.createDataTypeToken("int"), this.createVariableIdentifierToken("x"), this.createOperatorToken("[", 1000, "left", "multiary", "subscript"), this.createLiteralToken("2", "int"), this.createOperatorToken("][", 10000000, "left", "multiary", "subscript"), this.createLiteralToken("3", "int"), this.createOperatorToken("][", 10000000, "left", "multiary", "subscript"), this.createLiteralToken("4", "int"), this.createOperatorToken("]", 10000000, "left", "multiary", "subscript"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode varNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.VARIABLE), (Object)((Object)varNode.getType()));
        Assert.assertEquals((Object)"int", (Object)varNode.getAttribute(AttributeKey.DATA_TYPE));
        Assert.assertEquals((Object)"x", (Object)varNode.getAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"3", (Object)varNode.getAttribute(AttributeKey.ARRAY_RANK));
        AstNode lengthNode = varNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.LENGTHS), (Object)((Object)lengthNode.getType()));
        Assert.assertEquals((long)3L, (long)lengthNode.getChildNodes().length);
        AstNode lengthExprNode0 = lengthNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)lengthExprNode0.getType()));
        Assert.assertEquals((long)1L, (long)lengthExprNode0.getChildNodes().length);
        this.checkLiteralNode(lengthExprNode0.getChildNodes()[0], "2");
        AstNode lengthExprNode1 = lengthNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)lengthExprNode1.getType()));
        Assert.assertEquals((long)1L, (long)lengthExprNode1.getChildNodes().length);
        this.checkLiteralNode(lengthExprNode1.getChildNodes()[0], "3");
        AstNode lengthExprNode2 = lengthNode.getChildNodes()[2];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)lengthExprNode2.getType()));
        Assert.assertEquals((long)1L, (long)lengthExprNode2.getChildNodes().length);
        this.checkLiteralNode(lengthExprNode2.getChildNodes()[0], "4");
    }

    @Test
    public void testParseVariableDeclarationStatementWithInitExpr() throws VnanoException {
        Token[] tokens = new Token[]{this.createDataTypeToken("int"), this.createVariableIdentifierToken("x"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createLiteralToken("1", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("2", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("3", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode varNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.VARIABLE), (Object)((Object)varNode.getType()));
        Assert.assertEquals((Object)"int", (Object)varNode.getAttribute(AttributeKey.DATA_TYPE));
        Assert.assertEquals((Object)"x", (Object)varNode.getAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"0", (Object)varNode.getAttribute(AttributeKey.ARRAY_RANK));
        AstNode initExprNode = varNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)initExprNode.getType()));
        Assert.assertEquals((long)1L, (long)initExprNode.getChildNodes().length);
        AstNode assignNode = initExprNode.getChildNodes()[0];
        this.checkOperatorNode(assignNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(assignNode.getChildNodes()[0], "x");
        AstNode addNode = assignNode.getChildNodes()[1];
        this.checkOperatorNode(addNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(addNode.getChildNodes()[0], "1");
        AstNode mulNode = addNode.getChildNodes()[1];
        this.checkOperatorNode(mulNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(mulNode.getChildNodes()[0], "2");
        this.checkLiteralNode(mulNode.getChildNodes()[1], "3");
    }

    @Test
    public void testBlockStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createBlockToken("{"), this.createLiteralToken("1", "int"), this.createEndToken(), this.createLiteralToken("2", "int"), this.createEndToken(), this.createBlockToken("{"), this.createLiteralToken("3", "int"), this.createEndToken(), this.createLiteralToken("4", "int"), this.createEndToken(), this.createBlockToken("{"), this.createLiteralToken("5", "int"), this.createEndToken(), this.createBlockToken("}"), this.createLiteralToken("6", "int"), this.createEndToken(), this.createBlockToken("}"), this.createLiteralToken("7", "int"), this.createEndToken(), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)rootNode.getChildNodes()[0].getType()));
        AstNode blockNode = rootNode.getChildNodes()[0];
        AstNode[] nodesInBlock = blockNode.getChildNodes();
        AstNode exprNode = nodesInBlock[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "1");
        exprNode = nodesInBlock[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "2");
        exprNode = nodesInBlock[2];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)exprNode.getType()));
        exprNode = nodesInBlock[3];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "7");
        blockNode = nodesInBlock[2];
        nodesInBlock = blockNode.getChildNodes();
        exprNode = nodesInBlock[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "3");
        exprNode = nodesInBlock[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "4");
        exprNode = nodesInBlock[2];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)exprNode.getType()));
        exprNode = nodesInBlock[3];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "6");
        blockNode = nodesInBlock[2];
        nodesInBlock = blockNode.getChildNodes();
        exprNode = nodesInBlock[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)exprNode.getType()));
        this.checkLiteralNode(exprNode.getChildNodes()[0], "5");
    }

    @Test
    public void testIfStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("if"), this.createParenthesisToken("("), this.createVariableIdentifierToken("x"), this.createOperatorToken("==", 4100, "left", "binary", "comparison"), this.createLiteralToken("2", "int"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)2L, (long)rootNode.getChildNodes().length);
        AstNode ifNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.IF), (Object)((Object)ifNode.getType()));
        Assert.assertEquals((long)1L, (long)ifNode.getChildNodes().length);
        AstNode conditionExprNode = ifNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        AstNode equalNode = conditionExprNode.getChildNodes()[0];
        this.checkOperatorNode(equalNode, "==", 4100, "left", "binary", "comparison");
        Assert.assertEquals((long)2L, (long)equalNode.getChildNodes().length);
        this.checkVariableIdentifierNode(equalNode.getChildNodes()[0], "x");
        this.checkLiteralNode(equalNode.getChildNodes()[1], "2");
        AstNode blockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)blockNode.getType()));
        Assert.assertEquals((long)0L, (long)blockNode.getChildNodes().length);
    }

    @Test
    public void testElseStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("if"), this.createParenthesisToken("("), this.createVariableIdentifierToken("x"), this.createOperatorToken("==", 4100, "left", "binary", "comparison"), this.createLiteralToken("2", "int"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createLiteralToken("1", "int"), this.createEndToken(), this.createBlockToken("}"), this.createControlToken("else"), this.createBlockToken("{"), this.createLiteralToken("2", "int"), this.createEndToken(), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)4L, (long)rootNode.getChildNodes().length);
        AstNode ifNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.IF), (Object)((Object)ifNode.getType()));
        Assert.assertEquals((long)1L, (long)ifNode.getChildNodes().length);
        AstNode conditionExprNode = ifNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        AstNode equalNode = conditionExprNode.getChildNodes()[0];
        this.checkOperatorNode(equalNode, "==", 4100, "left", "binary", "comparison");
        Assert.assertEquals((long)2L, (long)equalNode.getChildNodes().length);
        this.checkVariableIdentifierNode(equalNode.getChildNodes()[0], "x");
        this.checkLiteralNode(equalNode.getChildNodes()[1], "2");
        AstNode ifBlockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)ifBlockNode.getType()));
        Assert.assertEquals((long)1L, (long)ifBlockNode.getChildNodes().length);
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)ifBlockNode.getChildNodes()[0].getType()));
        this.checkLiteralNode(ifBlockNode.getChildNodes()[0].getChildNodes()[0], "1");
        AstNode elseNode = rootNode.getChildNodes()[2];
        Assert.assertEquals((Object)((Object)AstNode.Type.ELSE), (Object)((Object)elseNode.getType()));
        Assert.assertEquals((long)0L, (long)elseNode.getChildNodes().length);
        AstNode elseBlockNode = rootNode.getChildNodes()[3];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)elseBlockNode.getType()));
        Assert.assertEquals((long)1L, (long)elseBlockNode.getChildNodes().length);
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)elseBlockNode.getChildNodes()[0].getType()));
        this.checkLiteralNode(elseBlockNode.getChildNodes()[0].getChildNodes()[0], "2");
    }

    @Test
    public void testWhileStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("while"), this.createParenthesisToken("("), this.createVariableIdentifierToken("x"), this.createOperatorToken("==", 4100, "left", "binary", "comparison"), this.createLiteralToken("2", "int"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)2L, (long)rootNode.getChildNodes().length);
        AstNode ifNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.WHILE), (Object)((Object)ifNode.getType()));
        Assert.assertEquals((long)1L, (long)ifNode.getChildNodes().length);
        AstNode conditionExprNode = ifNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        AstNode equalNode = conditionExprNode.getChildNodes()[0];
        this.checkOperatorNode(equalNode, "==", 4100, "left", "binary", "comparison");
        Assert.assertEquals((long)2L, (long)equalNode.getChildNodes().length);
        this.checkVariableIdentifierNode(equalNode.getChildNodes()[0], "x");
        this.checkLiteralNode(equalNode.getChildNodes()[1], "2");
        AstNode blockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)blockNode.getType()));
        Assert.assertEquals((long)0L, (long)blockNode.getChildNodes().length);
    }

    @Test
    public void testForStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("for"), this.createParenthesisToken("("), this.createVariableIdentifierToken("i"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createLiteralToken("0", "int"), this.createEndToken(), this.createVariableIdentifierToken("i"), this.createOperatorToken("<", 4000, "left", "binary", "comparison"), this.createLiteralToken("10", "int"), this.createEndToken(), this.createOperatorToken("++", 2000, "left", "prefix", "arithmetic"), this.createVariableIdentifierToken("i"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)2L, (long)rootNode.getChildNodes().length);
        AstNode forNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.FOR), (Object)((Object)forNode.getType()));
        Assert.assertEquals((long)3L, (long)forNode.getChildNodes().length);
        AstNode initExprNode = forNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)initExprNode.getType()));
        Assert.assertEquals((long)1L, (long)initExprNode.getChildNodes().length);
        AstNode assignNode = initExprNode.getChildNodes()[0];
        this.checkOperatorNode(assignNode, "=", 6000, "right", "binary", "assignment");
        Assert.assertEquals((long)2L, (long)assignNode.getChildNodes().length);
        this.checkVariableIdentifierNode(assignNode.getChildNodes()[0], "i");
        this.checkLiteralNode(assignNode.getChildNodes()[1], "0");
        AstNode conditionExprNode = forNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        AstNode ltNode = conditionExprNode.getChildNodes()[0];
        this.checkOperatorNode(ltNode, "<", 4000, "left", "binary", "comparison");
        Assert.assertEquals((long)2L, (long)ltNode.getChildNodes().length);
        this.checkVariableIdentifierNode(ltNode.getChildNodes()[0], "i");
        this.checkLiteralNode(ltNode.getChildNodes()[1], "10");
        AstNode updateExprNode = forNode.getChildNodes()[2];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)updateExprNode.getType()));
        Assert.assertEquals((long)1L, (long)updateExprNode.getChildNodes().length);
        Assert.assertEquals((long)1L, (long)updateExprNode.getChildNodes().length);
        AstNode incrementNode = updateExprNode.getChildNodes()[0];
        this.checkOperatorNode(incrementNode, "++", 2000, "left", "prefix", "arithmetic");
        this.checkVariableIdentifierNode(incrementNode.getChildNodes()[0], "i");
        AstNode blockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)blockNode.getType()));
        Assert.assertEquals((long)0L, (long)blockNode.getChildNodes().length);
    }

    @Test
    public void testForStatementWithCounterVariableDeclaration() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("for"), this.createParenthesisToken("("), this.createDataTypeToken("int"), this.createVariableIdentifierToken("i"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createLiteralToken("0", "int"), this.createEndToken(), this.createVariableIdentifierToken("i"), this.createOperatorToken("<", 4000, "left", "binary", "comparison"), this.createLiteralToken("10", "int"), this.createEndToken(), this.createOperatorToken("++", 2000, "left", "prefix", "arithmetic"), this.createVariableIdentifierToken("i"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)2L, (long)rootNode.getChildNodes().length);
        AstNode forNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.FOR), (Object)((Object)forNode.getType()));
        Assert.assertEquals((long)3L, (long)forNode.getChildNodes().length);
        AstNode varNode = forNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.VARIABLE), (Object)((Object)varNode.getType()));
        Assert.assertEquals((Object)"int", (Object)varNode.getAttribute(AttributeKey.DATA_TYPE));
        Assert.assertEquals((Object)"i", (Object)varNode.getAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"0", (Object)varNode.getAttribute(AttributeKey.ARRAY_RANK));
        Assert.assertEquals((long)1L, (long)varNode.getChildNodes().length);
        AstNode initExprNode = varNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)initExprNode.getType()));
        Assert.assertEquals((long)1L, (long)initExprNode.getChildNodes().length);
        AstNode assignNode = initExprNode.getChildNodes()[0];
        this.checkOperatorNode(assignNode, "=", 6000, "right", "binary", "assignment");
        Assert.assertEquals((long)2L, (long)assignNode.getChildNodes().length);
        this.checkVariableIdentifierNode(assignNode.getChildNodes()[0], "i");
        this.checkLiteralNode(assignNode.getChildNodes()[1], "0");
        AstNode conditionExprNode = forNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        AstNode ltNode = conditionExprNode.getChildNodes()[0];
        this.checkOperatorNode(ltNode, "<", 4000, "left", "binary", "comparison");
        Assert.assertEquals((long)2L, (long)ltNode.getChildNodes().length);
        this.checkVariableIdentifierNode(ltNode.getChildNodes()[0], "i");
        this.checkLiteralNode(ltNode.getChildNodes()[1], "10");
        AstNode updateExprNode = forNode.getChildNodes()[2];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)updateExprNode.getType()));
        Assert.assertEquals((long)1L, (long)updateExprNode.getChildNodes().length);
        Assert.assertEquals((long)1L, (long)updateExprNode.getChildNodes().length);
        AstNode incrementNode = updateExprNode.getChildNodes()[0];
        this.checkOperatorNode(incrementNode, "++", 2000, "left", "prefix", "arithmetic");
        this.checkVariableIdentifierNode(incrementNode.getChildNodes()[0], "i");
        AstNode blockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)blockNode.getType()));
        Assert.assertEquals((long)0L, (long)blockNode.getChildNodes().length);
    }

    @Test
    public void testContinueStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("while"), this.createParenthesisToken("("), this.createLiteralToken("true", "bool"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createControlToken("continue"), this.createEndToken(), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)2L, (long)rootNode.getChildNodes().length);
        AstNode ifNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.WHILE), (Object)((Object)ifNode.getType()));
        Assert.assertEquals((long)1L, (long)ifNode.getChildNodes().length);
        AstNode conditionExprNode = ifNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        this.checkLiteralNode(conditionExprNode.getChildNodes()[0], "true");
        AstNode blockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)blockNode.getType()));
        Assert.assertEquals((long)1L, (long)blockNode.getChildNodes().length);
        AstNode continueNode = blockNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.CONTINUE), (Object)((Object)continueNode.getType()));
        Assert.assertEquals((long)0L, (long)continueNode.getChildNodes().length);
    }

    @Test
    public void testBreakStatement() throws VnanoException {
        Token[] tokens = new Token[]{this.createControlToken("while"), this.createParenthesisToken("("), this.createLiteralToken("true", "bool"), this.createParenthesisToken(")"), this.createBlockToken("{"), this.createControlToken("break"), this.createEndToken(), this.createBlockToken("}")};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)2L, (long)rootNode.getChildNodes().length);
        AstNode ifNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.WHILE), (Object)((Object)ifNode.getType()));
        Assert.assertEquals((long)1L, (long)ifNode.getChildNodes().length);
        AstNode conditionExprNode = ifNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)conditionExprNode.getType()));
        Assert.assertEquals((long)1L, (long)conditionExprNode.getChildNodes().length);
        this.checkLiteralNode(conditionExprNode.getChildNodes()[0], "true");
        AstNode blockNode = rootNode.getChildNodes()[1];
        Assert.assertEquals((Object)((Object)AstNode.Type.BLOCK), (Object)((Object)blockNode.getType()));
        Assert.assertEquals((long)1L, (long)blockNode.getChildNodes().length);
        AstNode continueNode = blockNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.BREAK), (Object)((Object)continueNode.getType()));
        Assert.assertEquals((long)0L, (long)continueNode.getChildNodes().length);
    }

    @Test
    public void testParseExpressionPrefixOperator() throws VnanoException {
        Token rightToken = this.createVariableIdentifierToken("x");
        Token operatorToken = this.createOperatorToken("++", 2000, "left", "prefix", "arithmetic");
        Token[] tokens = new Token[]{operatorToken, rightToken, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "++", 2000, "left", "prefix", "arithmetic");
        Assert.assertEquals((long)1L, (long)operatorNode.getChildNodes().length);
        AstNode[] operandNodes = operatorNode.getChildNodes();
        this.checkVariableIdentifierNode(operandNodes[0], "x");
    }

    @Test
    public void testParseExpressionPostfixOperator() throws VnanoException {
        Token leftToken = this.createVariableIdentifierToken("x");
        Token operatorToken = this.createOperatorToken("++", 1000, "left", "postfix", "arithmetic");
        Token[] tokens = new Token[]{leftToken, operatorToken, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "++", 1000, "left", "postfix", "arithmetic");
        Assert.assertEquals((long)1L, (long)operatorNode.getChildNodes().length);
        AstNode[] operandNodes = operatorNode.getChildNodes();
        this.checkVariableIdentifierNode(operandNodes[0], "x");
    }

    @Test
    public void testParseExpressionBinaryOperator() throws VnanoException {
        Token leftToken = this.createLiteralToken("1", "int");
        Token rightToken = this.createVariableIdentifierToken("x");
        Token operatorToken = this.createOperatorToken("+", 3100, "left", "binary", "arithmetic");
        Token[] tokens = new Token[]{leftToken, operatorToken, rightToken, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)operatorNode.getChildNodes().length);
        AstNode[] operandNodes = operatorNode.getChildNodes();
        this.checkLiteralNode(operandNodes[0], "1");
        this.checkVariableIdentifierNode(operandNodes[1], "x");
    }

    @Test
    public void testParseExpressionMultiaryOperator() throws VnanoException {
        Token identifierToken = this.createVariableIdentifierToken("func");
        Token operatorBeginToken = this.createOperatorToken("(", 1000, "left", "multiary", "call");
        Token leftOperandToken = this.createLiteralToken("1", "int");
        Token operatorSeparatorToken = this.createOperatorToken(",", 1000, "left", "multialySeparator", "call");
        Token rightOperandToken = this.createVariableIdentifierToken("x");
        Token operatorEndToken = this.createOperatorToken(")", 1000, "left", "multialyEnd", "call");
        Token[] tokens = new Token[]{identifierToken, operatorBeginToken, leftOperandToken, operatorSeparatorToken, rightOperandToken, operatorEndToken, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "(", 1000, "left", "multiary", "call");
        Assert.assertEquals((long)3L, (long)operatorNode.getChildNodes().length);
        AstNode[] operandNodes = operatorNode.getChildNodes();
        this.checkVariableIdentifierNode(operandNodes[0], "func");
        this.checkLiteralNode(operandNodes[1], "1");
        this.checkVariableIdentifierNode(operandNodes[2], "x");
    }

    @Test
    public void testParseExpressionParenthesis1() throws VnanoException {
        Token one = this.createLiteralToken("1", "int");
        Token two = this.createLiteralToken("2", "int");
        Token three = this.createLiteralToken("3", "int");
        Token add = this.createOperatorToken("+", 3100, "left", "binary", "arithmetic");
        Token mul = this.createOperatorToken("*", 3000, "left", "binary", "arithmetic");
        Token open = this.createParenthesisToken("(");
        Token close = this.createParenthesisToken(")");
        Token[] tokens = new Token[]{one, mul, open, two, add, three, close, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode mulNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(mulNode, "*", 3000, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)mulNode.getChildNodes().length);
        this.checkLiteralNode(mulNode.getChildNodes()[0], "1");
        AstNode addNode = mulNode.getChildNodes()[1];
        this.checkOperatorNode(addNode, "+", 3100, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)addNode.getChildNodes().length);
        this.checkLiteralNode(addNode.getChildNodes()[0], "2");
        this.checkLiteralNode(addNode.getChildNodes()[1], "3");
    }

    @Test
    public void testParseExpressionParenthesis2() throws VnanoException {
        Token one = this.createLiteralToken("1", "int");
        Token two = this.createLiteralToken("2", "int");
        Token three = this.createLiteralToken("3", "int");
        Token add = this.createOperatorToken("+", 3100, "left", "binary", "arithmetic");
        Token mul = this.createOperatorToken("*", 3000, "left", "binary", "arithmetic");
        Token open = this.createParenthesisToken("(");
        Token close = this.createParenthesisToken(")");
        Token[] tokens = new Token[]{one, add, open, two, mul, three, close, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode addNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(addNode, "+", 3100, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)addNode.getChildNodes().length);
        this.checkLiteralNode(addNode.getChildNodes()[0], "1");
        AstNode mulNode = addNode.getChildNodes()[1];
        this.checkOperatorNode(mulNode, "*", 3000, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)mulNode.getChildNodes().length);
        this.checkLiteralNode(mulNode.getChildNodes()[0], "2");
        this.checkLiteralNode(mulNode.getChildNodes()[1], "3");
    }

    @Test
    public void testParseExpressionParenthesis3() throws VnanoException {
        Token one = this.createLiteralToken("1", "int");
        Token two = this.createLiteralToken("2", "int");
        Token three = this.createLiteralToken("3", "int");
        Token add = this.createOperatorToken("+", 3100, "left", "binary", "arithmetic");
        Token mul = this.createOperatorToken("*", 3000, "left", "binary", "arithmetic");
        Token open = this.createParenthesisToken("(");
        Token close = this.createParenthesisToken(")");
        Token[] tokens = new Token[]{open, one, add, two, close, mul, three, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode mulNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(mulNode, "*", 3000, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)mulNode.getChildNodes().length);
        this.checkLiteralNode(mulNode.getChildNodes()[1], "3");
        AstNode addNode = mulNode.getChildNodes()[0];
        this.checkOperatorNode(addNode, "+", 3100, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)addNode.getChildNodes().length);
        this.checkLiteralNode(addNode.getChildNodes()[0], "1");
        this.checkLiteralNode(addNode.getChildNodes()[1], "2");
    }

    @Test
    public void testParseExpressionParenthesis4() throws VnanoException {
        Token one = this.createLiteralToken("1", "int");
        Token two = this.createLiteralToken("2", "int");
        Token three = this.createLiteralToken("3", "int");
        Token add = this.createOperatorToken("+", 3100, "left", "binary", "arithmetic");
        Token mul = this.createOperatorToken("*", 3000, "left", "binary", "arithmetic");
        Token open = this.createParenthesisToken("(");
        Token close = this.createParenthesisToken(")");
        Token[] tokens = new Token[]{open, one, mul, two, close, add, three, this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode addNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(addNode, "+", 3100, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)addNode.getChildNodes().length);
        this.checkLiteralNode(addNode.getChildNodes()[1], "3");
        AstNode mulNode = addNode.getChildNodes()[0];
        this.checkOperatorNode(mulNode, "*", 3000, "left", "binary", "arithmetic");
        Assert.assertEquals((long)2L, (long)mulNode.getChildNodes().length);
        this.checkLiteralNode(mulNode.getChildNodes()[0], "1");
        this.checkLiteralNode(mulNode.getChildNodes()[1], "2");
    }

    @Test
    public void testParseExpressionAddAddAddAdd() throws VnanoException {
        Token[] tokens = new Token[]{this.createLiteralToken("1", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("2", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("3", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("4", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("5", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "5");
        operatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "4");
        operatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "3");
        operatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[0], "1");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "2");
    }

    @Test
    public void testParseExpressionAddMulMulAdd() throws VnanoException {
        Token[] tokens = new Token[]{this.createLiteralToken("1", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("2", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("3", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("4", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("5", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "5");
        operatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[0], "1");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "4");
        operatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[0], "2");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "3");
    }

    @Test
    public void testParseExpressionMulAddAddMul() throws VnanoException {
        Token[] tokens = new Token[]{this.createLiteralToken("1", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("2", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("3", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("4", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("5", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        AstNode leftOperatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(leftOperatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(leftOperatorNode.getChildNodes()[1], "3");
        AstNode rightOperatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(rightOperatorNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(rightOperatorNode.getChildNodes()[0], "4");
        this.checkLiteralNode(rightOperatorNode.getChildNodes()[1], "5");
        operatorNode = leftOperatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[0], "1");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "2");
    }

    @Test
    public void testParseExpressionAddMulAddMul() throws VnanoException {
        Token[] tokens = new Token[]{this.createLiteralToken("1", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("2", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("3", "int"), this.createOperatorToken("+", 3100, "left", "binary", "arithmetic"), this.createLiteralToken("4", "int"), this.createOperatorToken("*", 3000, "left", "binary", "arithmetic"), this.createLiteralToken("5", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "+", 3100, "left", "binary", "arithmetic");
        AstNode leftOperatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(leftOperatorNode, "+", 3100, "left", "binary", "arithmetic");
        this.checkLiteralNode(leftOperatorNode.getChildNodes()[0], "1");
        AstNode rightOperatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(rightOperatorNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(rightOperatorNode.getChildNodes()[0], "4");
        this.checkLiteralNode(rightOperatorNode.getChildNodes()[1], "5");
        operatorNode = leftOperatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "*", 3000, "left", "binary", "arithmetic");
        this.checkLiteralNode(operatorNode.getChildNodes()[0], "2");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "3");
    }

    @Test
    public void testParseExpressionDualAssignment() throws VnanoException {
        Token[] tokens = new Token[]{this.createVariableIdentifierToken("x"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createVariableIdentifierToken("y"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createLiteralToken("1", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "x");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "y");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "1");
    }

    @Test
    public void testParseExpressionTrippleAssignment() throws VnanoException {
        Token[] tokens = new Token[]{this.createVariableIdentifierToken("x"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createVariableIdentifierToken("y"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createVariableIdentifierToken("z"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createLiteralToken("1", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "x");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "y");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "z");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "1");
    }

    @Test
    public void testParseExpressionQuadrupleAssignment() throws VnanoException {
        Token[] tokens = new Token[]{this.createVariableIdentifierToken("x"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createVariableIdentifierToken("y"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createVariableIdentifierToken("z"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createVariableIdentifierToken("w"), this.createOperatorToken("=", 6000, "right", "binary", "assignment"), this.createLiteralToken("1", "int"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "x");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "y");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "z");
        operatorNode = operatorNode.getChildNodes()[1];
        this.checkOperatorNode(operatorNode, "=", 6000, "right", "binary", "assignment");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "w");
        this.checkLiteralNode(operatorNode.getChildNodes()[1], "1");
    }

    @Test
    public void testParseExpressionPrefixIncrementDecrement() throws VnanoException {
        Token[] tokens = new Token[]{this.createOperatorToken("++", 2000, "right", "prefix", "arithmetic"), this.createOperatorToken("--", 2000, "right", "prefix", "arithmetic"), this.createVariableIdentifierToken("x"), this.createEndToken()};
        AstNode rootNode = new Parser().parse(tokens);
        Assert.assertEquals((Object)((Object)AstNode.Type.ROOT), (Object)((Object)rootNode.getType()));
        Assert.assertEquals((long)1L, (long)rootNode.getChildNodes().length);
        AstNode expressionNode = rootNode.getChildNodes()[0];
        Assert.assertEquals((Object)((Object)AstNode.Type.EXPRESSION), (Object)((Object)expressionNode.getType()));
        Assert.assertEquals((long)1L, (long)expressionNode.getChildNodes().length);
        AstNode operatorNode = expressionNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "++", 2000, "right", "prefix", "arithmetic");
        operatorNode = operatorNode.getChildNodes()[0];
        this.checkOperatorNode(operatorNode, "--", 2000, "right", "prefix", "arithmetic");
        this.checkVariableIdentifierNode(operatorNode.getChildNodes()[0], "x");
    }
}

