/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AstNode;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.AbstractVariable;
import org.vcssl.nano.interconnect.FunctionTable;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.interconnect.InternalFunction;
import org.vcssl.nano.interconnect.InternalVariable;
import org.vcssl.nano.interconnect.VariableTable;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.IdentifierSyntax;
import org.vcssl.nano.spec.ScriptWord;

public class SemanticAnalyzer {
    public AstNode analyze(AstNode astNode, Interconnect interconnect) throws VnanoException {
        AstNode astNode2 = astNode.clone();
        if (!astNode.hasChildNodes()) {
            return astNode2;
        }
        Map<String, Object> map = interconnect.getOptionMap();
        VariableTable variableTable = interconnect.getExternalVariableTable();
        FunctionTable functionTable = interconnect.getExternalFunctionTable();
        this.checkDependencyDeclarationsAndLocations(astNode2, interconnect);
        this.replaceAliasDataTypeNames(astNode2);
        this.supplementLiteralLeafAttributes(astNode2);
        this.supplementVariableIdentifierLeafAttributes(astNode2, variableTable);
        FunctionTable functionTable2 = this.extractFunctions(astNode2);
        this.supplementOperatorAttributes(astNode2, functionTable, functionTable2);
        this.supplementFunctionIdentifierLeafAttributes(astNode2);
        this.supplementExpressionAttributes(astNode2);
        this.checkFunctionAttributes(astNode2);
        this.checkAssignmentTargetWritabilities(astNode2);
        this.checkSubscriptTargetSubscriptabilities(astNode2);
        this.checkIdentifiers(astNode2);
        this.checkLiterals(astNode2);
        this.checkReturnValueTypesAndLocations(astNode2);
        if (map.containsKey("EVAL_ONLY_EXPRESSION") && map.get("EVAL_ONLY_EXPRESSION").equals(Boolean.TRUE)) {
            this.checkConsistsOfExpressions(astNode2, (String)map.get("MAIN_SCRIPT_NAME"));
        }
        if (map.containsKey("EVAL_ONLY_FLOAT") && map.get("EVAL_ONLY_FLOAT").equals(Boolean.TRUE)) {
            this.checkConsistsOfFloats(astNode2, (String)map.get("MAIN_SCRIPT_NAME"));
        }
        return astNode2;
    }

    private void replaceAliasDataTypeNames(AstNode astNode) {
        if (!astNode.hasChildNodes()) {
            return;
        }
        AstNode astNode2 = astNode;
        do {
            if (!(astNode2 = astNode2.getPreorderDftNextNode()).hasAttribute(AttributeKey.DATA_TYPE)) continue;
            String string = astNode2.getAttribute(AttributeKey.DATA_TYPE);
            if (string.equals("double")) {
                astNode2.setAttribute(AttributeKey.DATA_TYPE, "float");
                continue;
            }
            if (!string.equals("long")) continue;
            astNode2.setAttribute(AttributeKey.DATA_TYPE, "int");
        } while (!astNode2.isPreorderDftLastNode());
    }

    private void supplementVariableIdentifierLeafAttributes(AstNode astNode, VariableTable variableTable) throws VnanoException {
        if (!astNode.hasChildNodes()) {
            return;
        }
        VariableTable variableTable2 = new VariableTable();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        ArrayDeque<AstNode> arrayDeque2 = new ArrayDeque<AstNode>();
        AstNode astNode2 = astNode;
        do {
            Object object;
            if ((astNode2 = astNode2.getPreorderDftNextNode(arrayDeque2, new AstNode.Type[]{AstNode.Type.BLOCK})).getType() == AstNode.Type.FUNCTION || astNode2.getType() == AstNode.Type.FOR) {
                bl = true;
                n3 = 0;
            }
            while (arrayDeque2.size() != 0) {
                arrayDeque2.pop();
                for (int i = 0; i < n2; ++i) {
                    variableTable2.removeLastVariable();
                }
                n2 = (Integer)arrayDeque.pop();
            }
            if (astNode2.getType() == AstNode.Type.BLOCK) {
                arrayDeque.push(n2);
                n2 = 0;
                if (bl) {
                    n2 += n3;
                    n3 = 0;
                    bl = false;
                }
            }
            if (astNode2.getType() == AstNode.Type.VARIABLE) {
                String string = astNode2.getAttribute(AttributeKey.IDENTIFIER_VALUE);
                object = astNode2.getDataTypeName();
                int n4 = astNode2.getArrayRank();
                boolean bl2 = astNode2.getParentNode().getType() == AstNode.Type.FUNCTION;
                boolean bl3 = astNode2.hasModifier("const");
                if (variableTable2.containsVariableWithName(string) && !bl2) {
                    throw new VnanoException(ErrorType.DUPLICATE_VARIABLE_IDENTIFIER, new String[]{string}, astNode2.getFileName(), astNode2.getLineNumber());
                }
                InternalVariable internalVariable = new InternalVariable(string, (String)object, n4, bl3, n);
                variableTable2.addVariable(internalVariable);
                if (bl) {
                    ++n3;
                } else {
                    ++n2;
                }
                astNode2.setAttribute(AttributeKey.IDENTIFIER_SERIAL_NUMBER, Integer.toString(n));
                astNode2.setAttribute(AttributeKey.SCOPE, "local");
                ++n;
            }
            if (astNode2.getType() != AstNode.Type.LEAF || !astNode2.getAttribute(AttributeKey.LEAF_TYPE).equals("variableIdentifier")) continue;
            String string = astNode2.getAttribute(AttributeKey.IDENTIFIER_VALUE);
            object = null;
            if (variableTable2.containsVariableWithName(string)) {
                object = variableTable2.getVariableByName(string);
                astNode2.setAttribute(AttributeKey.SCOPE, "local");
                astNode2.setAttribute(AttributeKey.IDENTIFIER_SERIAL_NUMBER, Integer.toString(((AbstractVariable)object).getSerialNumber()));
            } else if (variableTable.containsVariableWithName(string)) {
                object = variableTable.getVariableByName(string);
                astNode2.setAttribute(AttributeKey.SCOPE, "global");
            } else {
                throw new VnanoException(ErrorType.VARIABLE_IS_NOT_FOUND, string, astNode2.getFileName(), astNode2.getLineNumber());
            }
            astNode2.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(((AbstractVariable)object).getArrayRank()));
            astNode2.setAttribute(AttributeKey.DATA_TYPE, ((AbstractVariable)object).getDataTypeName());
            if (((AbstractVariable)object).isConstant()) {
                astNode2.addModifier("const");
            }
            if (!((AbstractVariable)object).hasNamespaceName()) continue;
            astNode2.setAttribute(AttributeKey.NAME_SPACE, ((AbstractVariable)object).getNamespaceName());
        } while (!astNode2.isPreorderDftLastNode());
    }

    private FunctionTable extractFunctions(AstNode astNode) throws VnanoException {
        FunctionTable functionTable = new FunctionTable();
        if (!astNode.hasChildNodes()) {
            return functionTable;
        }
        AstNode astNode2 = astNode;
        do {
            if ((astNode2 = astNode2.getPreorderDftNextNode()).getType() != AstNode.Type.FUNCTION) continue;
            if (astNode2.getDepth() != 1) {
                throw new VnanoException(ErrorType.FUNCTION_IS_DECLARED_IN_INVALID_PLASE, astNode2.getFileName(), astNode2.getLineNumber());
            }
            String string = astNode2.getAttribute(AttributeKey.IDENTIFIER_VALUE);
            String string2 = astNode2.getAttribute(AttributeKey.DATA_TYPE);
            int n = astNode2.getArrayRank();
            AstNode[] astNodeArray = astNode2.getChildNodes();
            int n2 = astNodeArray.length;
            this.checkParameterDeclarationNodes(astNodeArray);
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            int[] nArray = new int[n2];
            boolean[] blArray = new boolean[n2];
            boolean[] blArray2 = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = astNodeArray[i].getAttribute(AttributeKey.IDENTIFIER_VALUE);
                stringArray2[i] = astNodeArray[i].getAttribute(AttributeKey.DATA_TYPE);
                nArray[i] = astNodeArray[i].getArrayRank();
                blArray[i] = astNodeArray[i].hasModifier("&");
                blArray2[i] = astNodeArray[i].hasModifier("const");
            }
            InternalFunction internalFunction = new InternalFunction(string, stringArray, stringArray2, nArray, blArray, blArray2, string2, n);
            String string3 = IdentifierSyntax.getSignatureOf(internalFunction);
            if (functionTable.hasFunctionWithSignature(string3)) {
                throw new VnanoException(ErrorType.DUPLICATE_FUNCTION_SIGNATURE, new String[]{string3}, astNode2.getFileName(), astNode2.getLineNumber());
            }
            functionTable.addFunction(internalFunction);
        } while (!astNode2.isPreorderDftLastNode());
        return functionTable;
    }

    private void checkParameterDeclarationNodes(AstNode[] astNodeArray) throws VnanoException {
        for (AstNode astNode : astNodeArray) {
            AstNode[] astNodeArray2;
            if (astNode.getType() != AstNode.Type.VARIABLE) {
                throw new VnanoException(ErrorType.INVALID_ARGUMENT_DECLARATION, astNode.getFileName(), astNode.getLineNumber());
            }
            if (!astNode.hasChildNodes()) continue;
            for (AstNode astNode2 : astNodeArray2 = astNode.getChildNodes()) {
                AstNode.Type type = astNode2.getType();
                if (type == AstNode.Type.LENGTHS) continue;
                throw new VnanoException(ErrorType.INVALID_ARGUMENT_DECLARATION, astNode.getFileName(), astNode.getLineNumber());
            }
        }
    }

    private void supplementLiteralLeafAttributes(AstNode astNode) {
        if (!astNode.hasChildNodes()) {
            return;
        }
        AstNode astNode2 = astNode;
        do {
            if ((astNode2 = astNode2.getPreorderDftNextNode()).getType() != AstNode.Type.LEAF || !astNode2.getAttribute(AttributeKey.LEAF_TYPE).equals("literal")) continue;
            astNode2.setAttribute(AttributeKey.ARRAY_RANK, "0");
            astNode2.addModifier("const");
        } while (!astNode2.isPreorderDftLastNode());
    }

    private void supplementOperatorAttributes(AstNode astNode, FunctionTable functionTable, FunctionTable functionTable2) throws VnanoException {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.OPERATOR) continue;
            int n = -1;
            String string = null;
            String string2 = null;
            String string3 = astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR);
            AstNode[] astNodeArray = astNode2.getAttribute(AttributeKey.OPERATOR_SYNTAX);
            block10 : switch (string3) {
                case "assignment": {
                    Object object = astNode2.getChildNodes();
                    string2 = string = object[0].getDataTypeName();
                    n = this.analyzeAssignmentOperationRank(object[0].getArrayRank(), object[1].getArrayRank(), astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                    break;
                }
                case "arithmetic": {
                    String string4;
                    String string5;
                    switch (astNodeArray) {
                        case "binary": {
                            AstNode[] astNodeArray2 = astNode2.getChildNodes();
                            string5 = astNodeArray2[0].getDataTypeName();
                            string4 = astNodeArray2[1].getDataTypeName();
                            string2 = string = this.analyzeArithmeticBinaryOperationDataType(string5, string4, astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                            n = this.analyzeArithmeticComparisonLogicalBinaryOperationRank(astNodeArray2[0].getArrayRank(), astNodeArray2[1].getArrayRank(), astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                            break block10;
                        }
                        case "prefix": {
                            AstNode[] astNodeArray3 = astNode2.getChildNodes();
                            string2 = string = astNodeArray3[0].getDataTypeName();
                            n = astNodeArray3[0].getArrayRank();
                            break block10;
                        }
                        case "postfix": {
                            throw new VnanoFatalException("Unexpected position of an arithmetic operator detected");
                        }
                    }
                    break;
                }
                case "comparison": {
                    Object object = astNode2.getChildNodes();
                    String string6 = object[0].getDataTypeName();
                    String string7 = object[1].getDataTypeName();
                    string = "bool";
                    string2 = this.analyzeComparisonBinaryOperatorDataType(string6, string7, astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                    n = this.analyzeArithmeticComparisonLogicalBinaryOperationRank(((AstNode)object[0]).getArrayRank(), ((AstNode)object[1]).getArrayRank(), astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                    break;
                }
                case "logical": {
                    String string4;
                    String string5;
                    switch (astNodeArray) {
                        case "binary": {
                            AstNode[] astNodeArray4 = astNode2.getChildNodes();
                            string5 = astNodeArray4[0].getDataTypeName();
                            string4 = astNodeArray4[1].getDataTypeName();
                            string = "bool";
                            string2 = this.analyzeLogicalBinaryOperationDataType(string5, string4, astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                            n = this.analyzeArithmeticComparisonLogicalBinaryOperationRank(astNodeArray4[0].getArrayRank(), astNodeArray4[1].getArrayRank(), astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                            break block10;
                        }
                        case "prefix": {
                            AstNode[] astNodeArray5 = astNode2.getChildNodes();
                            string = "bool";
                            string2 = "bool";
                            n = astNodeArray5[0].getArrayRank();
                            break block10;
                        }
                    }
                    break;
                }
                case "arithmeticCompoundAssignment": {
                    String string4;
                    String string5;
                    switch (astNodeArray) {
                        case "binary": {
                            AstNode[] astNodeArray6 = astNode2.getChildNodes();
                            string5 = astNodeArray6[0].getDataTypeName();
                            string4 = astNodeArray6[1].getDataTypeName();
                            string = astNodeArray6[0].getDataTypeName();
                            string2 = this.analyzeArithmeticCompoundAssignmentOperationDataType(string5, string4, astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                            n = this.analyzeCompoundAssignmentOperationRank(astNodeArray6[0].getArrayRank(), astNodeArray6[1].getArrayRank(), astNode2.getAttribute(AttributeKey.OPERATOR_SYMBOL), astNode2.getFileName(), astNode2.getLineNumber());
                            break block10;
                        }
                        case "prefix": {
                            AstNode[] astNodeArray7 = astNode2.getChildNodes();
                            string2 = string = astNodeArray7[0].getDataTypeName();
                            n = astNodeArray7[0].getArrayRank();
                            break block10;
                        }
                        case "postfix": {
                            AstNode[] astNodeArray8 = astNode2.getChildNodes();
                            string2 = string = astNodeArray8[0].getDataTypeName();
                            n = astNodeArray8[0].getArrayRank();
                            break block10;
                        }
                    }
                    break;
                }
                case "call": {
                    Object object = null;
                    if (functionTable2.hasCalleeFunctionOf(astNode2)) {
                        astNode2.setAttribute(AttributeKey.SCOPE, "local");
                        object = functionTable2.getCalleeFunctionOf(astNode2);
                    } else if (functionTable.hasCalleeFunctionOf(astNode2)) {
                        astNode2.setAttribute(AttributeKey.SCOPE, "global");
                        object = functionTable.getCalleeFunctionOf(astNode2);
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(IdentifierSyntax.getSignatureOfCalleeFunctionOf(astNode2));
                        for (String string8 : functionTable2.presumeCalleeFunctionSignaturesOf(astNode2)) {
                            arrayList.add(string8);
                        }
                        for (String string9 : functionTable.presumeCalleeFunctionSignaturesOf(astNode2)) {
                            arrayList.add(string9);
                        }
                        throw new VnanoException(ErrorType.FUNCTION_IS_NOT_FOUND, arrayList.toArray(new String[0]), astNode2.getFileName(), astNode2.getLineNumber());
                    }
                    this.checkFunctionCallablility((AbstractFunction)object, astNode2);
                    astNode2.setAttribute(AttributeKey.CALLEE_SIGNATURE, IdentifierSyntax.getSignatureOf((AbstractFunction)object));
                    if (((AbstractFunction)object).hasNamespaceName()) {
                        astNode2.setAttribute(AttributeKey.NAME_SPACE, ((AbstractFunction)object).getNamespaceName());
                    }
                    String[] stringArray = this.getArgumentDataTypeNames(astNode2);
                    int[] nArray = this.getArgumentArrayRanks(astNode2);
                    string2 = string = ((AbstractFunction)object).getReturnDataTypeName(stringArray, nArray);
                    n = ((AbstractFunction)object).getReturnArrayRank(stringArray, nArray);
                    ((AbstractFunction)object).checkInvokability(stringArray, nArray);
                    break;
                }
                case "subscript": {
                    Object object = astNode2.getChildNodes();
                    string = object[0].getDataTypeName();
                    n = 0;
                    break;
                }
                case "cast": {
                    string2 = string = astNode2.getDataTypeName();
                    n = astNode2.getArrayRank();
                    if (n == astNode2.getChildNodes()[0].getArrayRank()) break;
                    if (n == 0) {
                        throw new VnanoException(ErrorType.CASTING_SCALAR_TO_ARRAY, astNode2.getFileName(), astNode2.getLineNumber());
                    }
                    if (astNode2.getChildNodes()[0].getArrayRank() == 0) {
                        throw new VnanoException(ErrorType.CASTING_ARRAY_TO_SCALAR, astNode2.getFileName(), astNode2.getLineNumber());
                    }
                    throw new VnanoException(ErrorType.CASTING_ARRAY_TO_DIFFERENT_RANK_ARRAY, astNode2.getFileName(), astNode2.getLineNumber());
                }
            }
            if (string != null) {
                astNode2.setAttribute(AttributeKey.DATA_TYPE, string);
            }
            if (string2 != null) {
                astNode2.setAttribute(AttributeKey.OPERATOR_EXECUTION_DATA_TYPE, string2);
            }
            if (n == -1) continue;
            astNode2.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(n));
        }
    }

    private String[] getArgumentDataTypeNames(AstNode astNode) {
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length - 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = astNodeArray[i + 1].getDataTypeName();
        }
        return stringArray;
    }

    private int[] getArgumentArrayRanks(AstNode astNode) {
        AstNode[] astNodeArray = astNode.getChildNodes();
        int n = astNodeArray.length - 1;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = astNodeArray[i + 1].getArrayRank();
        }
        return nArray;
    }

    private void checkFunctionCallablility(AbstractFunction abstractFunction, AstNode astNode) throws VnanoException {
        AstNode[] astNodeArray = astNode.getChildNodes();
        String[] stringArray = abstractFunction.getParameterDataTypeNames();
        String[] stringArray2 = abstractFunction.getParameterNames();
        boolean[] blArray = abstractFunction.getParameterConstantnesses();
        boolean[] blArray2 = abstractFunction.getParameterReferencenesses();
        int n = stringArray.length;
        for (int i = 0; !(i >= n || abstractFunction.isParameterCountArbitrary() && i == n - 1 && astNodeArray.length <= i + 1); ++i) {
            boolean bl;
            AstNode astNode2 = astNodeArray[i + 1];
            if (astNode2.getAttribute(AttributeKey.DATA_TYPE).equals("void")) {
                String string = null;
                if (astNode2.getType() == AstNode.Type.OPERATOR && astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("call")) {
                    AstNode astNode3 = astNode2.getChildNodes()[0];
                    string = astNode3.getAttribute(AttributeKey.IDENTIFIER_VALUE);
                }
                throw new VnanoException(ErrorType.VOID_RETURN_VALUE_PASSED_AS_ARGUMENT, string, astNode.getFileName(), astNode.getLineNumber());
            }
            if (!blArray2[i] || blArray[i]) continue;
            boolean bl2 = astNode2.getType() == AstNode.Type.LEAF && astNode2.getAttribute(AttributeKey.LEAF_TYPE).equals("variableIdentifier");
            boolean bl3 = bl = astNode2.getType() == AstNode.Type.OPERATOR && astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("subscript");
            if (bl2 || bl) continue;
            String[] stringArray3 = new String[]{Integer.toString(i + 1), stringArray2[i], abstractFunction.getFunctionName()};
            throw new VnanoException(ErrorType.NON_VARIABLE_IS_PASSED_BY_REFERENCE, stringArray3, astNode.getFileName(), astNode.getLineNumber());
        }
    }

    private void supplementFunctionIdentifierLeafAttributes(AstNode astNode) {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.LEAF || !astNode2.getAttribute(AttributeKey.LEAF_TYPE).equals("functionIdentifier")) continue;
            AstNode astNode3 = astNode2.getParentNode();
            astNode2.setAttribute(AttributeKey.DATA_TYPE, astNode3.getAttribute(AttributeKey.DATA_TYPE));
            astNode2.setAttribute(AttributeKey.ARRAY_RANK, astNode3.getAttribute(AttributeKey.ARRAY_RANK));
        }
    }

    private void supplementExpressionAttributes(AstNode astNode) {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.EXPRESSION) continue;
            AstNode[] astNodeArray = astNode2.getChildNodes();
            astNode2.setAttribute(AttributeKey.DATA_TYPE, astNodeArray[0].getDataTypeName());
            astNode2.setAttribute(AttributeKey.ARRAY_RANK, Integer.toString(astNodeArray[0].getArrayRank()));
        }
    }

    private String analyzeArithmeticCompoundAssignmentOperationDataType(String string, String string2, String string3, String string4, int n) throws VnanoException {
        String string5 = null;
        if (string3.equals("+=")) {
            string5 = "+";
        } else if (string3.equals("-=")) {
            string5 = "-";
        } else if (string3.equals("*=")) {
            string5 = "*";
        } else if (string3.equals("/=")) {
            string5 = "/";
        } else if (string3.equals("%=")) {
            string5 = "%";
        } else {
            throw new VnanoFatalException("Invalid arithmetic compound operator: " + string3);
        }
        return this.analyzeArithmeticBinaryOperationDataType(string, string2, string5, string4, n);
    }

    private String analyzeArithmeticBinaryOperationDataType(String string, String string2, String string3, String string4, int n) throws VnanoException {
        DataType dataType = DataTypeName.getDataTypeOf(string);
        DataType dataType2 = DataTypeName.getDataTypeOf(string2);
        if ((dataType == DataType.STRING || dataType2 == DataType.STRING) && string3.equals("+")) {
            return "string";
        }
        if (dataType == DataType.INT64 && dataType2 == DataType.INT64) {
            return "int";
        }
        if (dataType == DataType.FLOAT64 && dataType2 == DataType.FLOAT64) {
            return "float";
        }
        if (dataType == DataType.INT64 && dataType2 == DataType.FLOAT64) {
            return "float";
        }
        if (dataType == DataType.FLOAT64 && dataType2 == DataType.INT64) {
            return "float";
        }
        throw new VnanoException(ErrorType.INVALID_DATA_TYPES_FOR_BINARY_OPERATOR, new String[]{string3, string, string2}, string4, n);
    }

    private String analyzeComparisonBinaryOperatorDataType(String string, String string2, String string3, String string4, int n) throws VnanoException {
        DataType dataType = DataTypeName.getDataTypeOf(string);
        DataType dataType2 = DataTypeName.getDataTypeOf(string2);
        if (dataType == DataType.STRING || dataType2 == DataType.STRING) {
            return "string";
        }
        if (dataType == DataType.BOOL && dataType2 == DataType.BOOL) {
            return "bool";
        }
        if (dataType == DataType.INT64 && dataType2 == DataType.INT64) {
            return "int";
        }
        if (dataType == DataType.FLOAT64 && dataType2 == DataType.FLOAT64) {
            return "float";
        }
        if (dataType == DataType.INT64 && dataType2 == DataType.FLOAT64) {
            return "float";
        }
        if (dataType == DataType.FLOAT64 && dataType2 == DataType.INT64) {
            return "float";
        }
        throw new VnanoException(ErrorType.INVALID_DATA_TYPES_FOR_BINARY_OPERATOR, new String[]{string3, string, string2}, string4, n);
    }

    private String analyzeLogicalBinaryOperationDataType(String string, String string2, String string3, String string4, int n) throws VnanoException {
        DataType dataType = DataTypeName.getDataTypeOf(string);
        DataType dataType2 = DataTypeName.getDataTypeOf(string2);
        if (dataType == DataType.BOOL && dataType2 == DataType.BOOL) {
            return "bool";
        }
        throw new VnanoException(ErrorType.INVALID_DATA_TYPES_FOR_BINARY_OPERATOR, new String[]{string3, string, string2}, string4, n);
    }

    int analyzeAssignmentOperationRank(int n, int n2, String string, String string2, int n3) throws VnanoException {
        if (n != 0 && n2 != 0 && n != n2) {
            throw new VnanoException(ErrorType.INVALID_RANKS_FOR_VECTOR_OPERATION, new String[]{string}, string2, n3);
        }
        return n;
    }

    int analyzeArithmeticComparisonLogicalBinaryOperationRank(int n, int n2, String string, String string2, int n3) throws VnanoException {
        if (n == 0 && n2 == 0) {
            return 0;
        }
        if (n == 0 && n2 != 0) {
            return n2;
        }
        if (n != 0 && n2 == 0) {
            return n;
        }
        if (n == n2) {
            return n;
        }
        throw new VnanoException(ErrorType.INVALID_RANKS_FOR_VECTOR_OPERATION, new String[]{string}, string2, n3);
    }

    int analyzeCompoundAssignmentOperationRank(int n, int n2, String string, String string2, int n3) throws VnanoException {
        if (n == 0 && n2 == 0) {
            return 0;
        }
        if (n == 0 && n2 != 0) {
            throw new VnanoException(ErrorType.INVALID_COMPOUND_ASSIGNMENT_BETWEEN_SCALAR_AND_ARRAY, new String[]{string}, string2, n3);
        }
        if (n != 0 && n2 == 0) {
            return n;
        }
        if (n == n2) {
            return n;
        }
        throw new VnanoException(ErrorType.INVALID_RANKS_FOR_VECTOR_OPERATION, new String[]{string}, string2, n3);
    }

    private void checkFunctionAttributes(AstNode astNode) throws VnanoException {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            AstNode[] astNodeArray;
            if (astNode2.getType() != AstNode.Type.FUNCTION) continue;
            for (AstNode astNode3 : astNodeArray = astNode2.getChildNodes()) {
                if (astNode3.getType() != AstNode.Type.VARIABLE || astNode3.hasAttribute(AttributeKey.IDENTIFIER_VALUE)) continue;
                throw new VnanoException(ErrorType.NO_IDENTIFIER_IN_VARIABLE_DECLARATION, astNode3.getFileName(), astNode3.getLineNumber());
            }
        }
    }

    private void checkAssignmentTargetWritabilities(AstNode astNode) throws VnanoException {
        block8: for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            String string;
            if (astNode2.getType() != AstNode.Type.OPERATOR) continue;
            switch (string = astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR)) {
                case "assignment": {
                    boolean bl = astNode2.getParentNode() != null && astNode2.getParentNode().getParentNode() != null && astNode2.getParentNode().getParentNode().getType() == AstNode.Type.VARIABLE;
                    this.checkModifiability(astNode2.getChildNodes()[0], bl);
                    continue block8;
                }
                case "arithmeticCompoundAssignment": {
                    this.checkModifiability(astNode2.getChildNodes()[0], false);
                    continue block8;
                }
            }
        }
    }

    private void checkModifiability(AstNode astNode, boolean bl) throws VnanoException {
        String string = astNode.getFileName();
        int n = astNode.getLineNumber();
        if (astNode.getType() == AstNode.Type.OPERATOR && astNode.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("subscript")) {
            astNode = astNode.getChildNodes()[0];
        }
        if (astNode.getType() != AstNode.Type.LEAF) {
            throw new VnanoException(ErrorType.WRITING_TO_NON_LVALUE, string, n);
        }
        String string2 = astNode.getAttribute(AttributeKey.LEAF_TYPE);
        if (string2.equals("variableIdentifier")) {
            if (astNode.hasModifier("const") && !bl) {
                throw new VnanoException(ErrorType.WRITING_TO_CONST_VARIABLE, new String[]{astNode.getAttribute(AttributeKey.IDENTIFIER_VALUE)}, string, n);
            }
        } else {
            if (string2.equals("literal")) {
                String[] stringArray = new String[]{astNode.getAttribute(AttributeKey.LITERAL_VALUE)};
                throw new VnanoException(ErrorType.WRITING_TO_LITERAL, stringArray, string, n);
            }
            throw new VnanoException(ErrorType.WRITING_TO_NON_LVALUE, string, n);
        }
    }

    private void checkSubscriptTargetSubscriptabilities(AstNode astNode) throws VnanoException {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.OPERATOR || !astNode2.getAttribute(AttributeKey.OPERATOR_EXECUTOR).equals("subscript")) continue;
            String string = astNode2.getFileName();
            int n = astNode2.getLineNumber();
            AstNode astNode3 = astNode2.getChildNodes()[0];
            if (astNode3.getType() != AstNode.Type.LEAF) {
                throw new VnanoException(ErrorType.SUBSCRIPTING_TO_UNSUBSCRIPTABLE_SOMETHING, string, n);
            }
            if (!astNode3.getAttribute(AttributeKey.LEAF_TYPE).equals("variableIdentifier")) {
                String[] stringArray = null;
                if (astNode3.getAttribute(AttributeKey.LEAF_TYPE).equals("literal")) {
                    stringArray = new String[]{astNode3.getAttribute(AttributeKey.LITERAL_VALUE)};
                }
                throw new VnanoException(ErrorType.SUBSCRIPTING_TO_UNSUBSCRIPTABLE_SOMETHING, stringArray, string, n);
            }
            if (astNode3.getArrayRank() == 0) {
                String[] stringArray = new String[]{astNode3.getAttribute(AttributeKey.IDENTIFIER_VALUE)};
                throw new VnanoException(ErrorType.SUBSCRIPTING_TO_UNSUBSCRIPTABLE_SOMETHING, stringArray, string, n);
            }
            int n2 = astNode2.getChildNodes().length - 1;
            if (astNode3.getArrayRank() == n2) continue;
            String[] stringArray = new String[]{astNode3.getAttribute(AttributeKey.IDENTIFIER_VALUE), Integer.toString(astNode3.getArrayRank()), Integer.toString(n2)};
            throw new VnanoException(ErrorType.INVALID_SUBSCRIPT_RANK, stringArray, string, n);
        }
    }

    private void checkIdentifiers(AstNode astNode) throws VnanoException {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.VARIABLE && astNode2.getType() != AstNode.Type.FUNCTION) continue;
            String string = astNode2.getFileName();
            int n = astNode2.getLineNumber();
            String string2 = astNode2.getAttribute(AttributeKey.IDENTIFIER_VALUE);
            if (!IdentifierSyntax.isValidSyntaxIdentifier(string2)) {
                throw new VnanoException(ErrorType.INVALID_IDENTIFIER_SYNTAX, string2, string, n);
            }
            if (!ScriptWord.RESERVED_WORD_SET.contains(string2)) continue;
            throw new VnanoException(ErrorType.IDENTIFIER_IS_RESERVED_WORD, string2, string, n);
        }
    }

    private void checkLiterals(AstNode astNode) throws VnanoException {
        for (AstNode astNode2 = astNode.getPostorderDftFirstNode(); astNode2 != astNode; astNode2 = astNode2.getPostorderDftNextNode()) {
            if (astNode2.getType() != AstNode.Type.LEAF || !astNode2.getAttribute(AttributeKey.LEAF_TYPE).equals("literal")) continue;
            String string = astNode2.getFileName();
            int n = astNode2.getLineNumber();
            String string2 = astNode2.getAttribute(AttributeKey.DATA_TYPE);
            String string3 = astNode2.getAttribute(AttributeKey.LITERAL_VALUE);
            if (!string2.equals("int") && !string2.equals("long") || !string3.startsWith("0") || string3.equals("0") || string3.startsWith("0x") || string3.startsWith("0o") || string3.startsWith("0b")) continue;
            throw new VnanoException(ErrorType.INT_LITERAL_STARTS_WITH_ZERO, string, n);
        }
    }

    private void checkReturnValueTypesAndLocations(AstNode astNode) throws VnanoException {
        String string = "";
        int n = -1;
        AstNode astNode2 = null;
        boolean bl = false;
        ArrayDeque<AstNode> arrayDeque = new ArrayDeque<AstNode>();
        AstNode astNode3 = astNode;
        do {
            Object object;
            astNode3 = astNode3.getPreorderDftNextNode(arrayDeque, new AstNode.Type[]{AstNode.Type.BLOCK});
            if (arrayDeque.size() != 0 && arrayDeque.contains(astNode2)) {
                arrayDeque.clear();
                string = "";
                n = -1;
                astNode2 = null;
                bl = false;
            }
            if (astNode3.getType() == AstNode.Type.FUNCTION) {
                string = astNode3.getDataTypeName();
                n = astNode3.getArrayRank();
                object = astNode3.getParentNode().getChildNodes();
                astNode2 = object[astNode3.getSiblingIndex() + 1];
                bl = true;
            }
            if (astNode3.getType() != AstNode.Type.RETURN) continue;
            if (!bl) {
                throw new VnanoException(ErrorType.RETURN_STATEMENT_IS_OUTSIDE_FUNCTIONS);
            }
            if (astNode3.hasChildNodes()) {
                object = astNode3.getChildNodes()[0];
                if (((AstNode)object).getDataTypeName().equals(string) && ((AstNode)object).getArrayRank() == n) continue;
                String string2 = ((AstNode)object).getDataTypeName();
                for (int i = 0; i < ((AstNode)object).getArrayRank(); ++i) {
                    string2 = string2 + "[]";
                }
                String string3 = string;
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + "[]";
                }
                String[] stringArray = new String[]{string2, string3};
                throw new VnanoException(ErrorType.INVALID_RETURNED_VALUE_DATA_TYPE, stringArray, astNode3.getFileName(), astNode3.getLineNumber());
            }
            if (string.equals("void")) continue;
            throw new VnanoException(ErrorType.RETURNED_VALUE_IS_MISSING, astNode3.getFileName(), astNode3.getLineNumber());
        } while (!astNode3.isPreorderDftLastNode());
    }

    private void checkDependencyDeclarationsAndLocations(AstNode astNode, Interconnect interconnect) throws VnanoException {
        boolean bl = true;
        AstNode astNode2 = astNode;
        do {
            if ((astNode2 = astNode2.getPreorderDftNextNode()).getType() == AstNode.Type.IMPORT || astNode2.getType() == AstNode.Type.INCLUDE) {
                if (bl) {
                    if (!astNode2.hasChildNodes()) {
                        throw new VnanoFatalException("An expected child node of IMPORT/INCLUDE node has not been found.");
                    }
                    AstNode astNode3 = astNode2.getChildNodes()[0];
                    if (astNode3.getType() != AstNode.Type.LEAF || !astNode3.getAttribute(AttributeKey.LEAF_TYPE).equals("dependencyIdentifier")) {
                        throw new VnanoFatalException("Incorrect node type has been detected for the child node of IMPORT/INCLUDE node.");
                    }
                    String string = astNode3.getAttribute(AttributeKey.IDENTIFIER_VALUE);
                    boolean bl2 = interconnect.hasDependentLibraryOrPlugin(string);
                    if (bl2) continue;
                    throw new VnanoException(ErrorType.DECLARED_DEPENDENCY_IS_NOT_AVAILABLE, new String[]{string}, astNode2.getFileName(), astNode2.getLineNumber());
                }
                throw new VnanoException(ErrorType.INVALID_DEPENDENCY_DECLARATION_LOCATION, astNode2.getFileName(), astNode2.getLineNumber());
            }
            bl = false;
        } while (!astNode2.isPreorderDftLastNode());
    }

    private void checkConsistsOfExpressions(AstNode astNode, String string) throws VnanoException {
        HashSet<AstNode.Type> hashSet = new HashSet<AstNode.Type>();
        hashSet.add(AstNode.Type.EXPRESSION);
        hashSet.add(AstNode.Type.OPERATOR);
        hashSet.add(AstNode.Type.LEAF);
        hashSet.add(AstNode.Type.PARENTHESIS);
        hashSet.add(AstNode.Type.ROOT);
        AstNode astNode2 = astNode;
        do {
            astNode2 = astNode2.getPreorderDftNextNode();
            String string2 = astNode2.getFileName();
            int n = astNode2.getLineNumber();
            if (!string2.equals(string) || hashSet.contains((Object)astNode2.getType())) continue;
            throw new VnanoException(ErrorType.NON_EXPRESSION_STATEMENTS_ARE_RESTRICTED, string2, n);
        } while (!astNode2.isPreorderDftLastNode());
    }

    private void checkConsistsOfFloats(AstNode astNode, String string) throws VnanoException {
        HashSet<AstNode.Type> hashSet = new HashSet<AstNode.Type>();
        hashSet.add(AstNode.Type.LEAF);
        hashSet.add(AstNode.Type.OPERATOR);
        AstNode astNode2 = astNode;
        do {
            astNode2 = astNode2.getPreorderDftNextNode();
            String string2 = astNode2.getFileName();
            int n = astNode2.getLineNumber();
            if (!string2.equals(string) || !hashSet.contains((Object)astNode2.getType()) || astNode2.getAttribute(AttributeKey.DATA_TYPE).equals("float")) continue;
            throw new VnanoException(ErrorType.NON_FLOAT_DATA_TYPES_ARE_RESTRICTED, string2, n);
        } while (!astNode2.isPreorderDftLastNode());
    }
}

