/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.util.HashMap;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.memory.DataContainer;

public class DataConverter {
    private static final int ARRAY_RANK_OF_SCALAR = 0;
    private static final String EXTERNAL_TYPE_NAME_INT32 = "int";
    private static final String EXTERNAL_TYPE_NAME_INT64 = "long";
    private static final String EXTERNAL_TYPE_NAME_FLOAT32 = "float";
    private static final String EXTERNAL_TYPE_NAME_FLOAT64 = "double";
    private static final String EXTERNAL_TYPE_NAME_BOOL = "boolean";
    private static final String EXTERNAL_TYPE_NAME_STRING = "java.lang.String";
    private static final String EXTERNAL_TYPE_NAME_ANY = "java.lang.Object";
    private static final String EXTERNAL_TYPE_NAME_VOID = "void";
    private static final String EXTERNAL_TYPE_NAME_INT32_WRAPPER = "java.lang.Integer";
    private static final String EXTERNAL_TYPE_NAME_INT64_WRAPPER = "java.lang.Long";
    private static final String EXTERNAL_TYPE_NAME_FLOAT32_WRAPPER = "java.lang.Float";
    private static final String EXTERNAL_TYPE_NAME_FLOAT64_WRAPPER = "java.lang.Double";
    private static final String EXTERNAL_TYPE_NAME_BOOL_WRAPPER = "java.lang.Boolean";
    private static final String EXTERNAL_TYPE_NAME_VOID_WRAPPER = "java.lang.Void";
    private static final String EXTERNAL_ARRAY_BRACKET = "[]";
    private static final String EXTERNAL_ARRAY_BRACKET_REGEX = "\\[\\]";
    private static final HashMap<String, DataType> EXTERNAL_NAME_DATA_TYPE_MAP = new HashMap();
    private static final HashMap<String, ExternalType> EXTERNAL_NAME_EXTERNAL_TYPE_MAP;
    private static final HashMap<ExternalType, DataType> EXTERNAL_TYPE_DATA_TYPE_MAP;
    private static final HashMap<DataType, ExternalType> DATA_TYPE_EXTERNAL_TYPE_MAP;
    private ExternalType externalType = null;
    private DataType dataType = null;
    private int arrayRank = -1;

    public DataConverter(Class<?> clazz) throws VnanoException {
        this.arrayRank = DataConverter.getArrayRankOf(clazz);
        String string = DataConverter.getExternalTypeNameOf(clazz);
        this.externalType = EXTERNAL_NAME_EXTERNAL_TYPE_MAP.get(string);
        this.dataType = EXTERNAL_NAME_DATA_TYPE_MAP.get(string);
        if (this.dataType == null) {
            throw new VnanoException(ErrorType.UNCONVERTIBLE_DATA_TYPE, new String[]{clazz.getCanonicalName()});
        }
    }

    public DataConverter(DataType dataType, int n) throws VnanoException {
        this.arrayRank = n;
        this.dataType = dataType;
        this.externalType = DATA_TYPE_EXTERNAL_TYPE_MAP.get((Object)dataType);
    }

    public static boolean isConvertible(Class<?> clazz) {
        String string = DataConverter.getExternalTypeNameOf(clazz);
        DataType dataType = EXTERNAL_NAME_DATA_TYPE_MAP.get(string);
        return dataType != null;
    }

    private static final String getExternalTypeNameOf(Class<?> clazz) {
        String string = clazz.getCanonicalName();
        String string2 = null;
        boolean bl = 0 <= string.indexOf(EXTERNAL_ARRAY_BRACKET);
        string2 = bl ? string.substring(0, string.indexOf(EXTERNAL_ARRAY_BRACKET)) : string;
        return string2;
    }

    public static DataType getDataTypeOf(Class<?> clazz) {
        String string = DataConverter.getExternalTypeNameOf(clazz);
        return EXTERNAL_NAME_DATA_TYPE_MAP.get(string);
    }

    public static Class<?> getExternalClassOf(DataType dataType, int n) {
        ExternalType externalType = DATA_TYPE_EXTERNAL_TYPE_MAP.get((Object)dataType);
        if (n == 0) {
            switch (externalType.ordinal()) {
                case 1: {
                    return Long.TYPE;
                }
                case 3: {
                    return Double.TYPE;
                }
                case 5: {
                    return Boolean.TYPE;
                }
                case 4: {
                    return String.class;
                }
                case 6: {
                    return Object.class;
                }
                case 7: {
                    return Void.class;
                }
            }
            throw new VnanoFatalException("Unknown data type: " + (Object)((Object)dataType));
        }
        if (n == 1) {
            switch (externalType.ordinal()) {
                case 1: {
                    return long[].class;
                }
                case 3: {
                    return double[].class;
                }
                case 5: {
                    return boolean[].class;
                }
                case 4: {
                    return String[].class;
                }
                case 6: {
                    return Object[].class;
                }
                case 7: {
                    return Void[].class;
                }
            }
            throw new VnanoFatalException("Unknown data type: " + (Object)((Object)dataType));
        }
        if (n == 2) {
            switch (externalType.ordinal()) {
                case 1: {
                    return long[][].class;
                }
                case 3: {
                    return double[][].class;
                }
                case 5: {
                    return boolean[][].class;
                }
                case 4: {
                    return String[][].class;
                }
                case 6: {
                    return Object[][].class;
                }
                case 7: {
                    return Void[][].class;
                }
            }
            throw new VnanoFatalException("Unknown data type: " + (Object)((Object)dataType));
        }
        if (n == 3) {
            switch (externalType.ordinal()) {
                case 1: {
                    return long[][][].class;
                }
                case 3: {
                    return double[][][].class;
                }
                case 5: {
                    return boolean[][][].class;
                }
                case 4: {
                    return String[][][].class;
                }
                case 6: {
                    return Object[][][].class;
                }
                case 7: {
                    return Void[][][].class;
                }
            }
            throw new VnanoFatalException("Unknown data type: " + (Object)((Object)dataType));
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + EXTERNAL_ARRAY_BRACKET;
        }
        throw new VnanoFatalException("Unconvertible array: " + (Object)((Object)dataType) + string);
    }

    public static Class<?>[] getExternalClassesOf(DataType[] dataTypeArray, int[] nArray) {
        int n = dataTypeArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = DataConverter.getExternalClassOf(dataTypeArray[i], nArray[i]);
        }
        return classArray;
    }

    public static int getArrayRankOf(Class<?> clazz) {
        String string = clazz.getCanonicalName();
        int n = -1;
        boolean bl = 0 <= string.indexOf(EXTERNAL_ARRAY_BRACKET);
        n = bl ? string.split(EXTERNAL_ARRAY_BRACKET_REGEX, -1).length - 1 : 0;
        return n;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getArrayRank() {
        return this.arrayRank;
    }

    public static DataContainer<?> copyDataContainer(DataContainer<?> dataContainer) {
        DataContainer<long[]> dataContainer2 = new DataContainer<long[]>();
        int n = dataContainer.getArrayRank();
        int[] nArray = new int[n];
        System.arraycopy(dataContainer.getArrayLengths(), 0, nArray, 0, n);
        Object obj = dataContainer.getArrayData();
        Object[] objectArray = null;
        if (obj instanceof long[]) {
            long[] lArray = (long[])obj;
            long[] lArray2 = new long[lArray.length];
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            objectArray = lArray2;
        } else if (obj instanceof double[]) {
            double[] dArray = (double[])obj;
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            objectArray = dArray2;
        } else if (obj instanceof boolean[]) {
            boolean[] blArray = (boolean[])obj;
            boolean[] blArray2 = new boolean[blArray.length];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            objectArray = blArray2;
        } else if (obj instanceof String[]) {
            String[] stringArray = (String[])obj;
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            objectArray = stringArray2;
        } else {
            throw new VnanoFatalException("Unexpected class for data: " + obj.getClass().getCanonicalName());
        }
        if (n == 0) {
            dataContainer2.setArrayData((long[])objectArray, dataContainer.getArrayOffset(), DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        } else {
            dataContainer2.setArrayData((long[])objectArray, 0, nArray);
        }
        return dataContainer2;
    }

    public DataContainer<?> convertToDataContainer(Object object) throws VnanoException {
        DataContainer dataContainer = new DataContainer();
        this.convertToDataContainer(object, dataContainer);
        return dataContainer;
    }

    public void convertToDataContainer(Object object, DataContainer<?> dataContainer) throws VnanoException {
        switch (this.arrayRank) {
            case 0: {
                this.convertToDataContainer0D(object, dataContainer);
                return;
            }
            case 1: {
                this.convertToDataContainer1D(object, dataContainer);
                return;
            }
            case 2: {
                this.convertToDataContainer2D(object, dataContainer);
                return;
            }
            case 3: {
                this.convertToDataContainer3D(object, dataContainer);
                return;
            }
        }
        VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_ARRAY, new String[]{DataConverter.getExternalTypeNameOf(object.getClass())});
        throw vnanoException;
    }

    private void convertToDataContainer0D(Object object, DataContainer<?> dataContainer) throws VnanoException {
        int[] nArray = DataContainer.ARRAY_LENGTHS_OF_SCALAR;
        switch (this.externalType.ordinal()) {
            case 0: {
                long[] lArray = new long[]{((Integer)object).longValue()};
                dataContainer.setArrayData(lArray, 0, nArray);
                return;
            }
            case 1: {
                long[] lArray = new long[]{(Long)object};
                dataContainer.setArrayData(lArray, 0, nArray);
                return;
            }
            case 2: {
                double[] dArray = new double[]{((Float)object).doubleValue()};
                dataContainer.setArrayData(dArray, 0, nArray);
                return;
            }
            case 3: {
                double[] dArray = new double[]{(Double)object};
                dataContainer.setArrayData(dArray, 0, nArray);
                return;
            }
            case 5: {
                boolean[] blArray = new boolean[]{(Boolean)object};
                dataContainer.setArrayData(blArray, 0, nArray);
                return;
            }
            case 4: {
                String[] stringArray = new String[]{(String)object};
                dataContainer.setArrayData(stringArray, 0, nArray);
                return;
            }
            case 6: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
            case 7: {
                VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_DATA_TYPE, new String[]{DataTypeName.getDataTypeNameOf(DataType.VOID)});
                throw vnanoException;
            }
        }
    }

    private void convertToDataContainer1D(Object object, DataContainer<?> dataContainer) throws VnanoException {
        int[] nArray = new int[1];
        int n = -1;
        switch (this.externalType.ordinal()) {
            case 0: {
                nArray[0] = n = ((int[])object).length;
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = ((int[])object)[i];
                }
                dataContainer.setArrayData(lArray, 0, nArray);
                break;
            }
            case 1: {
                nArray[0] = n = ((long[])object).length;
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = ((long[])object)[i];
                }
                dataContainer.setArrayData(lArray, 0, nArray);
                break;
            }
            case 2: {
                nArray[0] = n = ((float[])object).length;
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = ((float[])object)[i];
                }
                dataContainer.setArrayData(dArray, 0, nArray);
                break;
            }
            case 3: {
                nArray[0] = n = ((double[])object).length;
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = ((double[])object)[i];
                }
                dataContainer.setArrayData(dArray, 0, nArray);
                break;
            }
            case 5: {
                nArray[0] = n = ((boolean[])object).length;
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = ((boolean[])object)[i];
                }
                dataContainer.setArrayData(blArray, 0, nArray);
                break;
            }
            case 4: {
                nArray[0] = n = ((String[])object).length;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = ((String[])object)[i];
                }
                dataContainer.setArrayData(stringArray, 0, nArray);
                break;
            }
            case 6: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
            case 7: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
        }
    }

    private void convertToDataContainer2D(Object object, DataContainer<?> dataContainer) throws VnanoException {
        int[] nArray = new int[2];
        int n = -1;
        switch (this.externalType.ordinal()) {
            case 0: {
                nArray[0] = ((int[][])object).length;
                nArray[1] = ((int[][])object)[0].length;
                n = nArray[0] * nArray[1];
                long[] lArray = new long[n];
                int n2 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((int[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        lArray[n2] = ((int[][])object)[i][j];
                        ++n2;
                    }
                }
                dataContainer.setArrayData(lArray, 0, nArray);
                break;
            }
            case 1: {
                nArray[0] = ((long[][])object).length;
                nArray[1] = ((long[][])object)[0].length;
                n = nArray[0] * nArray[1];
                long[] lArray = new long[n];
                int n3 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((long[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        lArray[n3] = ((long[][])object)[i][j];
                        ++n3;
                    }
                }
                dataContainer.setArrayData(lArray, 0, nArray);
                break;
            }
            case 2: {
                nArray[0] = ((float[][])object).length;
                nArray[1] = ((float[][])object)[0].length;
                n = nArray[0] * nArray[1];
                double[] dArray = new double[n];
                int n4 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((float[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        dArray[n4] = ((float[][])object)[i][j];
                        ++n4;
                    }
                }
                dataContainer.setArrayData(dArray, 0, nArray);
                break;
            }
            case 3: {
                nArray[0] = ((double[][])object).length;
                nArray[1] = ((double[][])object)[0].length;
                n = nArray[0] * nArray[1];
                double[] dArray = new double[n];
                int n5 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((double[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        dArray[n5] = ((double[][])object)[i][j];
                        ++n5;
                    }
                }
                dataContainer.setArrayData(dArray, 0, nArray);
                break;
            }
            case 5: {
                nArray[0] = ((boolean[][])object).length;
                nArray[1] = ((boolean[][])object)[0].length;
                n = nArray[0] * nArray[1];
                boolean[] blArray = new boolean[n];
                int n6 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((boolean[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        blArray[n6] = ((boolean[][])object)[i][j];
                        ++n6;
                    }
                }
                dataContainer.setArrayData(blArray, 0, nArray);
                break;
            }
            case 4: {
                nArray[0] = ((String[][])object).length;
                nArray[1] = ((String[][])object)[0].length;
                n = nArray[0] * nArray[1];
                String[] stringArray = new String[n];
                int n7 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((String[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        stringArray[n7] = ((String[][])object)[i][j];
                        ++n7;
                    }
                }
                dataContainer.setArrayData(stringArray, 0, nArray);
                break;
            }
            case 6: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
            case 7: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
        }
    }

    private void convertToDataContainer3D(Object object, DataContainer<?> dataContainer) throws VnanoException {
        int[] nArray = new int[3];
        int n = -1;
        switch (this.externalType.ordinal()) {
            case 0: {
                nArray[0] = ((int[][][])object).length;
                nArray[1] = ((int[][][])object)[0].length;
                nArray[2] = ((int[][][])object)[0][0].length;
                n = nArray[0] * nArray[1] * nArray[2];
                long[] lArray = new long[n];
                int n2 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((int[][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        if (((int[][][])object)[i][j].length != nArray[2]) {
                            throw new VnanoException(ErrorType.JAGGED_ARRAY);
                        }
                        for (int k = 0; k < nArray[2]; ++k) {
                            lArray[n2] = ((int[][][])object)[i][j][k];
                            ++n2;
                        }
                    }
                }
                dataContainer.setArrayData(lArray, 0, nArray);
                break;
            }
            case 1: {
                nArray[0] = ((long[][][])object).length;
                nArray[1] = ((long[][][])object)[0].length;
                nArray[2] = ((long[][][])object)[0][0].length;
                n = nArray[0] * nArray[1] * nArray[2];
                long[] lArray = new long[n];
                int n3 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((long[][][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        if (((long[][][])object)[i][j].length != nArray[2]) {
                            throw new VnanoException(ErrorType.JAGGED_ARRAY);
                        }
                        for (int k = 0; k < nArray[2]; ++k) {
                            lArray[n3] = ((long[][][])object)[i][j][k];
                            ++n3;
                        }
                    }
                }
                dataContainer.setArrayData(lArray, 0, nArray);
                break;
            }
            case 2: {
                nArray[0] = ((float[][][])object).length;
                nArray[1] = ((float[][][])object)[0].length;
                nArray[2] = ((float[][][])object)[0][0].length;
                n = nArray[0] * nArray[1] * nArray[2];
                double[] dArray = new double[n];
                int n4 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((float[][][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        if (((float[][][])object)[i][j].length != nArray[2]) {
                            throw new VnanoException(ErrorType.JAGGED_ARRAY);
                        }
                        for (int k = 0; k < nArray[2]; ++k) {
                            dArray[n4] = ((float[][][])object)[i][j][k];
                            ++n4;
                        }
                    }
                }
                dataContainer.setArrayData(dArray, 0, nArray);
                break;
            }
            case 3: {
                nArray[0] = ((double[][][])object).length;
                nArray[1] = ((double[][][])object)[0].length;
                nArray[2] = ((double[][][])object)[0][0].length;
                n = nArray[0] * nArray[1] * nArray[2];
                double[] dArray = new double[n];
                int n5 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((double[][][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        if (((double[][][])object)[i][j].length != nArray[2]) {
                            throw new VnanoException(ErrorType.JAGGED_ARRAY);
                        }
                        for (int k = 0; k < nArray[2]; ++k) {
                            dArray[n5] = ((double[][][])object)[i][j][k];
                            ++n5;
                        }
                    }
                }
                dataContainer.setArrayData(dArray, 0, nArray);
                break;
            }
            case 5: {
                nArray[0] = ((boolean[][][])object).length;
                nArray[1] = ((boolean[][][])object)[0].length;
                nArray[2] = ((boolean[][][])object)[0][0].length;
                n = nArray[0] * nArray[1] * nArray[2];
                boolean[] blArray = new boolean[n];
                int n6 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((boolean[][][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        if (((boolean[][][])object)[i][j].length != nArray[2]) {
                            throw new VnanoException(ErrorType.JAGGED_ARRAY);
                        }
                        for (int k = 0; k < nArray[2]; ++k) {
                            blArray[n6] = ((boolean[][][])object)[i][j][k];
                            ++n6;
                        }
                    }
                }
                dataContainer.setArrayData(blArray, 0, nArray);
                break;
            }
            case 4: {
                nArray[0] = ((String[][][])object).length;
                nArray[1] = ((String[][][])object)[0].length;
                nArray[2] = ((String[][][])object)[0][0].length;
                n = nArray[0] * nArray[1] * nArray[2];
                String[] stringArray = new String[n];
                int n7 = 0;
                for (int i = 0; i < nArray[0]; ++i) {
                    if (((String[][][])object)[i].length != nArray[1]) {
                        throw new VnanoException(ErrorType.JAGGED_ARRAY);
                    }
                    for (int j = 0; j < nArray[1]; ++j) {
                        if (((String[][][])object)[i][j].length != nArray[2]) {
                            throw new VnanoException(ErrorType.JAGGED_ARRAY);
                        }
                        for (int k = 0; k < nArray[2]; ++k) {
                            stringArray[n7] = ((String[][][])object)[i][j][k];
                            ++n7;
                        }
                    }
                }
                dataContainer.setArrayData(stringArray, 0, nArray);
                break;
            }
            case 6: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
            case 7: {
                throw new VnanoFatalException("Unexpected conversion executed.");
            }
        }
    }

    public Object convertToExternalObject(DataContainer<?> dataContainer) throws VnanoException {
        Object obj = dataContainer.getArrayData();
        int[] nArray = dataContainer.getArrayLengths();
        int n = dataContainer.getArraySize();
        switch (this.arrayRank) {
            case 0: {
                int n2 = dataContainer.getArrayOffset();
                switch (this.externalType.ordinal()) {
                    case 0: {
                        return (int)((long[])obj)[n2];
                    }
                    case 1: {
                        return ((long[])obj)[n2];
                    }
                    case 2: {
                        return Float.valueOf((float)((double[])obj)[n2]);
                    }
                    case 3: {
                        return ((double[])obj)[n2];
                    }
                    case 5: {
                        return ((boolean[])obj)[n2];
                    }
                    case 4: {
                        return ((String[])obj)[n2];
                    }
                    case 6: {
                        throw new VnanoFatalException("Unexpected conversion executed.");
                    }
                    case 7: {
                        VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_DATA_TYPE, new String[]{DataTypeName.getDataTypeNameOf(DataType.VOID)});
                        throw vnanoException;
                    }
                }
                break;
            }
            case 1: {
                switch (this.externalType.ordinal()) {
                    case 0: {
                        int[] nArray2 = new int[n];
                        for (int i = 0; i < n; ++i) {
                            nArray2[i] = (int)((long[])obj)[i];
                        }
                        return nArray2;
                    }
                    case 1: {
                        long[] lArray = new long[n];
                        for (int i = 0; i < n; ++i) {
                            lArray[i] = ((long[])obj)[i];
                        }
                        return lArray;
                    }
                    case 2: {
                        float[] fArray = new float[n];
                        for (int i = 0; i < n; ++i) {
                            fArray[i] = (float)((double[])obj)[i];
                        }
                        return fArray;
                    }
                    case 3: {
                        double[] dArray = new double[n];
                        for (int i = 0; i < n; ++i) {
                            dArray[i] = ((double[])obj)[i];
                        }
                        return dArray;
                    }
                    case 5: {
                        boolean[] blArray = new boolean[n];
                        for (int i = 0; i < n; ++i) {
                            blArray[i] = ((boolean[])obj)[i];
                        }
                        return blArray;
                    }
                    case 4: {
                        String[] stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = ((String[])obj)[i];
                        }
                        return stringArray;
                    }
                    case 6: {
                        throw new VnanoFatalException("Unexpected conversion executed.");
                    }
                    case 7: {
                        VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_DATA_TYPE, new String[]{DataTypeName.getDataTypeNameOf(DataType.VOID)});
                        throw vnanoException;
                    }
                }
                break;
            }
            case 2: {
                switch (this.externalType.ordinal()) {
                    case 0: {
                        int[][] nArray3 = new int[nArray[0]][nArray[1]];
                        int n3 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                nArray3[i][j] = (int)((long[])obj)[n3];
                                ++n3;
                            }
                        }
                        return nArray3;
                    }
                    case 1: {
                        long[][] lArray = new long[nArray[0]][nArray[1]];
                        int n4 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                lArray[i][j] = ((long[])obj)[n4];
                                ++n4;
                            }
                        }
                        return lArray;
                    }
                    case 2: {
                        float[][] fArray = new float[nArray[0]][nArray[1]];
                        int n5 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                fArray[i][j] = (float)((double[])obj)[n5];
                                ++n5;
                            }
                        }
                        return fArray;
                    }
                    case 3: {
                        double[][] dArray = new double[nArray[0]][nArray[1]];
                        int n6 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                dArray[i][j] = ((double[])obj)[n6];
                                ++n6;
                            }
                        }
                        return dArray;
                    }
                    case 5: {
                        boolean[][] blArray = new boolean[nArray[0]][nArray[1]];
                        int n7 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                blArray[i][j] = ((boolean[])obj)[n7];
                                ++n7;
                            }
                        }
                        return blArray;
                    }
                    case 4: {
                        String[][] stringArray = new String[nArray[0]][nArray[1]];
                        int n8 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                stringArray[i][j] = ((String[])obj)[n8];
                                ++n8;
                            }
                        }
                        return stringArray;
                    }
                    case 6: {
                        throw new VnanoFatalException("Unexpected conversion executed.");
                    }
                    case 7: {
                        VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_DATA_TYPE, new String[]{DataTypeName.getDataTypeNameOf(DataType.VOID)});
                        throw vnanoException;
                    }
                }
            }
            case 3: {
                switch (this.externalType.ordinal()) {
                    case 0: {
                        int[][][] nArray4 = new int[nArray[0]][nArray[1]][nArray[2]];
                        int n9 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                for (int k = 0; k < nArray[2]; ++k) {
                                    nArray4[i][j][k] = (int)((long[])obj)[n9];
                                    ++n9;
                                }
                            }
                        }
                        return nArray4;
                    }
                    case 1: {
                        long[][][] lArray = new long[nArray[0]][nArray[1]][nArray[2]];
                        int n10 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                for (int k = 0; k < nArray[2]; ++k) {
                                    lArray[i][j][k] = ((long[])obj)[n10];
                                    ++n10;
                                }
                            }
                        }
                        return lArray;
                    }
                    case 2: {
                        float[][][] fArray = new float[nArray[0]][nArray[1]][nArray[2]];
                        int n11 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                for (int k = 0; k < nArray[2]; ++k) {
                                    fArray[i][j][k] = (float)((double[])obj)[n11];
                                    ++n11;
                                }
                            }
                        }
                        return fArray;
                    }
                    case 3: {
                        double[][][] dArray = new double[nArray[0]][nArray[1]][nArray[2]];
                        int n12 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                for (int k = 0; k < nArray[2]; ++k) {
                                    dArray[i][j][k] = ((double[])obj)[n12];
                                    ++n12;
                                }
                            }
                        }
                        return dArray;
                    }
                    case 5: {
                        boolean[][][] blArray = new boolean[nArray[0]][nArray[1]][nArray[2]];
                        int n13 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                for (int k = 0; k < nArray[2]; ++k) {
                                    blArray[i][j][k] = ((boolean[])obj)[n13];
                                    ++n13;
                                }
                            }
                        }
                        return blArray;
                    }
                    case 4: {
                        String[][][] stringArray = new String[nArray[0]][nArray[1]][nArray[2]];
                        int n14 = 0;
                        for (int i = 0; i < nArray[0]; ++i) {
                            for (int j = 0; j < nArray[1]; ++j) {
                                for (int k = 0; k < nArray[2]; ++k) {
                                    stringArray[i][j][k] = ((String[])obj)[n14];
                                    ++n14;
                                }
                            }
                        }
                        return stringArray;
                    }
                    case 6: {
                        throw new VnanoFatalException("Unexpected conversion executed.");
                    }
                    case 7: {
                        VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_DATA_TYPE, new String[]{DataTypeName.getDataTypeNameOf(DataType.VOID)});
                        throw vnanoException;
                    }
                }
            }
            default: {
                String string;
                String string2 = DataConverter.getExternalTypeNameOf(obj.getClass());
                DataType dataType = EXTERNAL_NAME_DATA_TYPE_MAP.get(string2);
                String string3 = string = DataTypeName.getDataTypeNameOf(dataType);
                for (int i = 0; i < this.arrayRank; ++i) {
                    string3 = string3 + EXTERNAL_ARRAY_BRACKET;
                }
                VnanoException vnanoException = new VnanoException(ErrorType.UNCONVERTIBLE_INTERNAL_ARRAY, new String[]{string3});
                throw vnanoException;
            }
        }
        throw new VnanoFatalException("Unexpected conversion executed.");
    }

    static {
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT32, DataType.INT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT64, DataType.INT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT32, DataType.FLOAT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT64, DataType.FLOAT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_STRING, DataType.STRING);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_BOOL, DataType.BOOL);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_ANY, DataType.ANY);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_VOID, DataType.VOID);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT32_WRAPPER, DataType.INT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT64_WRAPPER, DataType.INT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT32_WRAPPER, DataType.FLOAT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT64_WRAPPER, DataType.FLOAT64);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_BOOL_WRAPPER, DataType.BOOL);
        EXTERNAL_NAME_DATA_TYPE_MAP.put(EXTERNAL_TYPE_NAME_VOID_WRAPPER, DataType.VOID);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP = new HashMap();
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT32, ExternalType.INT32);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT64, ExternalType.INT64);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT32, ExternalType.FLOAT32);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT64, ExternalType.FLOAT64);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_STRING, ExternalType.STRING);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_BOOL, ExternalType.BOOL);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_ANY, ExternalType.ANY);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_VOID, ExternalType.VOID);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT32_WRAPPER, ExternalType.INT32);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_INT64_WRAPPER, ExternalType.INT64);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT32_WRAPPER, ExternalType.FLOAT32);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_FLOAT64_WRAPPER, ExternalType.FLOAT64);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_BOOL_WRAPPER, ExternalType.BOOL);
        EXTERNAL_NAME_EXTERNAL_TYPE_MAP.put(EXTERNAL_TYPE_NAME_VOID_WRAPPER, ExternalType.VOID);
        EXTERNAL_TYPE_DATA_TYPE_MAP = new HashMap();
        EXTERNAL_TYPE_DATA_TYPE_MAP.put(ExternalType.INT64, DataType.INT64);
        EXTERNAL_TYPE_DATA_TYPE_MAP.put(ExternalType.FLOAT64, DataType.FLOAT64);
        EXTERNAL_TYPE_DATA_TYPE_MAP.put(ExternalType.BOOL, DataType.BOOL);
        EXTERNAL_TYPE_DATA_TYPE_MAP.put(ExternalType.STRING, DataType.STRING);
        EXTERNAL_TYPE_DATA_TYPE_MAP.put(ExternalType.ANY, DataType.ANY);
        EXTERNAL_TYPE_DATA_TYPE_MAP.put(ExternalType.VOID, DataType.VOID);
        DATA_TYPE_EXTERNAL_TYPE_MAP = new HashMap();
        DATA_TYPE_EXTERNAL_TYPE_MAP.put(DataType.INT64, ExternalType.INT64);
        DATA_TYPE_EXTERNAL_TYPE_MAP.put(DataType.FLOAT64, ExternalType.FLOAT64);
        DATA_TYPE_EXTERNAL_TYPE_MAP.put(DataType.BOOL, ExternalType.BOOL);
        DATA_TYPE_EXTERNAL_TYPE_MAP.put(DataType.STRING, ExternalType.STRING);
        DATA_TYPE_EXTERNAL_TYPE_MAP.put(DataType.ANY, ExternalType.ANY);
        DATA_TYPE_EXTERNAL_TYPE_MAP.put(DataType.VOID, ExternalType.VOID);
    }

    private static enum ExternalType {
        INT32,
        INT64,
        FLOAT32,
        FLOAT64,
        STRING,
        BOOL,
        ANY,
        VOID;

    }
}

