/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.ConnectorImplementationContainer;
import org.vcssl.connect.ConnectorImplementationLoader;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.interconnect.MetaQualifiedFileLoader;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.IdentifierSyntax;

public class PluginLoader {
    private static final String LIST_FILE_COMMENT_LINE_HEAD = "#";
    private final String DEFAULT_ENCODING;
    private String pluginListPath = null;
    private long pluginListLastMod = -1L;
    private List<String> pluginNameList = null;
    private List<String> pluginFilePathList = null;
    private List<String> pluginClassPathList = null;
    private List<Object> pluginInstanceList = null;
    private List<Long> pluginLastModList = null;
    private File pluginDirectory = null;

    public PluginLoader(String string) {
        this.DEFAULT_ENCODING = string;
    }

    public void setPluginListPath(String string) {
        this.pluginListPath = string;
        this.pluginListLastMod = -1L;
    }

    public void load() throws VnanoException {
        if (this.pluginListPath != null) {
            this.loadPluginPaths();
        }
        if (this.pluginFilePathList != null) {
            this.loadPlugins();
        }
    }

    public boolean hasPlugins() {
        return this.pluginInstanceList != null && this.pluginInstanceList.size() != 0;
    }

    public String[] getPluginNames() {
        return this.pluginNameList.toArray(new String[0]);
    }

    public Object[] getPluginInstances() {
        return this.pluginInstanceList.toArray(new Object[0]);
    }

    private void loadPluginPaths() throws VnanoException {
        String[] stringArray;
        File file = new File(this.pluginListPath);
        if (!file.exists()) {
            throw new VnanoException(ErrorType.PLUGIN_LIST_FILE_DOES_NOT_EXIST, this.pluginListPath);
        }
        if (file.lastModified() == this.pluginListLastMod) {
            return;
        }
        this.pluginNameList = new ArrayList<String>();
        this.pluginFilePathList = new ArrayList<String>();
        this.pluginClassPathList = new ArrayList<String>();
        this.pluginInstanceList = new ArrayList<Object>();
        this.pluginLastModList = new ArrayList<Long>();
        this.pluginDirectory = file.getParentFile();
        String string = MetaQualifiedFileLoader.load(this.pluginListPath, this.DEFAULT_ENCODING);
        for (String string2 : stringArray = string.split("\\n")) {
            if (string2.trim().isEmpty() || string2.trim().startsWith(LIST_FILE_COMMENT_LINE_HEAD)) continue;
            String string3 = string2;
            if (string3.endsWith(".class")) {
                string3 = string3.substring(0, string3.length() - 6);
            }
            if (string3.startsWith("./") || string3.startsWith(".\\")) {
                string3 = string3.substring(2, string3.length());
            }
            string3 = string3.replace('/', '.');
            string3 = string3.replace('\\', '.');
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(this.pluginDirectory, string2);
            }
            String string4 = file2.getPath();
            String string5 = file2.getName();
            if (string5.endsWith(".class")) {
                string5 = string5.substring(0, string5.length() - 6);
            }
            string5 = IdentifierSyntax.normalizeScriptIdentifier(string5);
            this.pluginFilePathList.add(string4);
            this.pluginClassPathList.add(string3);
            this.pluginNameList.add(string5);
            this.pluginInstanceList.add(null);
            this.pluginLastModList.add(-1L);
        }
        this.pluginListLastMod = file.lastModified();
    }

    private void loadPlugins() throws VnanoException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        URL uRL;
        int n = this.pluginFilePathList.size();
        try {
            uRL = this.pluginDirectory.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new VnanoException(ErrorType.PLUGIN_DIRECTORY_IS_NOT_ACCESSIBLE, this.pluginDirectory.getPath(), (Throwable)malformedURLException);
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
        ConnectorImplementationLoader connectorImplementationLoader = new ConnectorImplementationLoader(uRLClassLoader);
        String string = "";
        String string2 = "";
        ConnectorException connectorException = null;
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, false);
        for (int i = 0; i < n; ++i) {
            object3 = this.pluginFilePathList.get(i);
            serializable = new File((String)object3);
            if (!((File)serializable).exists()) {
                string = string + (!string.isEmpty() ? ", " : "") + ((File)serializable).getName();
                blArray[i] = true;
                continue;
            }
            if (((File)serializable).lastModified() == this.pluginLastModList.get(i).longValue()) continue;
            object2 = this.pluginClassPathList.get(i);
            try {
                object = connectorImplementationLoader.load((String)object2);
            }
            catch (ConnectorException connectorException2) {
                string2 = string2 + (!string2.isEmpty() ? ", " : "") + ((File)serializable).getName();
                connectorException = connectorException2;
                blArray[i] = true;
                continue;
            }
            Object object4 = ((ConnectorImplementationContainer)object).getConnectorImplementation();
            this.pluginInstanceList.set(i, object4);
            this.pluginNameList.set(i, ((File)serializable).getName());
            this.pluginLastModList.set(i, ((File)serializable).lastModified());
        }
        if (!string.isEmpty() || !string.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object3 = new ArrayList();
            serializable = new ArrayList();
            object = new ArrayList();
            object2 = new ArrayList();
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                arrayList.add(this.pluginFilePathList.get(i));
                object3.add(this.pluginClassPathList.get(i));
                serializable.add(this.pluginNameList.get(i));
                object.add(this.pluginInstanceList.get(i));
                object2.add(this.pluginLastModList.get(i));
            }
            this.pluginFilePathList = arrayList;
            this.pluginClassPathList = object3;
            this.pluginNameList = serializable;
            this.pluginInstanceList = object;
            this.pluginLastModList = object2;
        }
        if (!string.isEmpty()) {
            throw new VnanoException(ErrorType.PLUGIN_FILE_DOES_NOT_EXIST, string);
        }
        if (!string.isEmpty()) {
            throw new VnanoException(ErrorType.PLUGIN_INITIALIZATION_FAILED, string, connectorException);
        }
    }
}

