/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.interconnect.MetaQualifiedFileLoader;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.IdentifierSyntax;

public class ScriptLoader {
    private static final String LIST_FILE_COMMENT_LINE_HEAD = "#";
    private final String DEFAULT_ENCODING;
    private String mainScriptName = null;
    private String mainScriptPath = null;
    private String mainScriptContent = null;
    private long mainScriptLastMod = -1L;
    private String libraryScriptListPath = null;
    private long libraryScriptListLastMod = -1L;
    private List<String> libraryScriptNameList = null;
    private List<String> libraryScriptPathList = null;
    private List<String> libraryScriptRawPathList = null;
    private List<String> libraryScriptContentList = null;
    private List<Long> libraryScriptLastModList = null;

    public ScriptLoader(String string) {
        this.DEFAULT_ENCODING = string;
    }

    public void setMainScriptPath(String string) {
        this.mainScriptPath = string;
    }

    public void setLibraryScriptListPath(String string) {
        this.libraryScriptListPath = string;
        this.libraryScriptListLastMod = -1L;
    }

    public void load() throws VnanoException {
        if (this.mainScriptPath != null) {
            this.loadMainScriptContent();
        }
        if (this.libraryScriptListPath != null) {
            this.loadLibraryScriptPaths();
        }
        if (this.libraryScriptPathList != null) {
            this.loadLibraryScriptContents();
        }
    }

    public boolean hasMainScript() {
        return this.mainScriptContent != null;
    }

    public String getMainScriptName() {
        return this.mainScriptName;
    }

    public String getMainScriptPath() {
        return this.mainScriptPath;
    }

    public String getMainScriptContent() {
        return this.mainScriptContent;
    }

    public boolean hasLibraryScripts() {
        return this.libraryScriptContentList != null && this.libraryScriptContentList.size() != 0;
    }

    public String[] getLibraryScriptNames() {
        return this.libraryScriptNameList.toArray(new String[0]);
    }

    public String[] getLibraryScriptPaths(boolean bl) {
        if (bl) {
            return this.libraryScriptRawPathList.toArray(new String[0]);
        }
        return this.libraryScriptPathList.toArray(new String[0]);
    }

    public String[] getLibraryScriptContents() {
        return this.libraryScriptContentList.toArray(new String[0]);
    }

    private void loadLibraryScriptPaths() throws VnanoException {
        String[] stringArray;
        File file = new File(this.libraryScriptListPath);
        if (!file.exists()) {
            throw new VnanoException(ErrorType.LIBRARY_LIST_FILE_DOES_NOT_EXIST, this.libraryScriptListPath);
        }
        if (file.lastModified() == this.libraryScriptListLastMod) {
            return;
        }
        this.libraryScriptNameList = new ArrayList<String>();
        this.libraryScriptPathList = new ArrayList<String>();
        this.libraryScriptRawPathList = new ArrayList<String>();
        this.libraryScriptContentList = new ArrayList<String>();
        this.libraryScriptLastModList = new ArrayList<Long>();
        File file2 = file.getParentFile();
        String string = MetaQualifiedFileLoader.load(this.libraryScriptListPath, this.DEFAULT_ENCODING);
        for (String string2 : stringArray = string.split("\\n")) {
            if (string2.trim().isEmpty() || string2.trim().startsWith(LIST_FILE_COMMENT_LINE_HEAD)) continue;
            File file3 = new File(string2);
            if (!file3.isAbsolute()) {
                file3 = new File(file2, string2);
            }
            String string3 = IdentifierSyntax.normalizeScriptIdentifier(file3.getName());
            this.libraryScriptPathList.add(file3.getPath());
            this.libraryScriptRawPathList.add(string2);
            this.libraryScriptNameList.add(string3);
            this.libraryScriptContentList.add("");
            this.libraryScriptLastModList.add(-1L);
        }
        this.libraryScriptListLastMod = file.lastModified();
    }

    private void loadMainScriptContent() throws VnanoException {
        File file = new File(this.mainScriptPath);
        if (!file.exists()) {
            throw new VnanoException(ErrorType.SCRIPT_FILE_DOES_NOT_EXIST, this.mainScriptPath);
        }
        if (file.lastModified() == this.mainScriptLastMod) {
            return;
        }
        this.mainScriptName = file.getName();
        try {
            this.mainScriptContent = MetaQualifiedFileLoader.load(this.mainScriptPath, this.DEFAULT_ENCODING);
        }
        catch (VnanoException vnanoException) {
            this.mainScriptName = null;
            this.mainScriptContent = null;
            this.mainScriptLastMod = -1L;
            throw vnanoException;
        }
        this.mainScriptLastMod = file.lastModified();
    }

    private void loadLibraryScriptContents() throws VnanoException {
        Object object;
        Serializable serializable;
        Object object2;
        int n = this.libraryScriptPathList.size();
        String string = "";
        String string2 = "";
        Exception exception = null;
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, false);
        for (int i = 0; i < n; ++i) {
            object2 = this.libraryScriptPathList.get(i);
            serializable = new File((String)object2);
            if (!((File)serializable).exists()) {
                string = string + (!string.isEmpty() ? ", " : "") + ((File)serializable).getName();
                blArray[i] = true;
                continue;
            }
            if (((File)serializable).lastModified() == this.libraryScriptLastModList.get(i).longValue()) continue;
            object = null;
            try {
                object = MetaQualifiedFileLoader.load((String)object2, this.DEFAULT_ENCODING);
            }
            catch (Exception exception2) {
                string2 = string2 + (!string2.isEmpty() ? ", " : "") + ((File)serializable).getName();
                exception = exception2;
                blArray[i] = true;
                continue;
            }
            this.libraryScriptContentList.set(i, (String)object);
            this.libraryScriptNameList.set(i, ((File)serializable).getName());
            this.libraryScriptLastModList.set(i, ((File)serializable).lastModified());
        }
        if (!string.isEmpty() || !string2.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object2 = new ArrayList();
            serializable = new ArrayList();
            object = new ArrayList();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                arrayList.add(this.libraryScriptPathList.get(i));
                object2.add(this.libraryScriptRawPathList.get(i));
                serializable.add(this.libraryScriptNameList.get(i));
                object.add(this.libraryScriptContentList.get(i));
                arrayList2.add(this.libraryScriptLastModList.get(i));
            }
            this.libraryScriptPathList = arrayList;
            this.libraryScriptRawPathList = object2;
            this.libraryScriptNameList = serializable;
            this.libraryScriptContentList = object;
            this.libraryScriptLastModList = arrayList2;
        }
        if (!string.isEmpty()) {
            throw new VnanoException(ErrorType.SCRIPT_FILE_DOES_NOT_EXIST, string);
        }
        if (!string2.isEmpty()) {
            throw new VnanoException(ErrorType.SCRIPT_FILE_IS_NOT_ACCESSIBLE, string2, exception);
        }
    }
}

