/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import org.vcssl.connect.ArrayDataAccessorInterface1;
import org.vcssl.connect.BoolScalarDataAccessorInterface1;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.EngineConnectorInterface1;
import org.vcssl.connect.ExternalFunctionConnectorInterface1;
import org.vcssl.connect.Float64ScalarDataAccessorInterface1;
import org.vcssl.connect.Int64ScalarDataAccessorInterface1;
import org.vcssl.connect.StringScalarDataAccessorInterface1;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.DataConverter;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.memory.DataContainer;

public final class Xfci1ToFunctionAdapter
extends AbstractFunction {
    private ExternalFunctionConnectorInterface1 xfciPlugin = null;
    private String functionName = null;
    private DataConverter[] parameterDataConverters = null;
    private DataType[] parameterDataTypes = null;
    private int[] parameterArrayRanks = null;
    private boolean[] parameterReferencenesses = null;
    private DataConverter returnDataConverter = null;
    private DataType returnDataType = null;
    private int returnArrayRank = -1;
    private String namespaceName = null;

    public Xfci1ToFunctionAdapter(ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1) throws VnanoException {
        this.validate(externalFunctionConnectorInterface1);
        this.xfciPlugin = externalFunctionConnectorInterface1;
        this.functionName = externalFunctionConnectorInterface1.getFunctionName();
        Class<?>[] classArray = this.xfciPlugin.getParameterClasses();
        Class<?> clazz = this.xfciPlugin.getReturnClass(classArray);
        int n = classArray.length;
        this.returnDataConverter = new DataConverter(this.xfciPlugin.getReturnClass(classArray));
        this.returnDataType = this.returnDataConverter.getDataType();
        this.returnArrayRank = this.returnDataConverter.getArrayRank();
        this.parameterDataConverters = new DataConverter[n];
        this.parameterDataTypes = new DataType[n];
        this.parameterArrayRanks = new int[n];
        this.parameterReferencenesses = externalFunctionConnectorInterface1.getParameterReferencenesses();
        for (int i = 0; i < n; ++i) {
            this.parameterDataConverters[i] = new DataConverter(classArray[i]);
            this.parameterDataTypes[i] = this.parameterDataConverters[i].getDataType();
            this.parameterArrayRanks[i] = this.parameterDataConverters[i].getArrayRank();
        }
        for (Class<?> clazz2 : classArray) {
            if (DataConverter.getDataTypeOf(clazz2) != DataType.ANY || !externalFunctionConnectorInterface1.isDataConversionNecessary()) continue;
            throw new VnanoException(ErrorType.DATA_CONVERSION_OF_FUNCTION_PLUGIN_USING_OBJECT_TYPE_SHOULD_BE_DISABLED, new String[]{externalFunctionConnectorInterface1.getFunctionName()});
        }
        if (DataConverter.getDataTypeOf(clazz) == DataType.ANY && externalFunctionConnectorInterface1.isDataConversionNecessary()) {
            throw new VnanoException(ErrorType.DATA_CONVERSION_OF_FUNCTION_PLUGIN_USING_OBJECT_TYPE_SHOULD_BE_DISABLED, new String[]{externalFunctionConnectorInterface1.getFunctionName()});
        }
    }

    public ExternalFunctionConnectorInterface1 getXfci1Plugin() {
        return this.xfciPlugin;
    }

    @Override
    public final String getFunctionName() {
        return this.functionName;
    }

    @Override
    public void setFunctionName(String string) {
        this.functionName = string;
    }

    @Override
    public final boolean hasNamespaceName() {
        return this.namespaceName != null;
    }

    @Override
    public final String getNamespaceName() {
        return this.namespaceName;
    }

    @Override
    public void setNamespaceName(String string) {
        this.namespaceName = string;
    }

    @Override
    public final String[] getParameterNames() {
        return this.xfciPlugin.getParameterNames();
    }

    @Override
    public final String[] getParameterDataTypeNames() {
        int n = this.parameterDataTypes.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = DataTypeName.getDataTypeNameOf(this.parameterDataConverters[i].getDataType());
        }
        return stringArray;
    }

    @Override
    public final int[] getParameterArrayRanks() {
        return this.parameterArrayRanks;
    }

    @Override
    public final boolean[] getParameterDataTypeArbitrarinesses() {
        return this.xfciPlugin.getParameterDataTypeArbitrarinesses();
    }

    @Override
    public final boolean[] getParameterArrayRankArbitrarinesses() {
        return this.xfciPlugin.getParameterArrayRankArbitrarinesses();
    }

    @Override
    public boolean[] getParameterReferencenesses() {
        return this.xfciPlugin.getParameterReferencenesses();
    }

    @Override
    public boolean[] getParameterConstantnesses() {
        return this.xfciPlugin.getParameterConstantnesses();
    }

    @Override
    public final boolean isParameterCountArbitrary() {
        return this.xfciPlugin.isParameterCountArbitrary();
    }

    @Override
    public final boolean hasVariadicParameters() {
        return this.xfciPlugin.hasVariadicParameters();
    }

    @Override
    public final String getReturnDataTypeName(String[] stringArray, int[] nArray) {
        DataType[] dataTypeArray;
        try {
            dataTypeArray = DataTypeName.getDataTypesOf(stringArray);
        }
        catch (VnanoException vnanoException) {
            throw new VnanoFatalException(vnanoException);
        }
        Class<?>[] classArray = DataConverter.getExternalClassesOf(dataTypeArray, nArray);
        Class<?> clazz = this.xfciPlugin.getReturnClass(classArray);
        DataType dataType = DataConverter.getDataTypeOf(clazz);
        return DataTypeName.getDataTypeNameOf(dataType);
    }

    @Override
    public final int getReturnArrayRank(String[] stringArray, int[] nArray) {
        DataType[] dataTypeArray;
        try {
            dataTypeArray = DataTypeName.getDataTypesOf(stringArray);
        }
        catch (VnanoException vnanoException) {
            throw new VnanoFatalException(vnanoException);
        }
        Class<?>[] classArray = DataConverter.getExternalClassesOf(dataTypeArray, nArray);
        Class<?> clazz = this.xfciPlugin.getReturnClass(classArray);
        return DataConverter.getArrayRankOf(clazz);
    }

    @Override
    public final boolean isReturnDataTypeArbitrary() {
        return this.xfciPlugin.isReturnDataTypeArbitrary();
    }

    @Override
    public final boolean isReturnArrayRankArbitrary() {
        return this.xfciPlugin.isReturnArrayRankArbitrary();
    }

    @Override
    public void checkInvokability(String[] stringArray, int[] nArray) throws VnanoException {
        Object[] objectArray;
        if (!this.xfciPlugin.isDataConversionNecessary()) {
            for (Class<DataContainer> stringArray2 : objectArray = this.xfciPlugin.getParameterUnconvertedClasses()) {
                if (stringArray2.isAssignableFrom(DataContainer.class)) continue;
                String[] stringArray3 = new String[]{stringArray2.getCanonicalName(), this.xfciPlugin.getClass().getCanonicalName()};
                throw new VnanoException(ErrorType.INCOMPATIBLE_DATA_ACCESSOR_INTERFACE, stringArray3);
            }
        }
        if (!this.xfciPlugin.isDataConversionNecessary()) {
            int n;
            try {
                objectArray = DataTypeName.getDataTypesOf(stringArray);
            }
            catch (VnanoException vnanoException) {
                throw new VnanoFatalException(vnanoException);
            }
            Class<?>[] classArray = DataConverter.getExternalClassesOf(objectArray, nArray);
            Class<DataContainer> clazz = this.xfciPlugin.getReturnUnconvertedClass(classArray);
            int n2 = n = this.xfciPlugin.getReturnClass(classArray).equals(Void.TYPE) || this.xfciPlugin.getReturnClass(classArray).equals(Void.class) ? 1 : 0;
            if (n == 0 && !clazz.isAssignableFrom(DataContainer.class)) {
                String[] stringArray4 = new String[]{clazz.getCanonicalName(), this.xfciPlugin.getClass().getCanonicalName()};
                throw new VnanoException(ErrorType.INCOMPATIBLE_DATA_ACCESSOR_INTERFACE, stringArray4);
            }
        }
    }

    @Override
    public final void invoke(DataContainer<?> dataContainer, DataContainer<?>[] dataContainerArray) throws VnanoException {
        int n = dataContainerArray.length;
        Object[] objectArray = new Object[n];
        if (this.xfciPlugin.isDataConversionNecessary()) {
            String[] stringArray;
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                stringArray = null;
                if (this.xfciPlugin.isParameterCountArbitrary()) {
                    stringArray = this.parameterDataConverters[0];
                    bl = this.parameterDataTypes[0].equals((Object)DataType.VOID);
                } else {
                    stringArray = this.parameterDataConverters[i];
                    bl = this.parameterDataTypes[i].equals((Object)DataType.VOID);
                }
                if (bl) continue;
                try {
                    objectArray[i] = stringArray.convertToExternalObject(dataContainerArray[i]);
                    continue;
                }
                catch (VnanoException vnanoException) {
                    throw new VnanoFatalException(vnanoException);
                }
            }
            Object object = null;
            try {
                object = this.xfciPlugin.invoke(objectArray);
            }
            catch (Exception exception) {
                stringArray = new String[]{this.xfciPlugin.getFunctionName(), null};
                if (exception instanceof ConnectorException) {
                    stringArray[1] = exception.getMessage();
                }
                throw new VnanoException(ErrorType.EXTERNAL_FUNCTION_PLUGIN_CRASHED, stringArray, (Throwable)exception);
            }
            if (!this.returnDataType.equals((Object)DataType.VOID)) {
                try {
                    this.returnDataConverter.convertToDataContainer(object, dataContainer);
                }
                catch (VnanoException vnanoException) {
                    throw new VnanoFatalException(vnanoException);
                }
            }
        } else {
            Object[] objectArray2 = new DataContainer[n + 1];
            objectArray2[0] = dataContainer;
            for (int i = 0; i < n; ++i) {
                boolean bl = this.xfciPlugin.isParameterCountArbitrary() ? this.parameterReferencenesses[0] : this.parameterReferencenesses[i];
                objectArray2[i + 1] = bl ? dataContainerArray[i] : DataConverter.copyDataContainer(dataContainerArray[i]);
            }
            try {
                this.xfciPlugin.invoke(objectArray2);
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{this.xfciPlugin.getFunctionName(), null};
                if (exception instanceof ConnectorException) {
                    stringArray[1] = exception.getMessage();
                }
                throw new VnanoException(ErrorType.EXTERNAL_FUNCTION_PLUGIN_CRASHED, stringArray, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validate(ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1) throws VnanoException {
        Class<?>[] classArray;
        if (externalFunctionConnectorInterface1.getFunctionName() == null) {
            String string = "getFunctionName(): The returned value is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.hasParameterNames()) {
            if (externalFunctionConnectorInterface1.getParameterNames() == null) {
                String string = "getParameterNames(): The returned array is null.";
                throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
            }
            for (String object : externalFunctionConnectorInterface1.getParameterNames()) {
                if (object != null) continue;
                String string = "getParameterNames(): The returned array contains a null element.";
                throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
            }
        }
        if (externalFunctionConnectorInterface1.getParameterClasses() == null) {
            Object[] objectArray = "getParameterNames(): The returned array is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), objectArray});
        }
        for (Class<?> string : externalFunctionConnectorInterface1.getParameterClasses()) {
            if (string != null) continue;
            String string2 = "getParameterNames(): The returned array contains a null element.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string2});
        }
        int n = externalFunctionConnectorInterface1.getParameterClasses().length;
        if (!externalFunctionConnectorInterface1.isDataConversionNecessary()) {
            void var5_29;
            if (externalFunctionConnectorInterface1.getParameterUnconvertedClasses() == null) {
                String string = "getParameterUnconvertedClasses(): The returned array is null.";
                throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
            }
            Class<?>[] classArray2 = externalFunctionConnectorInterface1.getParameterUnconvertedClasses();
            int n2 = classArray2.length;
            boolean bl = false;
            while (var5_29 < n2) {
                Class<?> clazz = classArray2[var5_29];
                if (clazz == null) {
                    String string = "getParameterUnconvertedClasses(): The returned array contains a null element.";
                    throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
                }
                if (!(clazz.equals(ArrayDataAccessorInterface1.class) || clazz.equals(Int64ScalarDataAccessorInterface1.class) || clazz.equals(Float64ScalarDataAccessorInterface1.class) || clazz.equals(BoolScalarDataAccessorInterface1.class) || clazz.equals(StringScalarDataAccessorInterface1.class) || clazz.equals(DataContainer.class))) {
                    String string = "getParameterUnconvertedClasses(): The returned class/interface \"" + clazz.getName() + "\"is not supported on the current version of Vnano Engine.";
                    throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
                }
                ++var5_29;
            }
        }
        if (externalFunctionConnectorInterface1.getParameterDataTypeArbitrarinesses() == null) {
            String string = "getParameterDataTypeArbitrarinesses(): The returned array is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterDataTypeArbitrarinesses().length != n) {
            String string = "getParameterDataTypeArbitrarinesses(): The number of elements of the returned array is " + externalFunctionConnectorInterface1.getParameterDataTypeArbitrarinesses().length + ", but must be " + n + ", as same as the returned value of getParameterClasses() method.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterArrayRankArbitrarinesses() == null) {
            String string = "getParameterArrayRankArbitrarinesses(): The returned array is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterArrayRankArbitrarinesses().length != n) {
            String string = "getParameterArrayRankArbitrarinesses(): The number of elements of the returned array is " + externalFunctionConnectorInterface1.getParameterArrayRankArbitrarinesses().length + ", but must be " + n + ", as same as the returned value of getParameterClasses() method.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterReferencenesses() == null) {
            String string = "getParameterReferencenesses(): The returned array is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterReferencenesses().length != n) {
            String string = "getParameterReferencenesses(): The number of elements of the returned array is " + externalFunctionConnectorInterface1.getParameterReferencenesses().length + ", but must be " + n + ", as same as the returned value of getParameterClasses() method.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterConstantnesses() == null) {
            String string = "getParameterConstantnesses(): The returned array is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.getParameterConstantnesses().length != n) {
            String string = "getParameterConstantnesses(): The number of elements of the returned array is " + externalFunctionConnectorInterface1.getParameterConstantnesses().length + ", but must be " + n + ", as same as the returned value of getParameterClasses() method.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (externalFunctionConnectorInterface1.hasVariadicParameters()) {
            String string = "hasVariadicParameters(): Returned true, but this feature has not been supported yet on the current version of Vnano Engine.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (!(externalFunctionConnectorInterface1.isReturnDataTypeArbitrary() || externalFunctionConnectorInterface1.isReturnArrayRankArbitrary() || externalFunctionConnectorInterface1.getReturnClass(classArray = externalFunctionConnectorInterface1.getParameterClasses()).equals(Void.TYPE) || externalFunctionConnectorInterface1.getReturnClass(classArray).equals(Void.class))) {
            if (externalFunctionConnectorInterface1.getReturnClass(classArray) == null) {
                String string = "getReturnClass(...): The returned value is null.";
                throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
            }
            if (!externalFunctionConnectorInterface1.isDataConversionNecessary()) {
                if (externalFunctionConnectorInterface1.getReturnUnconvertedClass(classArray) == null) {
                    String string = "getReturnUnconvertedClass(): The returned value is null.";
                    throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
                }
                Class<?> clazz = externalFunctionConnectorInterface1.getReturnUnconvertedClass(classArray);
                if (!(clazz.equals(ArrayDataAccessorInterface1.class) || clazz.equals(Int64ScalarDataAccessorInterface1.class) || clazz.equals(Float64ScalarDataAccessorInterface1.class) || clazz.equals(BoolScalarDataAccessorInterface1.class) || clazz.equals(StringScalarDataAccessorInterface1.class) || clazz.equals(DataContainer.class))) {
                    String string = "getParameterUnconvertedClasses(): The returned class/interface \"" + clazz.getName() + "\"is not supported on the current version of Vnano Engine.";
                    throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
                }
            }
        }
        if (externalFunctionConnectorInterface1.getEngineConnectorClass() == null) {
            String string = "getEngineConnectorClass(...): The returned value is null.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
        if (!externalFunctionConnectorInterface1.getEngineConnectorClass().equals(EngineConnectorInterface1.class)) {
            String string = "getEngineConnectorClass(...): The specified engine connector \"" + externalFunctionConnectorInterface1.getEngineConnectorClass().getName() + "\"is not suppoted on the current version of Vnano Engine.";
            throw new VnanoException(ErrorType.PLUGIN_VALIDATION_FAILED, new String[]{externalFunctionConnectorInterface1.getClass().getName(), string});
        }
    }
}

