/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.ErrorType;

public class DataTypeName {
    public static final String DEFAULT_INT = "int";
    public static final String LONG_INT = "long";
    public static final String DEFAULT_FLOAT = "float";
    public static final String DOUBLE_FLOAT = "double";
    public static final String BOOL = "bool";
    public static final String STRING = "string";
    public static final String ANY = "any";
    public static final String VOID = "void";
    private static final Set<String> DATA_TYPE_NAME_SET = new HashSet<String>(){
        {
            this.add(DataTypeName.DEFAULT_INT);
            this.add(DataTypeName.LONG_INT);
            this.add(DataTypeName.DEFAULT_FLOAT);
            this.add(DataTypeName.DOUBLE_FLOAT);
            this.add(DataTypeName.BOOL);
            this.add(DataTypeName.STRING);
            this.add(DataTypeName.ANY);
            this.add(DataTypeName.VOID);
        }
    };
    private static final Map<String, DataType> DATA_TYPE_NAME_ENUM_MAP = new HashMap<String, DataType>(){
        {
            this.put(DataTypeName.DEFAULT_INT, DataType.INT64);
            this.put(DataTypeName.LONG_INT, DataType.INT64);
            this.put(DataTypeName.DEFAULT_FLOAT, DataType.FLOAT64);
            this.put(DataTypeName.DOUBLE_FLOAT, DataType.FLOAT64);
            this.put(DataTypeName.BOOL, DataType.BOOL);
            this.put(DataTypeName.STRING, DataType.STRING);
            this.put(DataTypeName.ANY, DataType.ANY);
            this.put(DataTypeName.VOID, DataType.VOID);
        }
    };
    private static final Map<DataType, String> DATA_TYPE_ENUM_NAME_MAP = new HashMap<DataType, String>(){
        {
            this.put(DataType.INT64, DataTypeName.DEFAULT_INT);
            this.put(DataType.FLOAT64, DataTypeName.DEFAULT_FLOAT);
            this.put(DataType.BOOL, DataTypeName.BOOL);
            this.put(DataType.STRING, DataTypeName.STRING);
            this.put(DataType.ANY, DataTypeName.ANY);
            this.put(DataType.VOID, DataTypeName.VOID);
        }
    };

    public static final boolean isDataTypeName(String string) {
        return DATA_TYPE_NAME_SET.contains(string);
    }

    public static final String getDataTypeNameOf(DataType dataType) {
        return DATA_TYPE_ENUM_NAME_MAP.get((Object)dataType);
    }

    public static final boolean isDataTypeNameOf(DataType dataType, String string) {
        return DATA_TYPE_NAME_ENUM_MAP.get(string) == dataType;
    }

    public static final String[] getDataTypeNamesOf(DataType[] dataTypeArray) {
        int n = dataTypeArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = DataTypeName.getDataTypeNameOf(dataTypeArray[i]);
        }
        return stringArray;
    }

    public static final DataType getDataTypeOf(String string) throws VnanoException {
        if (DATA_TYPE_NAME_ENUM_MAP.containsKey(string)) {
            return DATA_TYPE_NAME_ENUM_MAP.get(string);
        }
        VnanoException vnanoException = new VnanoException(ErrorType.UNKNOWN_DATA_TYPE, new String[]{string});
        throw vnanoException;
    }

    public static final DataType[] getDataTypesOf(String[] stringArray) throws VnanoException {
        int n = stringArray.length;
        DataType[] dataTypeArray = new DataType[n];
        for (int i = 0; i < n; ++i) {
            dataTypeArray[i] = DataTypeName.getDataTypeOf(stringArray[i]);
        }
        return dataTypeArray;
    }
}

