/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.util.Locale;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.DataTypeName;
import org.vcssl.nano.spec.ErrorType;

public class ErrorMessage {
    public static String generateErrorMessage(ErrorType errorType, Locale locale) {
        return ErrorMessage.generateErrorMessage(errorType, new String[0], locale);
    }

    public static String generateErrorMessage(ErrorType errorType, String[] stringArray, Locale locale) {
        if (errorType == ErrorType.CAST_FAILED_DUE_TO_TYPE) {
            try {
                stringArray[0] = DataTypeName.getDataTypeNameOf(DataType.valueOf(stringArray[0]));
                stringArray[1] = DataTypeName.getDataTypeNameOf(DataType.valueOf(stringArray[1]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (errorType == ErrorType.CAST_FAILED_DUE_TO_VALUE) {
            try {
                stringArray[1] = DataTypeName.getDataTypeNameOf(DataType.valueOf(stringArray[1]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (locale.getLanguage() != null && locale.getLanguage().equals("ja") || locale.getCountry() != null && locale.getCountry().equals("JP")) {
            return ErrorMessage.generateErrorMessageJaJP(errorType, stringArray);
        }
        return ErrorMessage.generateErrorMessageEnUS(errorType, stringArray);
    }

    private static String concatinateWords(String[] stringArray, String string, boolean bl, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i <= n2; ++i) {
            if (bl) {
                stringBuilder.append('\"');
                stringBuilder.append(stringArray[i]);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(stringArray[i]);
            }
            if (i == n2) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String generateErrorMessageJaJP(ErrorType errorType, String[] stringArray) {
        switch (errorType) {
            case VARIABLE_IS_NOT_FOUND: {
                return "\u5ba3\u8a00\u3055\u308c\u3066\u3044\u306a\u3044\u5909\u6570\u300c " + stringArray[0] + " \u300d\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case FUNCTION_IS_NOT_FOUND: {
                return "\u547c\u3073\u51fa\u3057\u3066\u3044\u308b\u95a2\u6570\u300c " + stringArray[0] + " \u300d\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u5f15\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + (2 <= stringArray.length ? "\u3082\u3057\u304b\u3057\u3066 " + ErrorMessage.concatinateWords(stringArray, " \u304b ", false, 1, stringArray.length - 1) + " \u3067\u306f\u306a\u3044\u3067\u3059\u304b\uff1f" : "");
            }
            case STATEMENT_END_IS_NOT_FOUND: {
                return "\u6587\u306e\u7d42\u7aef\u304c\u3042\u308a\u307e\u305b\u3093\uff08\u300c ; \u300d\u304c\u5fc5\u8981\u3067\u3059\uff09\u3002";
            }
            case INVALID_EXPRESSION_SYNTAX: {
                return "\u5f0f\u306e\u5185\u5bb9\u3092\u6b63\u3057\u304f\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u5f0f\u306e\u3069\u3053\u304b\u306b\u5fc5\u8981\u306a\u8981\u7d20\u304c\u6b20\u3051\u3066\u3044\u308b\u304b\u3001( ) \u3084 [ ] \u306e\u5bfe\u5fdc\u304c\u305a\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u306a\u3069\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002";
            }
            case OPENING_PARENTHESES_IS_DEFICIENT: {
                return "\u958b\u304d\u62ec\u5f27\u300c ( \u300d\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case CLOSING_PARENTHESES_IS_DEFICIENT: {
                return "\u9589\u3058\u62ec\u5f27\u300c ) \u300d\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case OPENING_SUBSCRIPT_OPERATOR_IS_DEFICIENT: {
                return "\u914d\u5217\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u59cb\u70b9\u300c [ \u300d\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case CLOSING_SUBSCRIPT_OPERATOR_IS_DEFICIENT: {
                return "\u914d\u5217\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u7d42\u7aef\u300c ] \u300d\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case INT_LITERAL_STARTS_WITH_ZERO: {
                return "\u300c 0 \u300d\u3067\u59cb\u307e\u308b\u6574\u6570\u8868\u8a18\u306f\u30018\u9032\u6570\u304b10\u9032\u6570\u304b\u304c\u7d1b\u3089\u308f\u3057\u3044\u305f\u3081\u3001\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u30028\u9032\u6570\u306e\u6574\u6570\u306e\u5148\u982d\u306b\u306f\u3001\u4ee3\u308f\u308a\u306b\u300c 0o \u300d\u3092\u4ed8\u3051\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case STRING_LITERAL_IS_NOT_CLOSED: {
                return "\u9589\u3058\u3066\u3044\u306a\u3044\u6587\u5b57\u5217\u30ea\u30c6\u30e9\u30eb \"...\" \u304c\u5b58\u5728\u3057\u307e\u3059\u3002";
            }
            case INVALID_DATA_TYPES_FOR_UNARY_OPERATOR: {
                return "\u524d\u7f6e\u30fb\u5f8c\u7f6e\u6f14\u7b97\u5b50\u306e\u300c " + stringArray[0] + " \u300d\u306f\u3001" + stringArray[1] + "\u578b\u306e\u5024\u3084\u5909\u6570\u306b\u5bfe\u3057\u3066\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_DATA_TYPES_FOR_BINARY_OPERATOR: {
                return "\u4e8c\u9805\u6f14\u7b97\u5b50\u306e\u300c " + stringArray[0] + " \u300d\u306f\u3001" + stringArray[1] + "\u578b\u3068" + stringArray[2] + "\u578b\u306e\u5024\u3084\u5909\u6570\u306e\u7d44\u307f\u5408\u308f\u305b\u306b\u5bfe\u3057\u3066\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_RANKS_FOR_VECTOR_OPERATION: {
                return "\u914d\u5217\u540c\u58eb\u306e\u300c " + stringArray[0] + " \u300d\u6f14\u7b97\u306f\u3001\u5de6\u53f3\u306e\u914d\u5217\u306e\u6b21\u5143\u6570\u304c\u7b49\u3057\u3044\u5834\u5408\u306b\u3057\u304b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u304c\u3001\u7570\u306a\u308b\u6b21\u5143\u6570\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case INVALID_COMPOUND_ASSIGNMENT_BETWEEN_SCALAR_AND_ARRAY: {
                return "\u5fa9\u53f7\u4ee3\u5165\u6f14\u7b97\u300c " + stringArray[0] + " \u300d\u306f\u3001\u5de6\u8fba\u304c\u975e\u914d\u5217\u3001\u53f3\u8fba\u304c\u914d\u5217\u306e\u5834\u5408\u306b\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_TYPE_TOKEN_IN_EXPRESSION: {
                return "\u5358\u8a9e\u300c " + stringArray[0] + " \u300d\u306f\u3001\u5f0f\u306e\u4e2d\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_IDENTIFIER_TYPE: {
                return "\u5909\u6570/\u95a2\u6570\u306b\u4ed8\u3051\u3089\u308c\u305f\u540d\u524d\u300c " + stringArray[0] + " \u300d\u306f\u3001\u4ed6\u306b\u7279\u5225\u306a\u610f\u5473\u3092\u6301\u3064\u5358\u8a9e\u3084\u5024\u3067\u3042\u308b\u305f\u3081\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_IDENTIFIER_SYNTAX: {
                return "\u5909\u6570/\u95a2\u6570\u306b\u4ed8\u3051\u3089\u308c\u305f\u540d\u524d\u300c " + stringArray[0] + " \u300d\u306f\u3001\u30eb\u30fc\u30eb\u4e0a\u306e\u5236\u9650\u306b\u3088\u308a\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\uff08\u6570\u5b57\u3067\u59cb\u307e\u3063\u305f\u308a\u3001\u8a18\u53f7\u3092\u542b\u3080\u306a\u3069\uff09\u3002";
            }
            case IDENTIFIER_IS_RESERVED_WORD: {
                return "\u5909\u6570/\u95a2\u6570\u306b\u4ed8\u3051\u3089\u308c\u305f\u540d\u524d\u300c " + stringArray[0] + " \u300d\u306f\u3001\u4e88\u7d04\u8a9e\u3067\u3042\u308b\u305f\u3081\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case NO_IDENTIFIER_IN_VARIABLE_DECLARATION: {
                return "\u5909\u6570\u306e\u5ba3\u8a00\u3067\u306f\u3001\u30c7\u30fc\u30bf\u578b\u540d\u306e\u5f8c\u306b\u5909\u6570\u540d\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case NO_DATA_TYPE_IN_VARIABLE_DECLARATION: {
                return "\u5909\u6570\u306e\u5ba3\u8a00\u3067\u306f\u3001\u30c7\u30fc\u30bf\u578b\u540d\u306e\u8a18\u8ff0\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case PREFIX_MODIFIER_AFTER_TYPE_NAME: {
                return "\u300c " + stringArray[0] + " \u300d\u306f\u3001\u30c7\u30fc\u30bf\u578b\u540d\u306e\u5f8c\u3067\u306f\u306a\u304f\u3001\u524d\u306b\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            case POSTFIX_MODIFIER_BEFORE_TYPE_NAME: {
                return "\u300c " + stringArray[0] + " \u300d\u306f\u3001\u30c7\u30fc\u30bf\u578b\u540d\u306e\u524d\u3067\u306f\u306a\u304f\u3001\u5f8c\u306b\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            case TOO_MANY_TOKENS_FOR_VARIABLE_DECLARATION: {
                return "\u5909\u6570\u5ba3\u8a00\u6587\u306e\u5f8c\u534a\u306b\u3001\u4f59\u5206\u306a\u8a18\u8ff0\u304c\u5b58\u5728\u3057\u307e\u3059\u3002";
            }
            case NO_PARTIAL_EXPRESSION: {
                return "\u5f0f\u306e\u4e2d\u306b\u7a7a\u306e\u62ec\u5f27 ( ) \u304c\u3042\u308a\u307e\u3059\u3002";
            }
            case OPERAND_IS_MISSING_AT_RIGHT: {
                return "\u300c " + stringArray[0] + " \u300d\u306e\u53f3\u5074\u306b\u3001\u5024\u3084\u5909\u6570\u306a\u3069\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case OPERAND_IS_MISSING_AT_LEFT: {
                return "\u300c " + stringArray[0] + " \u300d\u306e\u5de6\u5074\u306b\u3001\u5024\u3084\u5909\u6570\u306a\u3069\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case OPERATOR_IS_MISSING_AT_RIGHT: {
                return "\u300c " + stringArray[0] + " \u300d\u3068\u300c " + stringArray[1] + " \u300d\u306e\u9593\u306b\u6f14\u7b97\u5b50\uff08\u300c + \u300d\u306a\u3069\u306e\u8a18\u53f7\uff09\u3084\u6587\u306e\u533a\u5207\u308a\u300c ; \u300d\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case OPERATOR_IS_MISSING_AT_LEFT: {
                return "\u300c " + stringArray[0] + " \u300d\u3068\u300c " + stringArray[1] + " \u300d\u306e\u9593\u306b\u6f14\u7b97\u5b50\uff08\u300c + \u300d\u306a\u3069\u306e\u8a18\u53f7\uff09\u3084\u6587\u306e\u533a\u5207\u308a\u300c ; \u300d\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case DATA_TYPE_IS_MISSING_AT_RIGHT: {
                return "\u300c " + stringArray[0] + " \u300d\u306e\u53f3\u5074\u306b\u3001\u30c7\u30fc\u30bf\u578b\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case CLOSE_PARENTHESIS_IS_MISSING_AT_RIGHT: {
                return "\u300c " + stringArray[0] + " \u300d\u306e\u53f3\u5074\u306b\u3001\u9589\u3058\u62ec\u5f27\u300c ) \u300d\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case NO_OPEN_PARENTHESIS_OF_CONTROL_STATEMENT: {
                return "\u300c " + stringArray[0] + " \u300d\u306e\u5f8c\u306b\u306f\u62ec\u5f27 (...) \u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case NO_CLOSING_PARENTHESIS_OF_CONTROL_STATEMENT: {
                return stringArray[0] + " \u6587\u306e\u62ec\u5f27 (...) \u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            case NO_CONDITION_EXPRESSION_OF_IF_STATEMENT: {
                return "if \u6587\u306e\u62ec\u5f27 (...) \u306e\u4e2d\u306b\u6761\u4ef6\u306e\u8a18\u8ff0\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
            }
            case NO_CONDITION_EXPRESSION_OF_WHILE_STATEMENT: {
                return "while \u6587\u306e\u62ec\u5f27 (...) \u306e\u4e2d\u306b\u6761\u4ef6\u306e\u8a18\u8ff0\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
            }
            case ELEMENTS_OF_FOR_STATEMENT_IS_DEFICIENT: {
                return "for \u6587\u306e\u62ec\u5f27 (...) \u5185\u306f\u3001\u300c ( \u5909\u6570\u5ba3\u8a00\u3084\u521d\u671f\u5316 ; \u7e70\u308a\u8fd4\u3057\u6761\u4ef6 ; \u7e70\u308a\u8fd4\u3057\u6bce\u306e\u66f4\u65b0\u51e6\u7406 ) \u300d\u306e\u3088\u3046\u306b\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            case TOO_MANY_TOKENS_FOR_CONTROL_STATEMENT: {
                return stringArray[0] + " \u6587\u306e\u672b\u5c3e\u306b\u3001\u4f59\u5206\u306a\u8a18\u8ff0\u304c\u5b58\u5728\u3057\u307e\u3059\u3002";
            }
            case NO_BLOCK_AFTER_CONTROL_STATEMENT: {
                return "\u3053\u306e\u8a00\u8a9e\u3067\u306f\u3001" + stringArray[0] + " \u6587\u306b\u306f\u5e38\u306b\u30d6\u30ed\u30c3\u30af {...} \u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case UNKNOWN_DATA_TYPE: {
                return "\u5b58\u5728\u3057\u306a\u3044\u30c7\u30fc\u30bf\u578b\u300c " + stringArray[0] + " \u300d\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case INVALID_IMMEDIATE_VALUE: {
                return "\u89e3\u91c8\u3067\u304d\u306a\u3044\u5024\u300c " + stringArray[0] + " \u300d\u304c\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case UNCONVERTIBLE_DATA_TYPE: {
                return "\u5916\u90e8\u306e\u30c7\u30fc\u30bf\u578b\u300c " + stringArray[0] + " \u300d\u306f\u3001\u3053\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u304c\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u308b\u30c7\u30fc\u30bf\u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case UNCONVERTIBLE_ARRAY: {
                return "\u5916\u90e8\u306e\u914d\u5217\u578b\u300c " + stringArray[0] + " \u300d\u306f\u3001\u6b21\u5143\u6570\u307e\u305f\u306f\u30c7\u30fc\u30bf\u578b\u306a\u3069\u306e\u554f\u984c\u3067\u3001\u3053\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u3067\u306f\u6271\u3048\u307e\u305b\u3093\u3002";
            }
            case UNCONVERTIBLE_INTERNAL_ARRAY: {
                return "\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u306e\u914d\u5217\u578b\u300c " + stringArray[0] + " \u300d\u306f\u3001\u6b21\u5143\u6570\u307e\u305f\u306f\u30c7\u30fc\u30bf\u578b\u306a\u3069\u306e\u554f\u984c\u3067\u3001\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u5916\u90e8\u306e\u30c7\u30fc\u30bf\u578b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INCOMPATIBLE_DATA_ACCESSOR_INTERFACE: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[1] + " \u300d\u304c\u4f7f\u7528\u3057\u3066\u3044\u308b\u30c7\u30fc\u30bf\u5165\u51fa\u529b\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u300c " + stringArray[0] + " \u300d\u306f\u3001\u3053\u306e\u51e6\u7406\u7cfb\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            case JAGGED_ARRAY: {
                return "\u9577\u3055\u304c\u7570\u306a\u308b\u914d\u5217\u3092\u307e\u3068\u3081\u305f\u914d\u5217\u3001\u3044\u308f\u3086\u308b\u30b8\u30e3\u30b0\u914d\u5217\u306f\u3001\u3053\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u3067\u306f\u6271\u3048\u307e\u305b\u3093\u3002";
            }
            case ARRAY_SIZE_IS_TOO_LARGE_TO_BE_ASSIGNED_TO_SCALAR_VARIABLE: {
                return "\u8981\u7d20\u6570\u304c 1 \u3067\u306f\u306a\u3044\u914d\u5217\u306e\u5024\u3092\u3001\u914d\u5217\u3067\u306f\u306a\u3044\u5909\u6570\u306b\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case CAST_FAILED_DUE_TO_VALUE: {
                return "\u30c7\u30fc\u30bf\u300c " + stringArray[0] + " \u300d\u306e\u300c " + stringArray[1] + " \u300d\u578b\u3078\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            }
            case CAST_FAILED_DUE_TO_TYPE: {
                return "\u300c " + stringArray[0] + " \u300d\u578b\u306e\u30c7\u30fc\u30bf\u306e\u300c " + stringArray[1] + " \u300d\u578b\u3078\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            }
            case FUNCTION_IS_DECLARED_IN_INVALID_PLASE: {
                return "\u95a2\u6570\u3092\u3053\u3053\u3067\u5ba3\u8a00\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_ARGUMENT_DECLARATION: {
                return "\u5f15\u6570\u306e\u5ba3\u8a00\u5185\u5bb9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002";
            }
            case RECURSIVE_FUNCTION_CALL: {
                return "\u95a2\u6570\u306e\u518d\u5e30\u547c\u3073\u51fa\u3057\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u3053\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            case INVALID_EXTERNAL_FUNCTION_SIGNATURE: {
                return "\u5916\u90e8\u95a2\u6570\u306e\u63a5\u7d9a\u6642\u306e\u8868\u8a18\u300c " + stringArray[0] + " \u300d\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002\u6b63\u3057\u3044\u8868\u8a18\u306f\u300c " + stringArray[1] + " \u300d\u304b\u3001\u305d\u3053\u304b\u3089\u95a2\u6570\u540d\u306e\u307f\u3092\u5909\u66f4\u3057\u305f\u3082\u306e\u3067\u3059\u3002";
            }
            case UNSUPPORTED_PLUGIN: {
                return "\u3053\u306e\u51e6\u7406\u7cfb\u3067\u306f\u3001\u300c " + stringArray[0] + " \u300d\u578b\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u30d7\u30e9\u30b0\u30a4\u30f3\u3068\u3057\u3066\u63a5\u7d9a\u3059\u308b\u4e8b\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            case PLUGIN_INITIALIZATION_FAILED: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u521d\u671f\u5316\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            }
            case PLUGIN_FINALIZATION_FAILED: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u7d42\u4e86\u6642\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            }
            case OPTION_KEY_IS_NOT_FOUND: {
                return "\u30aa\u30d7\u30b7\u30e7\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            case OPTION_KEY_HAD_CHANGED: {
                return "\u30aa\u30d7\u30b7\u30e7\u30f3\u300c " + stringArray[0] + " \u300d\u306f\u3001\u300c " + stringArray[1] + " \u300d\u306b\u540d\u79f0\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case INVALID_OPTION_VALUE_TYPE: {
                return "\u30aa\u30d7\u30b7\u30e7\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u5024\u306f\u300c " + stringArray[1] + " \u300d\u578b\u3067\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            case INVALID_OPTION_VALUE_CONTENT: {
                return "\u30aa\u30d7\u30b7\u30e7\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u5024\u300c " + stringArray[1] + " \u300d\u304c\u3001\u6b63\u3057\u3044\u5185\u5bb9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
            }
            case DATA_CONVERSION_OF_FUNCTION_PLUGIN_USING_OBJECT_TYPE_SHOULD_BE_DISABLED: {
                return "\u5916\u90e8\u95a2\u6570\u300c " + stringArray[0] + " \u300d\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u306f\u3001Object\u578b\u306e\u5f15\u6570\u307e\u305f\u306f\u623b\u308a\u5024\u3092\u6301\u3064\u305f\u3081\u3001\u30c7\u30fc\u30bf\u5909\u63db\u6a5f\u80fd\u304c\u7121\u52b9\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002";
            }
            case INVALID_ARRAY_INDEX: {
                return "\u914d\u5217\u306e\u30a2\u30af\u30bb\u30b9\u53ef\u80fd\u7bc4\u56f2 [ 0 \u304b\u3089 " + stringArray[1] + " \u307e\u3067 ] \u306e\u5916\u3092\u6307\u3059\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 [ " + stringArray[0] + " ] \u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case CASTING_SCALAR_TO_ARRAY: {
                return "\u914d\u5217\u3067\u306f\u306a\u3044\u5024\u3092\u3001\u914d\u5217\u578b\u306b\u30ad\u30e3\u30b9\u30c8\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case CASTING_ARRAY_TO_SCALAR: {
                return "\u914d\u5217\u3092\u3001\u914d\u5217\u3067\u306f\u306a\u3044\u578b\u306b\u30ad\u30e3\u30b9\u30c8\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case CASTING_ARRAY_TO_DIFFERENT_RANK_ARRAY: {
                return "\u914d\u5217\u3092\u3001\u6b21\u5143\u6570\u304c\u7570\u306a\u308b\u914d\u5217\u306b\u30ad\u30e3\u30b9\u30c8\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case WRITING_TO_CONST_VARIABLE: {
                return "\u5909\u6570\u300c " + stringArray[0] + " \u300d\u306f\u5b9a\u6570\uff08const\uff09\u3068\u3057\u3066\u5ba3\u8a00\u3055\u308c\u3066\u308b\u305f\u3081\u3001\u5ba3\u8a00\u5f8c\uff08\u95a2\u6570\u306e\u5f15\u6570\u306e\u5834\u5408\u306f\u53d7\u3051\u6e21\u3057\u5f8c\uff09\u306f\u5024\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case WRITING_TO_LITERAL: {
                return "\u66f8\u304d\u63db\u3048\u4e0d\u53ef\u80fd\u306a\u5024" + (stringArray[0] == null ? "" : "\u300c " + stringArray[0] + " \u300d") + "\u306e\u66f8\u304d\u63db\u3048\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case WRITING_TO_NON_LVALUE: {
                return "\u5024\u306e\u5909\u66f4\u51e6\u7406\u306e\u5bfe\u8c61\uff08\u4ee3\u5165\u300c = \u300d\u306e\u5de6\u8fba\u306a\u3069\uff09\u3068\u3057\u3066\u3001\u4f7f\u7528\u3067\u304d\u306a\u3044\u5185\u5bb9\u304c\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5024\u306e\u5909\u66f4\u51e6\u7406\u306e\u5bfe\u8c61\u306b\u306a\u308c\u308b\u306e\u306f\u3001\u300c \u5909\u6570\u3001\u914d\u5217\u3001\u914d\u5217\u306e\u8981\u7d20 \u300d\u306e\u307f\u3067\u3059\u3002";
            }
            case SUBSCRIPTING_TO_UNSUBSCRIPTABLE_SOMETHING: {
                return "\u914d\u5217\u3067\u306f\u306a\u3044\u5024\u3084\u5909\u6570" + (stringArray == null ? "" : "\u300c " + stringArray[0] + " \u300d") + "\u306b\u3001\u914d\u5217\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3092\u4ed8\u3051\u3066\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case INVALID_SUBSCRIPT_RANK: {
                return stringArray[1] + "\u6b21\u5143\u306e\u914d\u5217\u300c " + stringArray[0] + " \u300d\u306b\u3001" + stringArray[2] + "\u6b21\u5143\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u307e\u3059\u3002";
            }
            case INVALID_ARBITRARY_RANK_SYNTAX: {
                return "\u4efb\u610f\u6b21\u5143\u3092\u8868\u3059\u8868\u8a18\u306f [...] \u3067\u3059\u304c\u3001\u8aa4\u3063\u305f\u8868\u8a18 " + stringArray[0] + " \u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case FUNCTION_ENDED_WITHOUT_RETURNING_VALUE: {
                return "\u95a2\u6570\u300c " + stringArray[0] + " \u300d\u306f\u623b\u308a\u5024\u3092\u8fd4\u3059\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u304c\u3001\u8fd4\u3055\u305a\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002";
            }
            case RETURN_STATEMENT_IS_OUTSIDE_FUNCTIONS: {
                return "return \u6587\u304c\u95a2\u6570\u5916\u3067\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u95a2\u6570\u5185\u3067\u3057\u304b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case INVALID_RETURNED_VALUE_DATA_TYPE: {
                return "return \u6587\u304c\u8fd4\u3057\u3066\u3044\u308b\u5024\u306e\u578b\u300c " + stringArray[0] + " \u300d\u304c\u3001\u95a2\u6570\u5ba3\u8a00\u306b\u304a\u3051\u308b\u623b\u308a\u5024\u306e\u578b\u300c " + stringArray[1] + " \u300d\u3068\u7570\u306a\u308a\u307e\u3059\u3002";
            }
            case RETURNED_VALUE_IS_MISSING: {
                return "\u623b\u308a\u5024\u3092\u8fd4\u3059\u3079\u304d\u95a2\u6570\u5185\u3067, \u4f55\u3082\u5024\u3092\u8fd4\u3055\u306a\u3044 return \u6587\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case NON_VARIABLE_IS_PASSED_BY_REFERENCE: {
                return "\u95a2\u6570\u300c " + stringArray[2] + " \u300d\u306e " + stringArray[0] + " \u756a\u76ee\u306e\u5f15\u6570\u300c " + stringArray[1] + " \u300d\u306f\u3001const\u3067\u306a\u3044\u53c2\u7167\u6e21\u3057\u5f15\u6570\u3067\u3042\u308b\u305f\u3081\u3001\u300c \u5909\u6570 / \u914d\u5217 / \u914d\u5217\u306e\u8981\u7d20 \u300d\u4ee5\u5916\u3092\u6e21\u3059\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case VOID_RETURN_VALUE_PASSED_AS_ARGUMENT: {
                return "void \u578b\u306e" + (stringArray[0] == null ? "" : "\u95a2\u6570\u300c " + stringArray[0] + " \u300d\u306e\u623b\u308a") + "\u5024\u3092\u3001\u95a2\u6570\u306e\u5f15\u6570\u306b\u6e21\u3059\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case DUPLICATE_VARIABLE_IDENTIFIER: {
                return "\u5909\u6570\u306e\u540d\u524d\u300c " + stringArray[0] + " \u300d\u306f\u3001\u540c\u3058\u5f71\u97ff\u7bc4\u56f2\u5185\u306e\u5225\u306e\u5909\u6570\u3067\u3001\u65e2\u306b\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case DUPLICATE_FUNCTION_SIGNATURE: {
                return "\u95a2\u6570\u300c " + stringArray[0] + " \u300d\u306f\u3001\u5168\u304f\u540c\u3058\u540d\u524d\u3068\u5f15\u6570\u306e\u7d44\u307f\u5408\u308f\u305b\u3067\u3001\u4ed6\u306e\u5834\u6240\u3067\u65e2\u306b\u5ba3\u8a00\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case META_QUALIFIED_FILE_DOES_NOT_EXIST: {
                return "\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            }
            case META_QUALIFIED_FILE_IS_NOT_ACCESSIBLE: {
                return "\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u60f3\u5b9a\u3068\u7570\u306a\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5909\u66f4\u3059\u308b\u304b\u3001\u5148\u982d\u884c\u3067\u6587\u5b57\u30b3\u30fc\u30c9\u5ba3\u8a00\uff08 coding \u6587\u5b57\u30b3\u30fc\u30c9\u540d; \uff09\u3092\u8a18\u8ff0\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case SCRIPT_FILE_DOES_NOT_EXIST: {
                return "\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            }
            case SCRIPT_FILE_IS_NOT_ACCESSIBLE: {
                return "\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u60f3\u5b9a\u3068\u7570\u306a\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5909\u66f4\u3059\u308b\u304b\u3001\u5148\u982d\u884c\u3067\u6587\u5b57\u30b3\u30fc\u30c9\u5ba3\u8a00\uff08 coding \u6587\u5b57\u30b3\u30fc\u30c9\u540d; \uff09\u3092\u8a18\u8ff0\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case LIBRARY_LIST_FILE_DOES_NOT_EXIST: {
                return "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u8aad\u307f\u8fbc\u307f\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            }
            case LIBRARY_LIST_FILE_IS_NOT_ACCESSIBLE: {
                return "\u30e9\u30a4\u30d6\u30e9\u30ea\u306e\u8aad\u307f\u8fbc\u307f\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u60f3\u5b9a\u3068\u7570\u306a\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5909\u66f4\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case LIBRARY_IS_ALREADY_INCLUDED: {
                return "\u30e9\u30a4\u30d6\u30e9\u30ea\u300c " + stringArray[0] + " \u300d\u306f\u65e2\u306b\u8aad\u307f\u8fbc\u307f\u767b\u9332\uff08 include \u767b\u9332\uff09\u3055\u308c\u3066\u3044\u307e\u3059 \uff08\u591a\u91cd include \u306f\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\uff09\u3002";
            }
            case LIBRARY_SCRIPT_NAME_IS_CONFLICTING_WITH_MAIN_SCRIPT_NAME: {
                return "\u30e9\u30a4\u30d6\u30e9\u30ea\u300c " + stringArray[0] + " \u300d\u306e\u540d\u524d\u306f\u3001\u5b9f\u884c\u5bfe\u8c61\u306e\u30e1\u30a4\u30f3\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u540d\u524d\u3068\u91cd\u8907\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case PLUGIN_LIST_FILE_DOES_NOT_EXIST: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8aad\u307f\u8fbc\u307f\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            }
            case PLUGIN_LIST_FILE_IS_NOT_ACCESSIBLE: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8aad\u307f\u8fbc\u307f\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u60f3\u5b9a\u3068\u7570\u306a\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5909\u66f4\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case PLUGIN_DIRECTORY_IS_NOT_ACCESSIBLE: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30d5\u30a9\u30eb\u30c0\u300c " + stringArray[0] + " \u300d\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a9\u30eb\u30c0\u306e\u6307\u5b9a\u5185\u5bb9\u3084\u5b58\u5728\u3092\u78ba\u8a8d\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case PLUGIN_FILE_DOES_NOT_EXIST: {
                return "\u8aad\u307f\u8fbc\u307f\u5bfe\u8c61\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            }
            case PLUGIN_INSTANTIATION_FAILED: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u8aad\u307f\u8fbc\u307f/\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            }
            case PLUGIN_CONNECTION_FAILED: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            }
            case PLUGIN_VALIDATION_FAILED: {
                return "\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[0] + " \u300d\u306b\u3001\u5b9f\u88c5\u4e0a\u306e\u554f\u984c\u304c\u3042\u308a\u307e\u3059\uff1a" + stringArray[1];
            }
            case DECLARED_ENCODING_IS_UNSUPPORTED: {
                return "\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[1] + " \u300d\u306e\u5148\u982d\u884c\u3067\u5ba3\u8a00\u3055\u308c\u3066\u3044\u308b\u6587\u5b57\u30b3\u30fc\u30c9\u300c " + stringArray[0] + " \u300d\u306f\u3001\u3053\u306e\u74b0\u5883\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            }
            case NO_ENCODING_DECLARATION_END: {
                return (stringArray[0] == null ? "" : "\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[0] + " \u300d\u306e") + "\u5148\u982d\u884c\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u5ba3\u8a00\u306b\u304a\u3044\u3066\u3001\u672b\u5c3e\u306b\u300c ; \u300d\u304c\u5fc5\u8981\u3067\u3059\u3002";
            }
            case ENCODING_DECLARATION_CONTAINS_INVALID_SYMBOL: {
                return (stringArray[1] == null ? "" : "\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u300c " + stringArray[1] + " \u300d\u306e\u5148\u982d\u884c\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u5ba3\u8a00\u306b\u304a\u3044\u3066\u3001") + "\u4f7f\u7528\u3067\u304d\u306a\u3044\u8a18\u53f7\u300c " + stringArray[0] + " \u300d\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case EXTERNAL_FUNCTION_PLUGIN_CRASHED: {
                return "\u5916\u90e8\u95a2\u6570\u300c " + stringArray[0] + " \u300d\u306e\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + (stringArray[1] == null ? "\u3002" : "\uff1a " + stringArray[1]);
            }
            case EXTERNAL_VARIABLE_PLUGIN_CRASHED: {
                return "\u5916\u90e8\u5909\u6570\u300c " + stringArray[0] + " \u300d\u3078\u306e\u30a2\u30af\u30bb\u30b9\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f" + (stringArray[1] == null ? "\u3002" : "\uff1a " + stringArray[1]);
            }
            case PERMISSION_AUTHORIZER_PLUGIN_CRASHED: {
                return "\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8a8d\u53ef\u30d7\u30e9\u30b0\u30a4\u30f3\u300c " + stringArray[0] + " \u300d\u306e\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff1a " + stringArray[1];
            }
            case NO_PERMISSION_AUTHORIZER_IS_CONNECTED: {
                return "\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u304c\u8981\u6c42/\u5909\u66f4/\u53c2\u7167\u3055\u308c\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u304c\u3001\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u306e\u8a8d\u53ef\u3092\u62c5\u3046\u30d7\u30e9\u30b0\u30a4\u30f3\uff08permission authorizer\uff09\u304c\u63a5\u7d9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u51e6\u7406\u3092\u884c\u3048\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            }
            case MULTIPLE_PERMISSION_AUTHORIZERS_ARE_CONNECTED: {
                return "\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u8a8d\u53ef\u30d7\u30e9\u30b0\u30a4\u30f3\uff08permission authorizer\uff09\u306f1\u500b\u3057\u304b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u304c\u3001\u65e2\u306b\u300c " + stringArray[1] + " \u300d\u63a5\u7d9a\u3055\u308c\u3066\u3044\u308b\u72b6\u614b\u3067\u3001\u8ffd\u52a0\u3067\u300c " + stringArray[0] + " \u300d\u306e\u63a5\u7d9a\u304c\u8981\u6c42\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case NON_EXPRESSION_STATEMENTS_ARE_RESTRICTED: {
                return "\u73fe\u5728\u306e\u8a2d\u5b9a\u3067\u306f\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u3092\u9664\u304d\u3001\u5f0f\u306e\u8a08\u7b97\u4ee5\u5916\u3092\u884c\u3048\u306a\u3044\u3088\u3046\u5236\u9650\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case NON_FLOAT_DATA_TYPES_ARE_RESTRICTED: {
                return "\u73fe\u5728\u306e\u8a2d\u5b9a\u3067\u306f\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u30b9\u30af\u30ea\u30d7\u30c8\u5185\u3092\u9664\u304d\u3001float \u578b\u4ee5\u5916\u306e\u5024 / \u5909\u6570 / \u95a2\u6570\uff08\u623b\u308a\u5024\uff09\u3092\u4f7f\u7528\u3067\u304d\u306a\u3044\u3088\u3046\u5236\u9650\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case TERMINATOR_IS_DISABLED: {
                return "\u5b9f\u884c\u4e2d\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u7d42\u4e86\u304c\u30ea\u30af\u30a8\u30b9\u30c8\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u300c TERMINATOR_ENABLED \u300d\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u7121\u52b9\u5316(false\u6307\u5b9a)\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u7d42\u4e86\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            }
            case PERFORMANCE_MONITOR_IS_DISABLED: {
                return "\u30a8\u30f3\u30b8\u30f3\u95a2\u9023\u306e\u8a08\u6e2c\u30c7\u30fc\u30bf\u304c\u30ea\u30af\u30a8\u30b9\u30c8\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u300c PERFORMANCE_MONITOR_ENABLED \u300d\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u7121\u52b9\u5316(false\u6307\u5b9a)\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            }
            case CAN_NOT_GET_OPTION_MAP: {
                return "\u53d6\u5f97\u53ef\u80fd\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u30de\u30c3\u30d7\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
            }
            case CAN_NOT_GET_PERMISSION_MAP: {
                return "\u53d6\u5f97\u53ef\u80fd\u306a\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u30de\u30c3\u30d7\u304c\u7121\u3044\u304b\u3001\u8a2d\u5b9a\u306b\u3088\u308a\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case INVALID_DEPENDENCY_DECLARATION_SYNTAX: {
                return "import/include\u5ba3\u8a00\u304c\u3001\u60f3\u5b9a\u5916\u306e\u5f62\u3067\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
            case INVALID_DEPENDENCY_DECLARATION_LOCATION: {
                return "import/include\u5ba3\u8a00\u304c\u3001\u60f3\u5b9a\u5916\u306e\u5834\u6240\u306b\u3042\u308a\u307e\u3059\u3002\u6b63\u3057\u304f\u306f\u3001\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5148\u982d\u4ed8\u8fd1\uff08\u30d8\u30c3\u30c0\u9818\u57df\uff09\u306b\u66f8\u304f\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
            }
            case DECLARED_DEPENDENCY_IS_NOT_AVAILABLE: {
                return "\u3053\u306e\u30b9\u30af\u30ea\u30d7\u30c8\u306f\u300c " + stringArray[0] + " \u300d\u306e\u6a5f\u80fd\u7fa4\u3092\u4f7f\u7528\u3057\u307e\u3059\u304c\u3001\u305d\u308c\u3092\u63d0\u4f9b\u3059\u308b\u30e9\u30a4\u30d6\u30e9\u30ea/\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30e9\u30a4\u30d6\u30e9\u30ea/\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8aad\u307f\u8fbc\u307f\u8a2d\u5b9a\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            case INVALID_REEXECUTION_REQUEST: {
                return "\u307e\u3060\u4e00\u5ea6\u3082\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u3066\u3044\u306a\u3044\u72b6\u614b\u3067\u3001reexecuteLastAssemblyCode \u30e1\u30bd\u30c3\u30c9\u306b\u3088\u308b\u518d\u5b9f\u884c\u304c\u8981\u6c42\u3055\u308c\u307e\u3057\u305f\u3002";
            }
            case UNEXPECTED_ACCELERATOR_CRASH: {
                return "\u4e88\u671f\u3057\u306a\u3044VM\u30a8\u30e9\u30fc (\u547d\u4ee4\u30a2\u30c9\u30ec\u30b9: " + stringArray[0] + ", \u518d\u914d\u7f6e\u5f8c\u547d\u4ee4\u30a2\u30c9\u30ec\u30b9: " + stringArray[1] + ")";
            }
            case UNEXPECTED_PROCESSOR_CRASH: {
                return "\u4e88\u671f\u3057\u306a\u3044VM\u30a8\u30e9\u30fc\uff08\u547d\u4ee4\u30a2\u30c9\u30ec\u30b9: " + stringArray[0] + ")";
            }
            case UNEXPECTED: {
                return "\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc";
            }
            case UNMODIFIED: {
                return stringArray[0];
            }
            case UNKNOWN: {
                return "\u4e0d\u660e\u306a\u30a8\u30e9\u30fc";
            }
        }
        return "\u4e0d\u660e\u306a\u30a8\u30e9\u30fc\u7a2e\u985e\uff1a" + (Object)((Object)errorType);
    }

    public static String generateErrorMessageEnUS(ErrorType errorType, String[] stringArray) {
        switch (errorType) {
            case VARIABLE_IS_NOT_FOUND: {
                return "Undeclared variable \"" + stringArray[0] + "\" is used";
            }
            case FUNCTION_IS_NOT_FOUND: {
                return "The function \"" + stringArray[0] + "\" does not exist, or has different parameter(s)" + (2 <= stringArray.length ? "; Is it miscall of " + ErrorMessage.concatinateWords(stringArray, " or ", true, 1, stringArray.length - 1) + " ?" : "");
            }
            case STATEMENT_END_IS_NOT_FOUND: {
                return "End-point of the statement is not found (\";\" is required)";
            }
            case INVALID_EXPRESSION_SYNTAX: {
                return "An expression could not be parsed correctly. Somethings are missing, or correspondence between \"(\" and \")\" or \"[\" and \"]\" might be incorrect";
            }
            case OPENING_PARENTHESES_IS_DEFICIENT: {
                return "Opening parenthesis \"(\" is deficient";
            }
            case CLOSING_PARENTHESES_IS_DEFICIENT: {
                return "Closing parenthesis \")\" is deficient";
            }
            case OPENING_SUBSCRIPT_OPERATOR_IS_DEFICIENT: {
                return "Beginning of array indices \"[\" is deficient";
            }
            case CLOSING_SUBSCRIPT_OPERATOR_IS_DEFICIENT: {
                return "Ending of array indices \"[\" is deficient";
            }
            case INT_LITERAL_STARTS_WITH_ZERO: {
                return "Integer literals starting with \"0\" are unsupported, because they might be confusing to distinguish whether they are decimal or octal on code. If you want to use octal literal, use \"0o\" prefix instead of \"0\"";
            }
            case STRING_LITERAL_IS_NOT_CLOSED: {
                return "Unclosed string literal \"...\" exists in code";
            }
            case INVALID_DATA_TYPES_FOR_UNARY_OPERATOR: {
                return "Prefix/postfix operator \"" + stringArray[0] + "\" is not available for " + stringArray[1] + "-type operands";
            }
            case INVALID_DATA_TYPES_FOR_BINARY_OPERATOR: {
                return "Binary operator \"" + stringArray[0] + "\" is not available for the combination of " + stringArray[0] + "-type and " + stringArray[1] + "-type data";
            }
            case INVALID_RANKS_FOR_VECTOR_OPERATION: {
                return "Operation \"" + stringArray[0] + "\" between arrays is not available, when ranks (number of dimensions) of arrays are different";
            }
            case INVALID_COMPOUND_ASSIGNMENT_BETWEEN_SCALAR_AND_ARRAY: {
                return "Compound assignment operator \"" + stringArray[0] + "\" is not available, when left-hand side is a scalar and right-hand side is an array";
            }
            case INVALID_TYPE_TOKEN_IN_EXPRESSION: {
                return "Token \"" + stringArray[0] + "\" is not available in expressions";
            }
            case INVALID_IDENTIFIER_TYPE: {
                return "A variable is declared with the name \"" + stringArray[0] + "\", but this word has the other special role, so it can not be a variable name";
            }
            case INVALID_IDENTIFIER_SYNTAX: {
                return "A variable is declared with the invalid name \"" + stringArray[0] + "\", because it starts with numbers, or contains symbols, or conflicts with other rules";
            }
            case IDENTIFIER_IS_RESERVED_WORD: {
                return "A variable is declared with the invalid name \"" + stringArray[0] + "\", because it is a reserved word";
            }
            case NO_IDENTIFIER_IN_VARIABLE_DECLARATION: {
                return "Variable name is required after the data type name, in variable declarations";
            }
            case NO_DATA_TYPE_IN_VARIABLE_DECLARATION: {
                return "Data type name is required in variable declarations";
            }
            case PREFIX_MODIFIER_AFTER_TYPE_NAME: {
                return "\"" + stringArray[0] + "\" should be before the type name, not after";
            }
            case POSTFIX_MODIFIER_BEFORE_TYPE_NAME: {
                return "\"" + stringArray[0] + "\" should be after the type name, not before";
            }
            case TOO_MANY_TOKENS_FOR_VARIABLE_DECLARATION: {
                return "Unexpected description exists, in the latter part of the variable declaration statement";
            }
            case NO_PARTIAL_EXPRESSION: {
                return "Empty parentheses ( ) exist in the expression";
            }
            case OPERAND_IS_MISSING_AT_RIGHT: {
                return "A value or variable is necessary at the right of \"" + stringArray[0] + "\"";
            }
            case OPERAND_IS_MISSING_AT_LEFT: {
                return "A value or variable is necessary at the left of \"" + stringArray[0] + "\"";
            }
            case OPERATOR_IS_MISSING_AT_RIGHT: {
                return "An operator (e.g. \"+\") or an end-of-statement \";\" is required between \"" + stringArray[0] + "\" and \"" + stringArray[1] + "\"";
            }
            case OPERATOR_IS_MISSING_AT_LEFT: {
                return "An operator (e.g. \"+\") or an end-of-statement \";\" is required between \"" + stringArray[0] + "\" and \"" + stringArray[1] + "\"";
            }
            case DATA_TYPE_IS_MISSING_AT_RIGHT: {
                return "A data type is necessary at the right of \"" + stringArray[0] + "\"";
            }
            case CLOSE_PARENTHESIS_IS_MISSING_AT_RIGHT: {
                return "A close parenthesis \")\" is necessary at the right of \"" + stringArray[0] + "\"";
            }
            case NO_OPEN_PARENTHESIS_OF_CONTROL_STATEMENT: {
                return "Parentheses (...) are required after \"" + stringArray[0] + "\"";
            }
            case NO_CLOSING_PARENTHESIS_OF_CONTROL_STATEMENT: {
                return "Parentheses (...) of \"" + stringArray[0] + "\" statement are not closing";
            }
            case NO_CONDITION_EXPRESSION_OF_IF_STATEMENT: {
                return "A condition expression is required between parentheses (...) of the \"if\" statement";
            }
            case NO_CONDITION_EXPRESSION_OF_WHILE_STATEMENT: {
                return "A condition expression is required between parentheses (...) of the \"while\" statement";
            }
            case ELEMENTS_OF_FOR_STATEMENT_IS_DEFICIENT: {
                return "Elements such as \"( initialization ; loop_condition ; updating_per_loops )\" are required, between parentheses (...) of the \"for\" statement";
            }
            case TOO_MANY_TOKENS_FOR_CONTROL_STATEMENT: {
                return "Unexpected description exists at the tail of the \"" + stringArray[0] + "\" statement";
            }
            case NO_BLOCK_AFTER_CONTROL_STATEMENT: {
                return "A block {...} is always necessary for the " + stringArray[0] + "statement in this language";
            }
            case UNKNOWN_DATA_TYPE: {
                return "Unknown data type \"" + stringArray[0] + "\" is used";
            }
            case INVALID_IMMEDIATE_VALUE: {
                return "Invalid immediate value or literal \"" + stringArray[0] + "\" is described";
            }
            case UNCONVERTIBLE_DATA_TYPE: {
                return "External data type \"" + stringArray[0] + "\" is not convertible to supported data types in this script engine";
            }
            case UNCONVERTIBLE_ARRAY: {
                return "External array type \"" + stringArray[0] + "\" is not convertible to supported array in this script engine, due to the number of dimensions or the type-convertibility";
            }
            case UNCONVERTIBLE_INTERNAL_ARRAY: {
                return "Internal array type \"" + stringArray[0] + "\" is not convertible to external array types, due to the number of dimensions or the type-convertibility";
            }
            case INCOMPATIBLE_DATA_ACCESSOR_INTERFACE: {
                return "The data accessor interface \"" + stringArray[0] + "\" used in the plug-in \"" + stringArray[1] + "\" is not available on this script engine";
            }
            case JAGGED_ARRAY: {
                return "Jagged array is not available for this script engine, where \"jagged array\" is the array having arrays as elements, and their lengths are not same";
            }
            case ARRAY_SIZE_IS_TOO_LARGE_TO_BE_ASSIGNED_TO_SCALAR_VARIABLE: {
                return "Array data can not be assigned to a scalar variable, except when the size of array is 1.";
            }
            case CAST_FAILED_DUE_TO_VALUE: {
                return "Cast operation of the data \"" + stringArray[0] + "\" to \"" + stringArray[1] + "\" type has failed";
            }
            case CAST_FAILED_DUE_TO_TYPE: {
                return "Cast operation from \"" + stringArray[0] + "\" type to \"" + stringArray[1] + "\" type has failed";
            }
            case FUNCTION_IS_DECLARED_IN_INVALID_PLASE: {
                return "A function is declared in the invalid place";
            }
            case INVALID_ARGUMENT_DECLARATION: {
                return "Invalid argument declaration is detected";
            }
            case RECURSIVE_FUNCTION_CALL: {
                return "A recursive call of the function (this script engine is not support it) is detected";
            }
            case INVALID_EXTERNAL_FUNCTION_SIGNATURE: {
                return "A signature \"" + stringArray[0] + "\" of the connected external function is invalid. A valid example is \"" + stringArray[1] + "\", and you can change the function name only";
            }
            case UNSUPPORTED_PLUGIN: {
                return "For this script engine, the class \"" + stringArray[0] + "\" is not supported as a plug-in";
            }
            case PLUGIN_INITIALIZATION_FAILED: {
                return "Plug-in \"" + stringArray[0] + "\" could not be initialized";
            }
            case PLUGIN_FINALIZATION_FAILED: {
                return "Plug-in \"" + stringArray[0] + "\" could not be finalized";
            }
            case OPTION_KEY_IS_NOT_FOUND: {
                return "The value of \"" + stringArray[0] + "\" option is not found";
            }
            case OPTION_KEY_HAD_CHANGED: {
                return "The name (key) of the option \"" + stringArray[0] + "\" had been changed to \"" + stringArray[1] + "\"";
            }
            case INVALID_OPTION_VALUE_TYPE: {
                return "The type of the value of \"" + stringArray[0] + "\" option should be \"" + stringArray[1];
            }
            case INVALID_OPTION_VALUE_CONTENT: {
                return "The value of \"" + stringArray[0] + "\" option \"" + stringArray[1] + "\" is invalid";
            }
            case DATA_CONVERSION_OF_FUNCTION_PLUGIN_USING_OBJECT_TYPE_SHOULD_BE_DISABLED: {
                return "The data-conversion of the plugin of the external function\"" + stringArray[0] + "\" should be disabled, because this function has Object-type parameters or the return value";
            }
            case INVALID_ARRAY_INDEX: {
                return "The array element with the index [ " + stringArray[0] + " ] is accessed, but it is out of the available range [ from 0 to " + stringArray[1] + " ]";
            }
            case CASTING_SCALAR_TO_ARRAY: {
                return "Casting a scalar to an array";
            }
            case CASTING_ARRAY_TO_SCALAR: {
                return "Casting an array to a scalar";
            }
            case CASTING_ARRAY_TO_DIFFERENT_RANK_ARRAY: {
                return "Casting an array to another array having the different rank (the number of dimensions)";
            }
            case WRITING_TO_CONST_VARIABLE: {
                return "The variable \"" + stringArray[0] + "\" is declared as \"const\", so its value can not be changed after it is declared (or after it is passed, if it is a parameter of a function)";
            }
            case WRITING_TO_LITERAL: {
                return "Modification of the unwritable value " + (stringArray[0] == null ? "" : "\"" + stringArray[0] + "\" ") + "is detected";
            }
            case WRITING_TO_NON_LVALUE: {
                return "Invalid assignment (or value-modifying) operation is detected. Only values of variables/arrays, or an element of an array can be a left-hand side of assignment operation \"=\", or a target of an operation modifying values";
            }
            case SUBSCRIPTING_TO_UNSUBSCRIPTABLE_SOMETHING: {
                return "Subscripting to the non-array value/variable" + (stringArray == null ? "" : "\"" + stringArray[0] + "\"");
            }
            case INVALID_SUBSCRIPT_RANK: {
                return "Subscripting to " + stringArray[1] + "-dimension array \"" + stringArray[0] + "\" by " + stringArray[2] + "-dimension index/indices";
            }
            case INVALID_ARBITRARY_RANK_SYNTAX: {
                return "The valid syntax of \"arbitrary rank\" is \"[...]\", but incorrect description \"" + stringArray[0] + "\" is detected";
            }
            case FUNCTION_ENDED_WITHOUT_RETURNING_VALUE: {
                return "The function \"" + stringArray[0] + "\" should return a value but has end without returning a value";
            }
            case RETURN_STATEMENT_IS_OUTSIDE_FUNCTIONS: {
                return "A return statement being outside functions is detected";
            }
            case INVALID_RETURNED_VALUE_DATA_TYPE: {
                return "The data type of the returned value \"" + stringArray[0] + "\" does not match the data type \"" + stringArray[1] + "\", which is expected from the function declaration";
            }
            case RETURNED_VALUE_IS_MISSING: {
                return "There is a return statement returning no value in the function which should return a value";
            }
            case NON_VARIABLE_IS_PASSED_BY_REFERENCE: {
                return "Only variable or array (containing element) can be passed to the " + stringArray[0] + "-th argument \"" + stringArray[1] + "\" of function \"" + stringArray[2] + "\", because it will be passed by nonconstant reference";
            }
            case VOID_RETURN_VALUE_PASSED_AS_ARGUMENT: {
                return (stringArray[0] == null ? "A void-type value " : "A return value of a void-type function \"" + stringArray[0] + "\" ") + "can not be passed as an argument of a function";
            }
            case DUPLICATE_VARIABLE_IDENTIFIER: {
                return "The name of variable \"" + stringArray[0] + "\" is already used by another variable, and scopes of them are conflicting";
            }
            case DUPLICATE_FUNCTION_SIGNATURE: {
                return "The function \"" + stringArray[0] + "\" is already declared with the same name and same parameters at other lines";
            }
            case META_QUALIFIED_FILE_DOES_NOT_EXIST: {
                return "The loading file \"" + stringArray[0] + "\" does not exist";
            }
            case META_QUALIFIED_FILE_IS_NOT_ACCESSIBLE: {
                return "The loading file \"" + stringArray[0] + "\" could not be loaded. The encoding might be incorrect. Try again with changing the encoding, or describe the encoding declaration \"coding encodingName;\" at the top line of the file";
            }
            case SCRIPT_FILE_DOES_NOT_EXIST: {
                return "The loading script file \"" + stringArray[0] + "\" does not exist";
            }
            case SCRIPT_FILE_IS_NOT_ACCESSIBLE: {
                return "The loading script file \"" + stringArray[0] + "\" could not be loaded. The encoding might be incorrect. Try again with changing the encoding, or describe the encoding declaration \"coding encodingName;\" at the top line of the script file";
            }
            case LIBRARY_LIST_FILE_DOES_NOT_EXIST: {
                return "The loading list file of libraries \"" + stringArray[0] + "\" does not exist";
            }
            case LIBRARY_LIST_FILE_IS_NOT_ACCESSIBLE: {
                return "The loading list file of libraries \"" + stringArray[0] + "\" could not be loaded. The encoding might be incorrect. Try again with changing the encoding";
            }
            case LIBRARY_IS_ALREADY_INCLUDED: {
                return "The library script \"" + stringArray[0] + "\" is already registered to be loaded (\"include\"-ed). This script engine disallows duplicate \"include\"";
            }
            case LIBRARY_SCRIPT_NAME_IS_CONFLICTING_WITH_MAIN_SCRIPT_NAME: {
                return "The name of the library script \"" + stringArray[0] + "\" is not available, because it is conflicting with the name of the main script";
            }
            case PLUGIN_LIST_FILE_DOES_NOT_EXIST: {
                return "The loading list file of plug-ins \"" + stringArray[0] + "\" does not exist";
            }
            case PLUGIN_LIST_FILE_IS_NOT_ACCESSIBLE: {
                return "The loading list file of plug-ins \"" + stringArray[0] + "\" could not be loaded. The encoding might be incorrect. Try again with changing the encoding";
            }
            case PLUGIN_DIRECTORY_IS_NOT_ACCESSIBLE: {
                return "The plug-in directory \"" + stringArray[0] + "\" is not accessible. Check the content of the directory path, and check the directory exists";
            }
            case PLUGIN_FILE_DOES_NOT_EXIST: {
                return "The loading plug-in file \"" + stringArray[0] + "\" does not exist";
            }
            case PLUGIN_INSTANTIATION_FAILED: {
                return "The loading or instantiation of the plugin \"" + stringArray[0] + "\" has failed";
            }
            case PLUGIN_CONNECTION_FAILED: {
                return "The connection of the plugin \"" + stringArray[0] + "\" has failed";
            }
            case PLUGIN_VALIDATION_FAILED: {
                return "An issue has been detected for the implementation of \"" + stringArray[0] + "\" plug-in: " + stringArray[1];
            }
            case DECLARED_ENCODING_IS_UNSUPPORTED: {
                return "The encoding \"" + stringArray[0] + "\" declared in the first line of \"" + stringArray[1] + "\" is unsupported in this environment";
            }
            case NO_ENCODING_DECLARATION_END: {
                return "\";\" is required at the end of the encoding-decraration" + (stringArray[0] == null ? "" : ", at the first line of \"" + stringArray[0] + "\"");
            }
            case ENCODING_DECLARATION_CONTAINS_INVALID_SYMBOL: {
                return "Invalid symbol \"" + stringArray[0] + "\" is contained in the encoding-declaration" + (stringArray[1] == null ? "" : ", at the first line of \"" + stringArray[1] + "\"");
            }
            case EXTERNAL_FUNCTION_PLUGIN_CRASHED: {
                return "An error occurred on the processing of the external function \"" + stringArray[0] + "\"" + (stringArray[1] == null ? "" : ": " + stringArray[1]);
            }
            case EXTERNAL_VARIABLE_PLUGIN_CRASHED: {
                return "An error occurred on the accessing to the external variable \"" + stringArray[0] + "\"" + (stringArray[1] == null ? "" : ": " + stringArray[1]);
            }
            case PERMISSION_AUTHORIZER_PLUGIN_CRASHED: {
                return "An error occurred on the permission authorizer plug-in \"" + stringArray[0] + "\": " + stringArray[1];
            }
            case NO_PERMISSION_AUTHORIZER_IS_CONNECTED: {
                return "A permission has been requested/modified/referred, but it has failed because no plug-in for managing permissions (permission authorizer) is connected";
            }
            case MULTIPLE_PERMISSION_AUTHORIZERS_ARE_CONNECTED: {
                return "The permission authorizer plug-in \"" + stringArray[0] + "\" is requested to be connected, but the other permission authorizer \"" + stringArray[1] + "\" is already connected (only 1 permission authorizer can be connected)";
            }
            case NON_EXPRESSION_STATEMENTS_ARE_RESTRICTED: {
                return "On the current settings, you can describe only expressions as inputs, except in library scripts";
            }
            case NON_FLOAT_DATA_TYPES_ARE_RESTRICTED: {
                return "On the current settings, you can use only float-type values / variables / functions (returned values), except in library scripts";
            }
            case TERMINATOR_IS_DISABLED: {
                return "The termination of the currently running script has been requested, but it can not be terminated because the option \"TERMINATOR_ENABLED\" is disabled (false)";
            }
            case PERFORMANCE_MONITOR_IS_DISABLED: {
                return "Monitoring data of the engine has been requested, but it is not available because the option \"PERFORMANCE_MONITOR_ENABLED\" is disabled (false)";
            }
            case CAN_NOT_GET_OPTION_MAP: {
                return "There is no option map to return";
            }
            case CAN_NOT_GET_PERMISSION_MAP: {
                return "There is no permission map to return, or denied based on settings";
            }
            case INVALID_DEPENDENCY_DECLARATION_SYNTAX: {
                return "The syntax of the \"import\" / \"include\" declaration statement is incorrect";
            }
            case INVALID_DEPENDENCY_DECLARATION_LOCATION: {
                return "The location of the \"import\" / \"include\" declaration is incorrect. It should be described at the near the top (header section) of the script.";
            }
            case DECLARED_DEPENDENCY_IS_NOT_AVAILABLE: {
                return "This script requires features of \"" + stringArray[0] + "\", but no library or plug-in providing them is not loaded. Check the settings to load libraries/plug-ins.";
            }
            case INVALID_REEXECUTION_REQUEST: {
                return "The re-execution of the last executed code has been requested (by reexecuteLastAssemblyCode method), but this engine has no executed code yet.";
            }
            case UNEXPECTED_ACCELERATOR_CRASH: {
                return "Unexpected VM Error (instruction-addr: " + stringArray[0] + ", reordered-instruction-addr: " + stringArray[1] + ")";
            }
            case UNEXPECTED_PROCESSOR_CRASH: {
                return "Unexpected VM Error (instruction-addr: " + stringArray[0] + ")";
            }
            case UNEXPECTED: {
                return "Unexpected Error";
            }
            case UNMODIFIED: {
                return stringArray[0];
            }
            case UNKNOWN: {
                return "Unknown Error";
            }
        }
        return "Unknown Error Type: " + (Object)((Object)errorType);
    }
}

