/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LiteralSyntaxTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIntLiteralRegex() {
        Assert.assertTrue((boolean)"1".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"123".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"123l".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"123L".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"0b1010".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"0o123".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"0x123".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"0xabc".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"0xABC".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertTrue((boolean)"0123".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)"abc".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)"ABC".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)"0b222".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)"0o888".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)"0xXYZ".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)"".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
        Assert.assertFalse((boolean)" ".matches("^(0x[0-9a-zA-F]+)|(0o[0-7]+)|(0b[0-1]+)|([0-9]+)(l|L)?$"));
    }

    @Test
    public void testFloatLiteralRegex() {
        Assert.assertTrue((boolean)"123f".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"123d".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"123F".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"123D".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"123".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"123l".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"123L".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23f".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23d".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23F".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23D".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"1.23l".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"1.23L".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23e45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23E45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23e+45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23E+45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23e-45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23E-45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"1.23d45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"1.23D45".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.23".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"12.3".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"123.456".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)".1".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"1.".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)".123".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertTrue((boolean)"123.".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"123".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)".".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"a.bc".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"1..23".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"1.2.3".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"+1.23".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"-1.23".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)"".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
        Assert.assertFalse((boolean)" ".matches("^([0-9]+(d|f|D|F))|((([0-9]+\\.[0-9]*)|([0-9]*\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?(d|f|D|F)?)$"));
    }

    @Test
    public void testBoolLiteralRegex() {
        Assert.assertTrue((boolean)"true".matches("^true|false$"));
        Assert.assertTrue((boolean)"false".matches("^true|false$"));
        Assert.assertFalse((boolean)"TRUE".matches("^true|false$"));
        Assert.assertFalse((boolean)"FALSE".matches("^true|false$"));
        Assert.assertFalse((boolean)"abc".matches("^true|false$"));
        Assert.assertFalse((boolean)"123".matches("^true|false$"));
        Assert.assertFalse((boolean)"".matches("^true|false$"));
        Assert.assertFalse((boolean)" ".matches("^true|false$"));
    }
}

