/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public class MetaInformationSyntax {
    public static String generateMetaInformation(int n, String string) {
        return "line=" + n + ", file=" + string;
    }

    public static int extractLineNumber(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            if (!string2.trim().startsWith("line=")) continue;
            return Integer.parseInt(string2.split("=")[1]);
        }
        throw new VnanoFatalException("Invalid meta information: no line number found.");
    }

    public static int extractLineNumber(Instruction instruction, Memory memory) {
        DataContainer<?> dataContainer = memory.getDataContainer(instruction.getMetaPartition(), instruction.getMetaAddress());
        String string = ((String[])dataContainer.getArrayData())[0];
        return MetaInformationSyntax.extractLineNumber(string);
    }

    public static String extractFileName(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            if (!string2.trim().startsWith("file=")) continue;
            return string2.split("=")[1];
        }
        throw new VnanoFatalException("Invalid meta information: no file name found.");
    }

    public static String extractFileName(Instruction instruction, Memory memory) {
        DataContainer<?> dataContainer = memory.getDataContainer(instruction.getMetaPartition(), instruction.getMetaAddress());
        String string = ((String[])dataContainer.getArrayData())[0];
        return MetaInformationSyntax.extractFileName(string);
    }
}

