/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.spec;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.IdentifierSyntax;

public final class OptionValue {
    public static final String DUMPER_TARGET_ALL = "ALL";
    public static final String DUMPER_TARGET_INPUTTED_CODE = "INPUTTED_CODE";
    public static final String DUMPER_TARGET_PREPROCESSED_CODE = "PREPROCESSED_CODE";
    public static final String DUMPER_TARGET_TOKEN = "TOKEN";
    public static final String DUMPER_TARGET_PARSED_AST = "PARSED_AST";
    public static final String DUMPER_TARGET_ANALYZED_AST = "ANALYZED_AST";
    public static final String DUMPER_TARGET_ASSEMBLY_CODE = "ASSEMBLY_CODE";
    public static final String DUMPER_TARGET_OBJECT_CODE = "OBJECT_CODE";
    public static final String DUMPER_TARGET_ACCELERATOR_CODE = "ACCELERATOR_CODE";
    public static final String DUMPER_TARGET_ACCELERATOR_STATE = "ACCELERATOR_STATE";
    public static final String MAIN_SCRIPT_NAME_DEFAULT = "main script";
    private static final String MAIN_DIRECTORY_PATH_DEFAULT = ".";
    public static final int ACCELERATOR_OPTIMIZATION_LEVEL_0 = 0;
    public static final int ACCELERATOR_OPTIMIZATION_LEVEL_1 = 1;
    public static final int ACCELERATOR_OPTIMIZATION_LEVEL_2 = 2;
    public static final int ACCELERATOR_OPTIMIZATION_LEVEL_3 = 3;
    public static final int ACCELERATOR_OPTIMIZATION_LEVEL_MAX = 3;
    public static final int ACCELERATOR_OPTIMIZATION_LEVEL_DEFAULT = 3;
    private static final Map<String, Object> DEFAULT_VALUE_MAP = new LinkedHashMap<String, Object>();

    public static final Map<String, Object> normalizeValuesOf(Map<String, Object> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> object2 : set) {
            linkedHashMap.put(object2.getKey(), object2.getValue());
        }
        Set<Map.Entry<String, Object>> set2 = DEFAULT_VALUE_MAP.entrySet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (linkedHashMap.containsKey(entry.getKey())) continue;
            linkedHashMap.put((String)entry.getKey(), entry.getValue());
        }
        if (linkedHashMap.get("MAIN_SCRIPT_NAME") instanceof String) {
            String string = (String)linkedHashMap.get("MAIN_SCRIPT_NAME");
            linkedHashMap.put("MAIN_SCRIPT_NAME", IdentifierSyntax.normalizeScriptIdentifier(string));
        }
        return linkedHashMap;
    }

    public static final void checkContentsOf(Map<String, Object> map) throws VnanoException {
        OptionValue.checkKeysOf(map);
        OptionValue.checkValuesOf(map);
    }

    public static final void checkKeysOf(Map<String, Object> map) throws VnanoException {
        if (map.containsKey("EVAL_NUMBER_AS_FLOAT")) {
            throw new VnanoException(ErrorType.OPTION_KEY_HAD_CHANGED, new String[]{"EVAL_NUMBER_AS_FLOAT", "EVAL_INT_LITERAL_AS_FLOAT"});
        }
        if (map.containsKey("MAIN_DIRECTORY_PATH")) {
            throw new VnanoException(ErrorType.OPTION_KEY_HAD_CHANGED, new String[]{"MAIN_DIRECTORY_PATH", "MAIN_SCRIPT_DIRECTORY"});
        }
    }

    private static final void checkValuesOf(Map<String, Object> map) throws VnanoException {
        OptionValue.checkValueOf("EVAL_INT_LITERAL_AS_FLOAT", map, Boolean.class);
        OptionValue.checkValueOf("EVAL_ONLY_FLOAT", map, Boolean.class);
        OptionValue.checkValueOf("EVAL_ONLY_EXPRESSION", map, Boolean.class);
        OptionValue.checkValueOf("LOCALE", map, Locale.class);
        OptionValue.checkValueOf("ACCELERATOR_ENABLED", map, Boolean.class);
        OptionValue.checkValueOf("TERMINATOR_ENABLED", map, Boolean.class);
        OptionValue.checkValueOf("PERFORMANCE_MONITOR_ENABLED", map, Boolean.class);
        OptionValue.checkValueOf("DUMPER_ENABLED", map, Boolean.class);
        OptionValue.checkValueOf("DUMPER_TARGET", map, String.class);
        OptionValue.checkValueOf("DUMPER_OUTPUT_STREAM", map, PrintStream.class);
        OptionValue.checkValueOf("RUNNING_ENABLED", map, Boolean.class);
        OptionValue.checkValueOf("MAIN_SCRIPT_NAME", map, String.class);
        OptionValue.checkValueOf("MAIN_SCRIPT_DIRECTORY", map, String.class);
        OptionValue.checkValueOf("FILE_IO_ENCODING", map, String.class);
        OptionValue.checkValueOf("FILE_IO_EOL", map, String.class);
        OptionValue.checkValueOf("UI_MODE", map, String.class);
        OptionValue.checkValueOf("TERMINAL_IO_EOL", map, String.class);
        OptionValue.checkValueOf("ENVIRONMENT_EOL", map, String.class);
        OptionValue.checkValueOf("STDIN_STREAM", map, InputStream.class);
        OptionValue.checkValueOf("STDOUT_STREAM", map, PrintStream.class);
        OptionValue.checkValueOf("STDERR_STREAM", map, PrintStream.class);
    }

    private static final void checkValueOf(String string, Map<String, Object> map, Class<?> clazz) throws VnanoException {
        if (!map.containsKey(string)) {
            throw new VnanoException(ErrorType.OPTION_KEY_IS_NOT_FOUND, string);
        }
        Object object = map.get(string);
        if (!clazz.isInstance(object)) {
            throw new VnanoException(ErrorType.INVALID_OPTION_VALUE_TYPE, new String[]{string, clazz.getCanonicalName()});
        }
    }

    static {
        DEFAULT_VALUE_MAP.put("EVAL_INT_LITERAL_AS_FLOAT", Boolean.FALSE);
        DEFAULT_VALUE_MAP.put("EVAL_ONLY_FLOAT", Boolean.FALSE);
        DEFAULT_VALUE_MAP.put("EVAL_ONLY_EXPRESSION", Boolean.FALSE);
        DEFAULT_VALUE_MAP.put("LOCALE", Locale.getDefault());
        DEFAULT_VALUE_MAP.put("ACCELERATOR_ENABLED", Boolean.TRUE);
        DEFAULT_VALUE_MAP.put("ACCELERATOR_OPTIMIZATION_LEVEL", 3);
        DEFAULT_VALUE_MAP.put("TERMINATOR_ENABLED", Boolean.FALSE);
        DEFAULT_VALUE_MAP.put("PERFORMANCE_MONITOR_ENABLED", Boolean.FALSE);
        DEFAULT_VALUE_MAP.put("DUMPER_ENABLED", Boolean.FALSE);
        DEFAULT_VALUE_MAP.put("DUMPER_TARGET", DUMPER_TARGET_ALL);
        DEFAULT_VALUE_MAP.put("DUMPER_OUTPUT_STREAM", System.out);
        DEFAULT_VALUE_MAP.put("RUNNING_ENABLED", Boolean.TRUE);
        DEFAULT_VALUE_MAP.put("AUTOMATIC_ACTIVATION_ENABLED", Boolean.TRUE);
        DEFAULT_VALUE_MAP.put("MAIN_SCRIPT_NAME", MAIN_SCRIPT_NAME_DEFAULT);
        DEFAULT_VALUE_MAP.put("MAIN_SCRIPT_DIRECTORY", MAIN_DIRECTORY_PATH_DEFAULT);
        DEFAULT_VALUE_MAP.put("FILE_IO_ENCODING", "UTF-8");
        DEFAULT_VALUE_MAP.put("FILE_IO_EOL", System.getProperty("line.separator"));
        DEFAULT_VALUE_MAP.put("UI_MODE", "GUI");
        DEFAULT_VALUE_MAP.put("TERMINAL_IO_EOL", System.getProperty("line.separator"));
        DEFAULT_VALUE_MAP.put("ENVIRONMENT_EOL", System.getProperty("line.separator"));
        DEFAULT_VALUE_MAP.put("STDIN_STREAM", System.in);
        DEFAULT_VALUE_MAP.put("STDOUT_STREAM", System.out);
        DEFAULT_VALUE_MAP.put("STDERR_STREAM", System.err);
    }
}

