/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.io.PrintStream;
import java.util.ArrayList;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.MetaInformationSyntax;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorDataManagementUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorDispatchUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.AcceleratorOptimizationUnit;
import org.vcssl.nano.vm.accelerator.BypassUnit;
import org.vcssl.nano.vm.accelerator.ExternalFunctionControlUnit;
import org.vcssl.nano.vm.accelerator.InternalFunctionControlUnit;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;
import org.vcssl.nano.vm.processor.Processor;

public class Accelerator {
    private ReprocessingCache reprocessingCache = null;
    private volatile boolean continuable = true;
    private int executedInstructionCount = 0;
    private AcceleratorExecutionNode currentExecutedNode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Instruction[] instructionArray, Memory memory, Interconnect interconnect, Processor processor) throws VnanoException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String string;
        boolean bl5;
        Object object;
        PrintStream printStream = null;
        int n = -1;
        Object object2 = this;
        synchronized (object2) {
            object = interconnect.getOptionMap();
            bl5 = (Boolean)object.get("DUMPER_ENABLED");
            string = (String)object.get("DUMPER_TARGET");
            bl4 = string.equals("ALL");
            printStream = (PrintStream)object.get("DUMPER_OUTPUT_STREAM");
            bl3 = (Boolean)object.get("RUNNING_ENABLED");
            bl2 = (Boolean)object.get("TERMINATOR_ENABLED");
            bl = (Boolean)object.get("PERFORMANCE_MONITOR_ENABLED");
            n = (Integer)object.get("ACCELERATOR_OPTIMIZATION_LEVEL");
        }
        object2 = new AcceleratorDataManagementUnit();
        ((AcceleratorDataManagementUnit)object2).allocate(instructionArray, memory, interconnect, n);
        object = new ArrayList();
        for (int i = 0; i < instructionArray.length; ++i) {
            object.add(new AcceleratorInstruction(instructionArray[i], i));
        }
        AcceleratorInstruction[] acceleratorInstructionArray = object.toArray(new AcceleratorInstruction[0]);
        AcceleratorDispatchUnit acceleratorDispatchUnit = new AcceleratorDispatchUnit();
        acceleratorInstructionArray = acceleratorDispatchUnit.preDispatch(acceleratorInstructionArray, memory, (AcceleratorDataManagementUnit)object2);
        AcceleratorOptimizationUnit acceleratorOptimizationUnit = new AcceleratorOptimizationUnit();
        acceleratorInstructionArray = acceleratorOptimizationUnit.optimize(acceleratorInstructionArray, memory, (AcceleratorDataManagementUnit)object2, n);
        acceleratorInstructionArray = acceleratorDispatchUnit.preDispatch(acceleratorInstructionArray, memory, (AcceleratorDataManagementUnit)object2);
        if (bl5 && (bl4 || string.equals("ACCELERATOR_CODE"))) {
            if (bl4) {
                printStream.println("================================================================================");
                printStream.println("= Accelerator Code (Optimized)");
                printStream.println("= - Output of: org.vcssl.nano.vm.accelerator.AcceleratorOptimizationUnit");
                printStream.println("= - Input  of: org.vcssl.nano.vm.accelerator.AcceleratorDispatchUnit");
                printStream.println("================================================================================");
            }
            int n2 = acceleratorInstructionArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = acceleratorInstructionArray[i].getUnreorderedAddress();
                printStream.println("[" + i + "] <- [" + n3 + "]\t" + acceleratorInstructionArray[i]);
            }
            if (bl4) {
                printStream.println("");
            }
        }
        BypassUnit bypassUnit = new BypassUnit(processor, memory, interconnect);
        InternalFunctionControlUnit internalFunctionControlUnit = new InternalFunctionControlUnit();
        ExternalFunctionControlUnit externalFunctionControlUnit = new ExternalFunctionControlUnit(interconnect);
        AcceleratorExecutionNode[] acceleratorExecutionNodeArray = acceleratorDispatchUnit.dispatch(processor, memory, interconnect, acceleratorInstructionArray, (AcceleratorDataManagementUnit)object2, bypassUnit, internalFunctionControlUnit, externalFunctionControlUnit);
        if (bl5 && (bl4 || string.equals("ACCELERATOR_STATE"))) {
            if (bl4) {
                printStream.println("================================================================================");
                printStream.println("= Accelerator State (Execution Unit Dispatchment)");
                printStream.println("= - Output of: org.vcssl.nano.vm.accelerator.AcceleratorDispatchUnit");
                printStream.println("================================================================================");
            }
            for (int i = 0; i < acceleratorExecutionNodeArray.length; ++i) {
                printStream.println("[" + i + "]\t" + acceleratorExecutionNodeArray[i]);
            }
            if (bl4) {
                printStream.println("");
            }
        }
        internalFunctionControlUnit.setNodes(acceleratorExecutionNodeArray);
        ((AcceleratorDataManagementUnit)object2).getCacheSynchronizers(Memory.Partition.CONSTANT).synchronizeFromMemoryToCache();
        ((AcceleratorDataManagementUnit)object2).getCacheSynchronizers(Memory.Partition.GLOBAL).synchronizeFromMemoryToCache();
        if (!bl3) {
            return;
        }
        if (bl5 && bl4) {
            printStream.println("================================================================================");
            printStream.println("= Run");
            printStream.println("================================================================================");
        }
        this.executeNodes(acceleratorExecutionNodeArray, (AcceleratorDataManagementUnit)object2, memory, bl3, bl2, bl);
        if (bl5 && bl4) {
            printStream.println("");
            printStream.println("================================================================================");
            printStream.println("= End");
            printStream.println("================================================================================");
        }
        this.reprocessingCache = new ReprocessingCache();
        this.reprocessingCache.lastExecutionNodes = acceleratorExecutionNodeArray;
        this.reprocessingCache.lastDataManager = object2;
        this.reprocessingCache.lastRunningEnabled = bl3;
        this.reprocessingCache.lastTerminatorEnabled = bl2;
        this.reprocessingCache.lastPerformanceMonitorEnabled = bl;
    }

    public void reprocess(Instruction[] instructionArray, Memory memory, Interconnect interconnect, Processor processor) throws VnanoException {
        AcceleratorExecutionNode[] acceleratorExecutionNodeArray = this.reprocessingCache.lastExecutionNodes;
        AcceleratorDataManagementUnit acceleratorDataManagementUnit = this.reprocessingCache.lastDataManager;
        boolean bl = this.reprocessingCache.lastRunningEnabled;
        boolean bl2 = this.reprocessingCache.lastTerminatorEnabled;
        boolean bl3 = this.reprocessingCache.lastPerformanceMonitorEnabled;
        if (!bl) {
            return;
        }
        acceleratorDataManagementUnit.getCacheSynchronizers(Memory.Partition.CONSTANT).synchronizeFromMemoryToCache();
        acceleratorDataManagementUnit.getCacheSynchronizers(Memory.Partition.GLOBAL).synchronizeFromMemoryToCache();
        this.executeNodes(acceleratorExecutionNodeArray, acceleratorDataManagementUnit, memory, bl, bl2, bl3);
    }

    private void executeNodes(AcceleratorExecutionNode[] acceleratorExecutionNodeArray, AcceleratorDataManagementUnit acceleratorDataManagementUnit, Memory memory, boolean bl, boolean bl2, boolean bl3) throws VnanoException {
        AcceleratorExecutionNode acceleratorExecutionNode;
        this.currentExecutedNode = acceleratorExecutionNode = acceleratorExecutionNodeArray.length == 0 ? null : acceleratorExecutionNodeArray[0];
        try {
            if (bl2 && bl3) {
                while (acceleratorExecutionNode != null && this.continuable) {
                    this.executedInstructionCount += acceleratorExecutionNode.INSTRUCTIONS_PER_NODE;
                    this.currentExecutedNode = acceleratorExecutionNode;
                    acceleratorExecutionNode = acceleratorExecutionNode.execute();
                }
                this.currentExecutedNode = null;
            } else if (bl3) {
                while (acceleratorExecutionNode != null) {
                    this.executedInstructionCount += acceleratorExecutionNode.INSTRUCTIONS_PER_NODE;
                    this.currentExecutedNode = acceleratorExecutionNode;
                    acceleratorExecutionNode = acceleratorExecutionNode.execute();
                }
                this.currentExecutedNode = null;
            } else if (bl2) {
                while (acceleratorExecutionNode != null && this.continuable) {
                    acceleratorExecutionNode = acceleratorExecutionNode.execute();
                }
            } else {
                while (acceleratorExecutionNode != null) {
                    acceleratorExecutionNode = acceleratorExecutionNode.execute();
                }
            }
        }
        catch (Exception exception) {
            Exception exception2;
            AcceleratorInstruction acceleratorInstruction = acceleratorExecutionNode.getSourceInstruction();
            int n = MetaInformationSyntax.extractLineNumber(acceleratorInstruction, memory);
            String string = MetaInformationSyntax.extractFileName(acceleratorInstruction, memory);
            if (exception instanceof RuntimeException && exception.getCause() != null && exception.getCause() instanceof VnanoException) {
                exception2 = (Exception)exception.getCause();
            }
            if (exception2 instanceof VnanoException) {
                VnanoException vnanoException = (VnanoException)exception2;
                vnanoException.setFileName(string);
                vnanoException.setLineNumber(n);
                throw vnanoException;
            }
            int n2 = acceleratorInstruction.getUnreorderedAddress();
            int n3 = acceleratorInstruction.getReorderedAddress();
            String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(n3), acceleratorInstruction.toString()};
            throw new VnanoException(ErrorType.UNEXPECTED_ACCELERATOR_CRASH, stringArray, exception2, string, n);
        }
    }

    public void terminate() {
        this.continuable = false;
    }

    public void resetTerminator() {
        this.continuable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExecutedInstructionCountIntValue() {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            return this.executedInstructionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationCode[] getCurrentlyExecutedOperationCodes() {
        Accelerator accelerator = this;
        synchronized (accelerator) {
            AcceleratorExecutionNode acceleratorExecutionNode = this.currentExecutedNode;
            if (acceleratorExecutionNode == null) {
                return new OperationCode[0];
            }
            AcceleratorInstruction acceleratorInstruction = acceleratorExecutionNode.getSourceInstruction();
            if (acceleratorExecutionNode.INSTRUCTIONS_PER_NODE == 1) {
                return new OperationCode[]{acceleratorInstruction.getOperationCode()};
            }
            int n = acceleratorExecutionNode.INSTRUCTIONS_PER_NODE;
            OperationCode[] operationCodeArray = new OperationCode[n];
            System.arraycopy(acceleratorInstruction.getFusedOperationCodes(), 0, operationCodeArray, 0, n);
            return operationCodeArray;
        }
    }

    private class ReprocessingCache {
        public volatile AcceleratorExecutionNode[] lastExecutionNodes;
        public volatile AcceleratorDataManagementUnit lastDataManager;
        public volatile boolean lastRunningEnabled;
        public volatile boolean lastTerminatorEnabled;
        public volatile boolean lastPerformanceMonitorEnabled;

        private ReprocessingCache() {
        }
    }
}

