/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolVectorTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new BoolVectorMovNode(dataContainerArray[0], dataContainerArray[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.BOOL) {
                    Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                    acceleratorExecutionNode2 = new BoolVectorMovNode(dataContainerArray[0], dataContainerArray[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            case FILL: {
                Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer = new Boolx2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
                acceleratorExecutionNode2 = new BoolVectorFillNode(dataContainerArray[0], dataContainerArray[1], boolx2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private final class BoolVectorMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final Boolx2ScalarCacheSynchronizer synchronizer;

        public BoolVectorMovNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = boolx2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = this.container0.getArrayData();
            boolean[] blArray2 = this.container1.getArrayData();
            int n = this.container0.getArraySize();
            System.arraycopy(blArray2, 0, blArray, 0, n);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class BoolVectorFillNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final Boolx2ScalarCacheSynchronizer synchronizer;

        public BoolVectorFillNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx2ScalarCacheSynchronizer boolx2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = boolx2ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = this.container0.getArrayData();
            boolean bl = this.container1.getArrayData()[this.container1.getArrayOffset()];
            Arrays.fill(blArray, bl);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

