/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.ExternalFunctionConnectorInterface1;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.AbstractFunction;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.interconnect.Xfci1ToFunctionAdapter;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.accelerator.CacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.GeneralScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.accelerator.ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.processor.ExecutionUnit;

public class ExternalFunctionControlUnit
extends AcceleratorExecutionUnit {
    private Interconnect interconnect;

    public ExternalFunctionControlUnit(Interconnect interconnect) {
        this.interconnect = interconnect;
    }

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        if (acceleratorInstruction.getOperationCode() != OperationCode.CALLX) {
            throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
        }
        int n = (int)((long[])dataContainerArray[1].getArrayData())[0];
        AbstractFunction abstractFunction = this.interconnect.getExternalFunctionTable().getFunctionByIndex(n);
        boolean bl = abstractFunction instanceof Xfci1ToFunctionAdapter;
        if (bl) {
            ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1 = ((Xfci1ToFunctionAdapter)abstractFunction).getXfci1Plugin();
            return this.generateXfci1CallxNode(acceleratorInstruction, abstractFunction, externalFunctionConnectorInterface1, dataContainerArray, objectArray, blArray, blArray2, blArray3, acceleratorExecutionNode);
        }
        GeneralScalarCacheSynchronizer generalScalarCacheSynchronizer = new GeneralScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        boolean bl2 = blArray[0] && blArray2[0];
        DataType dataType = acceleratorInstruction.getDataTypes()[0];
        return new GeneralCallxNode(dataContainerArray, generalScalarCacheSynchronizer, dataType, bl2, abstractFunction, acceleratorExecutionNode);
    }

    private AcceleratorExecutionNode generateXfci1CallxNode(AcceleratorInstruction acceleratorInstruction, AbstractFunction abstractFunction, ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        Object[] objectArray2;
        int n;
        boolean bl;
        boolean bl2 = true;
        for (bl = false; bl < dataContainerArray.length; bl += 1) {
            if (blArray[bl] && blArray2[bl]) continue;
            bl2 = false;
            break;
        }
        bl = blArray[0] && blArray2[0];
        DataType dataType = acceleratorInstruction.getDataTypes()[0];
        boolean bl3 = externalFunctionConnectorInterface1.isDataConversionNecessary();
        boolean bl4 = true;
        if (!bl3 && bl2) {
            n = dataContainerArray.length - 2;
            objectArray2 = new Class[n];
            for (int i = 0; i < n; ++i) {
                if (objectArray[i + 2] instanceof Float64ScalarCache) {
                    objectArray2[i] = Double.TYPE;
                    continue;
                }
                if (objectArray[i + 2] instanceof Int64ScalarCache) {
                    objectArray2[i] = Long.TYPE;
                    continue;
                }
                if (objectArray[i + 2] instanceof BoolScalarCache) {
                    objectArray2[i] = Boolean.TYPE;
                    continue;
                }
                throw new VnanoFatalException("Unexpected Cache Object: " + objectArray[i + 2].getClass().getCanonicalName());
            }
            Class<?>[] classArray = externalFunctionConnectorInterface1.getParameterUnconvertedClasses();
            Class<?> clazz = externalFunctionConnectorInterface1.getReturnUnconvertedClass((Class<?>[])objectArray2);
            for (int i = 0; i < n; ++i) {
                if (classArray[i].isAssignableFrom(objectArray[i + 2].getClass())) continue;
                bl4 = false;
                break;
            }
            if (!clazz.isAssignableFrom(objectArray[0].getClass())) {
                bl4 = false;
            }
        } else {
            bl4 = false;
        }
        n = 1;
        objectArray2 = externalFunctionConnectorInterface1.getParameterReferencenesses();
        for (int i = 0; i < objectArray2.length; ++i) {
            n &= objectArray2[i];
        }
        if (!bl3 && bl2 && bl4) {
            if (n != 0) {
                return new CachedScalarReferenceXfci1CallxNode(objectArray, dataContainerArray[0], dataType, bl, externalFunctionConnectorInterface1, acceleratorExecutionNode);
            }
            return new CachedScalarXfci1CallxNode(objectArray, dataContainerArray[0], dataType, bl, externalFunctionConnectorInterface1, acceleratorExecutionNode);
        }
        GeneralScalarCacheSynchronizer generalScalarCacheSynchronizer = new GeneralScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        return new GeneralCallxNode(dataContainerArray, generalScalarCacheSynchronizer, dataType, bl, abstractFunction, acceleratorExecutionNode);
    }

    private final class GeneralCallxNode
    extends AcceleratorExecutionNode {
        private final DataContainer<?>[] argumentContainers;
        private final DataContainer<?> returnContainer;
        private final CacheSynchronizer synchronizer;
        private AbstractFunction function;

        public GeneralCallxNode(DataContainer<?>[] dataContainerArray, CacheSynchronizer cacheSynchronizer, DataType dataType, boolean bl, AbstractFunction abstractFunction, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.synchronizer = cacheSynchronizer;
            this.function = abstractFunction;
            this.returnContainer = dataContainerArray[0];
            this.argumentContainers = new DataContainer[dataContainerArray.length - 2];
            System.arraycopy(dataContainerArray, 2, this.argumentContainers, 0, dataContainerArray.length - 2);
            if (bl && dataType != DataType.VOID) {
                new ExecutionUnit().alloc(dataType, dataContainerArray[0], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            }
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            try {
                this.function.invoke(this.returnContainer, this.argumentContainers);
            }
            catch (VnanoException vnanoException) {
                throw new RuntimeException(vnanoException);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class CachedScalarReferenceXfci1CallxNode
    extends AcceleratorExecutionNode {
        private final ScalarCache[] xfci1ArgCaches;
        private ExternalFunctionConnectorInterface1 function;

        public CachedScalarReferenceXfci1CallxNode(Object[] objectArray, DataContainer<?> dataContainer, DataType dataType, boolean bl, ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.function = externalFunctionConnectorInterface1;
            int n = objectArray.length;
            int n2 = n - 1;
            this.xfci1ArgCaches = new ScalarCache[n - 1];
            this.xfci1ArgCaches[0] = (ScalarCache)objectArray[0];
            for (int i = 1; i < n2; ++i) {
                this.xfci1ArgCaches[i] = (ScalarCache)objectArray[i + 1];
            }
            if (bl && dataType != DataType.VOID) {
                new ExecutionUnit().alloc(dataType, dataContainer, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            }
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            try {
                this.function.invoke(this.xfci1ArgCaches);
            }
            catch (ConnectorException connectorException) {
                throw new RuntimeException(connectorException);
            }
            return this.nextNode;
        }
    }

    private final class CachedScalarXfci1CallxNode
    extends AcceleratorExecutionNode {
        private final ScalarCache[] xfci1ArgCaches;
        private boolean[] xfci1ArgShouldCopied;
        private ExternalFunctionConnectorInterface1 function;

        public CachedScalarXfci1CallxNode(Object[] objectArray, DataContainer<?> dataContainer, DataType dataType, boolean bl, ExternalFunctionConnectorInterface1 externalFunctionConnectorInterface1, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.function = externalFunctionConnectorInterface1;
            int n = objectArray.length;
            int n2 = n - 1;
            this.xfci1ArgCaches = new ScalarCache[n - 1];
            this.xfci1ArgCaches[0] = (ScalarCache)objectArray[0];
            for (int i = 1; i < n2; ++i) {
                this.xfci1ArgCaches[i] = (ScalarCache)objectArray[i + 1];
            }
            boolean[] blArray = externalFunctionConnectorInterface1.getParameterReferencenesses();
            this.xfci1ArgShouldCopied = new boolean[blArray.length + 1];
            this.xfci1ArgShouldCopied[0] = false;
            for (int i = 1; i < n2; ++i) {
                this.xfci1ArgShouldCopied[i] = !blArray[i - 1];
            }
            if (bl && dataType != DataType.VOID) {
                new ExecutionUnit().alloc(dataType, dataContainer, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            }
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            int n = this.xfci1ArgCaches.length;
            Object[] objectArray = new ScalarCache[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.xfci1ArgShouldCopied[i] ? this.xfci1ArgCaches[i].clone() : this.xfci1ArgCaches[i];
            }
            try {
                this.function.invoke(objectArray);
            }
            catch (ConnectorException connectorException) {
                throw new RuntimeException(connectorException);
            }
            return this.nextNode;
        }
    }
}

