/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.HashSet;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64CachedScalarDualArithmeticUnit
extends AcceleratorExecutionUnit {
    public static final Set<OperationCode> AVAILABLE_OPERAND_SET = new HashSet<OperationCode>();

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        int n = blArray.length;
        Int64ScalarCache[] int64ScalarCacheArray = new Int64ScalarCache[n];
        for (int i = 0; i < n; ++i) {
            int64ScalarCacheArray[i] = (Int64ScalarCache)objectArray[i];
        }
        OperationCode[] operationCodeArray = acceleratorInstruction.getFusedOperationCodes();
        int n2 = acceleratorInstruction.getFusedInputOperandIndices()[0];
        Int64CachedScalarDualArithmeticNode int64CachedScalarDualArithmeticNode = null;
        if (n2 == 1) {
            int64CachedScalarDualArithmeticNode = this.generateLeftInputNode(operationCodeArray, int64ScalarCacheArray, acceleratorExecutionNode);
        } else if (n2 == 2) {
            int64CachedScalarDualArithmeticNode = this.generateRightInputNode(operationCodeArray, int64ScalarCacheArray, acceleratorExecutionNode);
        } else {
            throw new VnanoFatalException("Invalid fused input operand index: " + n2);
        }
        return int64CachedScalarDualArithmeticNode;
    }

    private Int64CachedScalarDualArithmeticNode generateLeftInputNode(OperationCode[] operationCodeArray, Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
        Int64CachedScalarDualArithmeticNode int64CachedScalarDualArithmeticNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddAddLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddSubLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddMulLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddDivLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddRemLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubAddLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubSubLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubMulLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubDivLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubRemLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulAddLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulSubLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulMulLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulDivLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulRemLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivAddLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivSubLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivMulLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivDivLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivRemLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemAddLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemSubLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemMulLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemDivLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemRemLeftInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for for this unit");
            }
        }
        return int64CachedScalarDualArithmeticNode;
    }

    private Int64CachedScalarDualArithmeticNode generateRightInputNode(OperationCode[] operationCodeArray, Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
        Int64CachedScalarDualArithmeticNode int64CachedScalarDualArithmeticNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddAddRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddSubRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddMulRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddDivRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarAddRemRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubAddRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubSubRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubMulRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubDivRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarSubRemRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulAddRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulSubRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulMulRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulDivRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarMulRemRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivAddRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivSubRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivMulRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivDivRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarDivRemRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemAddRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemSubRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemMulRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemDivRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64CachedScalarDualArithmeticNode = new Int64CachedScalarRemRemRightInputNode(int64ScalarCacheArray, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for this unit");
            }
        }
        return int64CachedScalarDualArithmeticNode;
    }

    static {
        AVAILABLE_OPERAND_SET.add(OperationCode.ADD);
        AVAILABLE_OPERAND_SET.add(OperationCode.SUB);
        AVAILABLE_OPERAND_SET.add(OperationCode.MUL);
        AVAILABLE_OPERAND_SET.add(OperationCode.DIV);
        AVAILABLE_OPERAND_SET.add(OperationCode.REM);
    }

    private abstract class Int64CachedScalarDualArithmeticNode
    extends AcceleratorExecutionNode {
        protected final Int64ScalarCache cache00;
        protected final Int64ScalarCache cache01;
        protected final Int64ScalarCache cache02;
        protected final Int64ScalarCache cache10;
        protected final Int64ScalarCache cache11;
        protected final Int64ScalarCache cache12;

        public Int64CachedScalarDualArithmeticNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.cache00 = int64ScalarCacheArray[0];
            this.cache01 = int64ScalarCacheArray[1];
            this.cache02 = int64ScalarCacheArray[2];
            this.cache10 = int64ScalarCacheArray[3];
            this.cache11 = int64ScalarCacheArray[4];
            this.cache12 = int64ScalarCacheArray[5];
        }
    }

    private final class Int64CachedScalarAddAddLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddAddLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddSubLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddSubLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddMulLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddMulLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddDivLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddDivLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddRemLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddRemLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubAddLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubAddLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubSubLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubSubLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubMulLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubMulLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubDivLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubDivLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubRemLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubRemLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulAddLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulAddLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulSubLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulSubLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulMulLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulMulLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulDivLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulDivLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulRemLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulRemLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivAddLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivAddLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivSubLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivSubLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivMulLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivMulLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivDivLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivDivLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivRemLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivRemLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemAddLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemAddLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data + this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemSubLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemSubLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data - this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemMulLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemMulLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data * this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemDivLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemDivLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data / this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemRemLeftInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemRemLeftInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache00.data % this.cache12.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddAddRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddAddRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddSubRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddSubRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddMulRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddMulRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddDivRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddDivRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarAddRemRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarAddRemRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data + this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubAddRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubAddRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubSubRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubSubRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubMulRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubMulRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubDivRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubDivRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarSubRemRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarSubRemRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data - this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulAddRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulAddRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulSubRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulSubRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulMulRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulMulRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulDivRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulDivRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarMulRemRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarMulRemRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data * this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivAddRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivAddRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivSubRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivSubRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivMulRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivMulRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivDivRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivDivRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarDivRemRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarDivRemRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data / this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemAddRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemAddRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data + this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemSubRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemSubRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data - this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemMulRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemMulRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data * this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemDivRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemDivRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data / this.cache00.data;
            return this.nextNode;
        }
    }

    private final class Int64CachedScalarRemRemRightInputNode
    extends Int64CachedScalarDualArithmeticNode {
        public Int64CachedScalarRemRemRightInputNode(Int64ScalarCache[] int64ScalarCacheArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(int64ScalarCacheArray, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache00.data = this.cache01.data % this.cache02.data;
            this.cache10.data = this.cache11.data % this.cache00.data;
            return this.nextNode;
        }
    }
}

