/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64VectorDualArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer = new Int64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        OperationCode[] operationCodeArray = acceleratorInstruction.getFusedOperationCodes();
        int n = acceleratorInstruction.getFusedInputOperandIndices()[0];
        Int64VectorDualArithmeticNode int64VectorDualArithmeticNode = null;
        if (n == 1) {
            int64VectorDualArithmeticNode = this.generateLeftInputNode(operationCodeArray, dataContainerArray2, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        } else if (n == 2) {
            int64VectorDualArithmeticNode = this.generateRightInputNode(operationCodeArray, dataContainerArray2, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        } else {
            throw new VnanoFatalException("Invalid fused input operand index: " + n);
        }
        return int64VectorDualArithmeticNode;
    }

    private Int64VectorDualArithmeticNode generateLeftInputNode(OperationCode[] operationCodeArray, DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
        Int64VectorDualArithmeticNode int64VectorDualArithmeticNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorAddAddLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorAddSubLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorAddMulLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorAddDivLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorAddRemLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorSubAddLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorSubSubLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorSubMulLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorSubDivLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorSubRemLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorMulAddLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorMulSubLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorMulMulLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorMulDivLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorMulRemLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorDivAddLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorDivSubLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorDivMulLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorDivDivLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorDivRemLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorRemAddLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorRemSubLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorRemMulLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorRemDivLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorRemRemLeftInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for for this unit");
            }
        }
        return int64VectorDualArithmeticNode;
    }

    private Int64VectorDualArithmeticNode generateRightInputNode(OperationCode[] operationCodeArray, DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
        Int64VectorDualArithmeticNode int64VectorDualArithmeticNode = null;
        block0 : switch (operationCodeArray[0]) {
            case ADD: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorAddAddRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorAddSubRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorAddMulRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorAddDivRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorAddRemRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case SUB: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorSubAddRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorSubSubRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorSubMulRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorSubDivRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorSubRemRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case MUL: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorMulAddRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorMulSubRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorMulMulRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorMulDivRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorMulRemRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case DIV: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorDivAddRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorDivSubRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorDivMulRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorDivDivRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorDivRemRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            case REM: {
                switch (operationCodeArray[1]) {
                    case ADD: {
                        int64VectorDualArithmeticNode = new Int64VectorRemAddRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case SUB: {
                        int64VectorDualArithmeticNode = new Int64VectorRemSubRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case MUL: {
                        int64VectorDualArithmeticNode = new Int64VectorRemMulRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case DIV: {
                        int64VectorDualArithmeticNode = new Int64VectorRemDivRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                    case REM: {
                        int64VectorDualArithmeticNode = new Int64VectorRemRemRightInputNode(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                        break block0;
                    }
                }
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[1]) + " is invalid for this unit");
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)operationCodeArray[0]) + " is invalid for this unit");
            }
        }
        return int64VectorDualArithmeticNode;
    }

    private abstract class Int64VectorDualArithmeticNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container01;
        protected final DataContainer<double[]> container02;
        protected final DataContainer<double[]> container10;
        protected final DataContainer<double[]> container11;
        protected final DataContainer<double[]> container12;
        protected final Int64x3ScalarCacheSynchronizer synchronizer;

        public Int64VectorDualArithmeticNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.container01 = dataContainerArray[1];
            this.container02 = dataContainerArray[2];
            this.container10 = dataContainerArray[0];
            this.container11 = dataContainerArray[1];
            this.container12 = dataContainerArray[2];
            this.synchronizer = int64x3ScalarCacheSynchronizer;
        }
    }

    private final class Int64VectorAddAddLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] + dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddSubLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] + dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddMulLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] + dArray2[i]) * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddDivLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] + dArray2[i]) / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddRemLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] + dArray2[i]) % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubAddLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] - dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubSubLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] - dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubMulLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] - dArray2[i]) * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubDivLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] - dArray2[i]) / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubRemLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray[i] - dArray2[i]) % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulAddLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulSubLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulMulLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulDivLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulRemLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] * dArray2[i] % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivAddLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivSubLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivMulLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivDivLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivRemLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] / dArray2[i] % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemAddLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemAddLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] + dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemSubLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemSubLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] - dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemMulLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemMulLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] * dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemDivLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemDivLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] / dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemRemLeftInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemRemLeftInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container12.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray[i] % dArray2[i] % dArray4[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddAddRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddSubRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddMulRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddDivRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorAddRemRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorAddRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] + dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubAddRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubSubRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubMulRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubDivRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorSubRemRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorSubRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] - dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulAddRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + dArray[i] * dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulSubRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - dArray[i] * dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulMulRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] * dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulDivRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] * dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorMulRemRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorMulRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] * dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivAddRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + dArray[i] / dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivSubRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - dArray[i] / dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivMulRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] / dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivDivRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] / dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorDivRemRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorDivRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] / dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemAddRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemAddRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] + dArray[i] % dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemSubRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemSubRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] - dArray[i] % dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemMulRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemMulRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] * (dArray[i] % dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemDivRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemDivRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] / (dArray[i] % dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Int64VectorRemRemRightInputNode
    extends Int64VectorDualArithmeticNode {
        public Int64VectorRemRemRightInputNode(DataContainer<double[]>[] dataContainerArray, Int64x3ScalarCacheSynchronizer int64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainerArray, int64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container01.getArrayData();
            double[] dArray2 = (double[])this.container02.getArrayData();
            double[] dArray3 = (double[])this.container10.getArrayData();
            double[] dArray4 = (double[])this.container11.getArrayData();
            int n = this.container10.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray3[i] = dArray4[i] % (dArray[i] % dArray2[i]);
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

