/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.memory;

import java.util.HashMap;
import org.vcssl.connect.ArrayDataAccessorInterface1;
import org.vcssl.connect.BoolScalarDataAccessorInterface1;
import org.vcssl.connect.Float64ScalarDataAccessorInterface1;
import org.vcssl.connect.Int64ScalarDataAccessorInterface1;
import org.vcssl.connect.StringScalarDataAccessorInterface1;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;

public class DataContainer<T>
implements ArrayDataAccessorInterface1<T>,
Float64ScalarDataAccessorInterface1,
Int64ScalarDataAccessorInterface1,
BoolScalarDataAccessorInterface1,
StringScalarDataAccessorInterface1 {
    public static final int ARRAY_RANK_OF_SCALAR = 0;
    public static final int[] ARRAY_LENGTHS_OF_SCALAR = new int[0];
    public static final int ARRAY_SIZE_OF_SCALAR = 1;
    private static final HashMap<Class<?>, DataType> CLASS_DATA_TYPE_MAP = new HashMap();
    private T data;
    private int size;
    private int[] lengths;
    private int offset;
    private DataContainer<T> referenceTreeRoot;

    public DataContainer() {
        this.initialize();
    }

    public final void initialize() {
        this.data = null;
        this.referenceTreeRoot = null;
        this.size = 1;
        this.lengths = ARRAY_LENGTHS_OF_SCALAR;
        this.offset = 0;
    }

    @Override
    public final void setArrayData(T t, int n, int[] nArray) {
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        if (this.referenceTreeRoot == null) {
            this.data = t;
            this.offset = n;
            this.lengths = nArray;
            this.size = n2;
        } else {
            this.referenceTreeRoot.data = t;
            this.referenceTreeRoot.offset = n;
            this.referenceTreeRoot.lengths = nArray;
            this.referenceTreeRoot.size = n2;
        }
    }

    @Override
    public final T getArrayData() {
        return this.referenceTreeRoot == null ? this.data : this.referenceTreeRoot.data;
    }

    @Override
    public final boolean hasArrayData() {
        if (this.referenceTreeRoot == null) {
            return this.data != null;
        }
        return this.referenceTreeRoot.data != null;
    }

    @Override
    public final int getArrayOffset() {
        return this.referenceTreeRoot == null ? this.offset : this.referenceTreeRoot.offset;
    }

    @Override
    public final int getArraySize() {
        return this.referenceTreeRoot == null ? this.size : this.referenceTreeRoot.size;
    }

    @Override
    public final int[] getArrayLengths() {
        return this.referenceTreeRoot == null ? this.lengths : this.referenceTreeRoot.lengths;
    }

    @Override
    public final int getArrayRank() {
        return this.referenceTreeRoot == null ? this.lengths.length : this.referenceTreeRoot.lengths.length;
    }

    public final DataType getDataType() {
        T t = this.referenceTreeRoot == null ? this.data : this.referenceTreeRoot.data;
        DataType dataType = DataType.VOID;
        if (t != null && (dataType = CLASS_DATA_TYPE_MAP.get(t.getClass())) == null) {
            dataType = DataType.VOID;
        }
        return dataType;
    }

    public final void refer(DataContainer<T> dataContainer) {
        this.referenceTreeRoot = dataContainer;
        while (this.referenceTreeRoot.referenceTreeRoot != null) {
            this.referenceTreeRoot = this.referenceTreeRoot.referenceTreeRoot;
        }
    }

    public final void derefer() {
        this.referenceTreeRoot = null;
    }

    @Override
    public final void setFloat64ScalarData(double d) {
        this.size = 1;
        this.lengths = ARRAY_LENGTHS_OF_SCALAR;
        T t = this.getArrayData();
        if (t instanceof double[]) {
            ((double[])t)[this.getArrayOffset()] = d;
        } else if (t == null) {
            try {
                double[] dArray = new double[]{d};
                this.setArrayData(dArray, 0, ARRAY_LENGTHS_OF_SCALAR);
            }
            catch (ClassCastException classCastException) {
                throw new VnanoFatalException("Data type is incorrect");
            }
        } else {
            throw new VnanoFatalException("Data type is incorrect");
        }
    }

    @Override
    public final double getFloat64ScalarData() {
        T t = this.getArrayData();
        if (t instanceof double[]) {
            return ((double[])t)[this.getArrayOffset()];
        }
        if (t == null) {
            throw new VnanoFatalException("No data is stored");
        }
        throw new VnanoFatalException("Data type is incorrect");
    }

    @Override
    public final boolean hasFloat64ScalarData() {
        if (this.getArrayData() == null) {
            return false;
        }
        if (!(this.getArrayData() instanceof double[])) {
            return false;
        }
        return this.getArrayRank() != 0;
    }

    @Override
    public final void setInt64ScalarData(long l) {
        this.size = 1;
        this.lengths = ARRAY_LENGTHS_OF_SCALAR;
        T t = this.getArrayData();
        if (t instanceof long[]) {
            ((long[])t)[this.getArrayOffset()] = l;
        } else if (t == null) {
            try {
                long[] lArray = new long[]{l};
                this.setArrayData(lArray, 0, ARRAY_LENGTHS_OF_SCALAR);
            }
            catch (ClassCastException classCastException) {
                throw new VnanoFatalException("Data type is incorrect");
            }
        } else {
            throw new VnanoFatalException("Data type is incorrect");
        }
    }

    @Override
    public final long getInt64ScalarData() {
        T t = this.getArrayData();
        if (t instanceof long[]) {
            return ((long[])t)[this.getArrayOffset()];
        }
        if (t == null) {
            throw new VnanoFatalException("No data is stored");
        }
        throw new VnanoFatalException("Data type is incorrect");
    }

    @Override
    public final boolean hasInt64ScalarData() {
        if (this.getArrayData() == null) {
            return false;
        }
        if (!(this.getArrayData() instanceof long[])) {
            return false;
        }
        return this.getArrayRank() != 0;
    }

    @Override
    public final void setBoolScalarData(boolean bl) {
        this.size = 1;
        this.lengths = ARRAY_LENGTHS_OF_SCALAR;
        T t = this.getArrayData();
        if (t instanceof boolean[]) {
            ((boolean[])t)[this.getArrayOffset()] = bl;
        } else if (t == null) {
            try {
                boolean[] blArray = new boolean[]{bl};
                this.setArrayData(blArray, 0, ARRAY_LENGTHS_OF_SCALAR);
            }
            catch (ClassCastException classCastException) {
                throw new VnanoFatalException("Data type is incorrect");
            }
        } else {
            throw new VnanoFatalException("Data type is incorrect");
        }
    }

    @Override
    public final boolean getBoolScalarData() {
        T t = this.getArrayData();
        if (t instanceof boolean[]) {
            return ((boolean[])t)[this.getArrayOffset()];
        }
        if (t == null) {
            throw new VnanoFatalException("No data is stored");
        }
        throw new VnanoFatalException("Data type is incorrect");
    }

    @Override
    public final boolean hasBoolScalarData() {
        if (this.getArrayData() == null) {
            return false;
        }
        if (!(this.getArrayData() instanceof boolean[])) {
            return false;
        }
        return this.getArrayRank() != 0;
    }

    @Override
    public final void setStringScalarData(String string) {
        this.size = 1;
        this.lengths = ARRAY_LENGTHS_OF_SCALAR;
        T t = this.getArrayData();
        if (t instanceof String[]) {
            ((String[])t)[this.getArrayOffset()] = string;
        } else if (t == null) {
            try {
                String[] stringArray = new String[]{string};
                this.setArrayData(stringArray, 0, ARRAY_LENGTHS_OF_SCALAR);
            }
            catch (ClassCastException classCastException) {
                throw new VnanoFatalException("Data type is incorrect");
            }
        } else {
            throw new VnanoFatalException("Data type is incorrect");
        }
    }

    @Override
    public final String getStringScalarData() {
        T t = this.getArrayData();
        if (t instanceof String[]) {
            return ((String[])t)[this.getArrayOffset()];
        }
        if (t == null) {
            throw new VnanoFatalException("No data is stored");
        }
        throw new VnanoFatalException("Data type is incorrect");
    }

    @Override
    public final boolean hasStringScalarData() {
        if (this.getArrayData() == null) {
            return false;
        }
        if (!(this.getArrayData() instanceof String[])) {
            return false;
        }
        return this.getArrayRank() != 0;
    }

    static {
        CLASS_DATA_TYPE_MAP.put(long[].class, DataType.INT64);
        CLASS_DATA_TYPE_MAP.put(double[].class, DataType.FLOAT64);
        CLASS_DATA_TYPE_MAP.put(boolean[].class, DataType.BOOL);
        CLASS_DATA_TYPE_MAP.put(String[].class, DataType.STRING);
    }
}

