/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.ExecutionUnit;
import org.vcssl.nano.vm.processor.Instruction;

public class DispatchUnit {
    public final int dispatch(Instruction instruction, Memory memory, Interconnect interconnect, ExecutionUnit executionUnit, boolean[] blArray, int n) throws VnanoException {
        OperationCode operationCode = instruction.getOperationCode();
        DataType[] dataTypeArray = instruction.getDataTypes();
        DataContainer<?>[] dataContainerArray = this.loadOperandData(instruction, memory);
        int n2 = dataContainerArray.length;
        switch (operationCode) {
            case ADD: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.add(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case SUB: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.sub(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case MUL: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.mul(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case DIV: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.div(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case REM: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.rem(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case NEG: {
                this.checkNumberOfOperands(instruction, 2);
                executionUnit.neg(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case EQ: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.eq(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case NEQ: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.neq(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case GEQ: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.geq(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case LEQ: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.leq(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case GT: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.gt(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case LT: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.lt(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case ANDM: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.and(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case ORM: {
                this.checkNumberOfOperands(instruction, 3);
                executionUnit.or(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray[2]);
                return n + 1;
            }
            case NOT: {
                this.checkNumberOfOperands(instruction, 2);
                executionUnit.not(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case ALLOC: {
                if (dataContainerArray.length == 1) {
                    executionUnit.allocScalar(dataTypeArray[0], dataContainerArray[0]);
                } else {
                    DataContainer[] dataContainerArray2 = new DataContainer[dataContainerArray.length - 1];
                    System.arraycopy(dataContainerArray, 1, dataContainerArray2, 0, dataContainerArray.length - 1);
                    executionUnit.allocVector(dataTypeArray[0], dataContainerArray[0], dataContainerArray2);
                }
                return n + 1;
            }
            case ALLOCR: {
                executionUnit.allocSameLengths(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case ALLOCP: {
                executionUnit.allocSameLengths(dataTypeArray[0], dataContainerArray[0], memory.peek());
                return n + 1;
            }
            case ALLOCT: {
                return n + 1;
            }
            case FREE: {
                this.checkNumberOfOperands(instruction, 1);
                dataContainerArray[0].initialize();
                return n + 1;
            }
            case MOV: {
                this.checkNumberOfOperands(instruction, 2);
                executionUnit.mov(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case REF: {
                this.checkNumberOfOperands(instruction, 2);
                executionUnit.ref(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case POP: {
                this.checkNumberOfOperands(instruction, 1);
                memory.pop();
                return n + 1;
            }
            case MOVPOP: {
                this.checkNumberOfOperands(instruction, 1);
                DataContainer<?> dataContainer = memory.pop();
                executionUnit.mov(dataTypeArray[0], dataContainerArray[0], dataContainer);
                return n + 1;
            }
            case REFPOP: {
                this.checkNumberOfOperands(instruction, 1);
                DataContainer<?> dataContainer = memory.pop();
                executionUnit.ref(dataTypeArray[0], dataContainerArray[0], dataContainer);
                return n + 1;
            }
            case CAST: {
                this.checkNumberOfOperands(instruction, 2);
                executionUnit.cast(dataTypeArray[0], dataTypeArray[1], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case FILL: {
                this.checkNumberOfOperands(instruction, 2);
                executionUnit.fill(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1]);
                return n + 1;
            }
            case MOVELM: {
                executionUnit.movelm(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray, 2);
                return n + 1;
            }
            case REFELM: {
                executionUnit.refelm(dataTypeArray[0], dataContainerArray[0], dataContainerArray[1], dataContainerArray, 2);
                return n + 1;
            }
            case JMP: {
                this.checkNumberOfOperands(instruction, 3);
                boolean[] blArray2 = (boolean[])dataContainerArray[2].getArrayData();
                boolean bl = true;
                for (boolean bl2 : blArray2) {
                    bl &= bl2;
                }
                if (bl) {
                    return (int)((long[])dataContainerArray[1].getArrayData())[0];
                }
                return n + 1;
            }
            case JMPN: {
                this.checkNumberOfOperands(instruction, 3);
                boolean[] blArray3 = (boolean[])dataContainerArray[2].getArrayData();
                boolean bl = false;
                for (boolean bl3 : blArray3) {
                    bl |= bl3;
                }
                if (bl) {
                    return n + 1;
                }
                return (int)((long[])dataContainerArray[1].getArrayData())[0];
            }
            case CALL: {
                int n3;
                int n4 = n + 1;
                DataContainer<long[]> dataContainer = new DataContainer<long[]>();
                dataContainer.setArrayData(new long[]{n4}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
                memory.push(dataContainer);
                for (n3 = 2; n3 < n2; ++n3) {
                    memory.push(dataContainerArray[n3]);
                }
                n3 = (int)((long[])dataContainerArray[1].getArrayData())[0];
                if (blArray[n3]) {
                    throw new VnanoException(ErrorType.RECURSIVE_FUNCTION_CALL);
                }
                blArray[n3] = true;
                return n3;
            }
            case RET: {
                DataContainer<?> dataContainer = memory.pop();
                int n5 = (int)((long[])dataContainer.getArrayData())[0];
                if (dataContainerArray.length <= 2) {
                    memory.push(new DataContainer());
                } else {
                    memory.push(dataContainerArray[2]);
                }
                int n6 = (int)((long[])dataContainerArray[1].getArrayData())[0];
                blArray[n6] = false;
                return n5;
            }
            case CALLX: {
                int n7 = (int)((long[])dataContainerArray[1].getArrayData())[0];
                int n8 = dataContainerArray.length - 2;
                DataContainer[] dataContainerArray3 = new DataContainer[n8];
                System.arraycopy(dataContainerArray, 2, dataContainerArray3, 0, n8);
                interconnect.callExternalFunction(n7, dataContainerArray[0], dataContainerArray3);
                return n + 1;
            }
            case ENDFUN: {
                String string = ((String[])dataContainerArray[0].getArrayData())[0];
                throw new VnanoException(ErrorType.FUNCTION_ENDED_WITHOUT_RETURNING_VALUE, string);
            }
            case END: {
                if (n2 == 2) {
                    DataContainer dataContainer = new DataContainer();
                    executionUnit.allocSameLengths(dataTypeArray[0], dataContainer, dataContainerArray[1]);
                    executionUnit.mov(dataTypeArray[0], dataContainer, dataContainerArray[1]);
                    memory.setResultDataContainer(dataContainerArray[1]);
                }
                return -1;
            }
            case NOP: 
            case LABEL: 
            case ENDPRM: {
                this.checkNumberOfOperands(instruction, 1);
                return n + 1;
            }
        }
        throw new VnanoFatalException("Unsupported operation code: " + (Object)((Object)operationCode));
    }

    private void checkNumberOfOperands(Instruction instruction, int n) {
        int n2 = instruction.getOperandPartitions().length;
        int n3 = instruction.getOperandPartitions().length;
        if (n3 != n) {
            throw new VnanoFatalException("Invalid number of operands: " + Integer.toString(n3));
        }
        if (n2 != n) {
            throw new VnanoFatalException("Invalid number of operands: " + Integer.toString(n3));
        }
    }

    private DataContainer<?>[] loadOperandData(Instruction instruction, Memory memory) {
        Memory.Partition[] partitionArray = instruction.getOperandPartitions();
        int[] nArray = instruction.getOperandAddresses();
        int n = nArray.length;
        DataContainer[] dataContainerArray = new DataContainer[n];
        for (int i = 0; i < n; ++i) {
            dataContainerArray[i] = memory.getDataContainer(partitionArray[i], nArray[i]);
        }
        return dataContainerArray;
    }
}

