/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.processor.ExecutionUnit;

public class ExecutionUnitTest {
    private static final double FLOAT64_PERMISSIBLE_ERROR = 1.0E-10;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAddInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAddInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        long[] lArray = new long[3];
        lArray[1] = 1L;
        lArray[2] = 2L;
        inputA.setArrayData(lArray, 0, new int[]{3});
        inputB.setArrayData(new long[]{3L, 4L, 5L}, 0, new int[]{3});
        try {
            new ExecutionUnit().add(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 3L || ((long[])output.getArrayData())[1] != 5L || ((long[])output.getArrayData())[2] != 7L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAddFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.375) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.25, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[1] != 0.375) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAddFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        inputA.setArrayData(new double[]{1.0, 0.5, 0.25}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.125, 0.0625, 0.03125}, 0, new int[]{3});
        try {
            new ExecutionUnit().add(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 1.125 || ((double[])output.getArrayData())[1] != 0.5625 || ((double[])output.getArrayData())[2] != 0.28125) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAddStringScalar() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> inputA = new DataContainer<String[]>();
        DataContainer<String[]> inputB = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new String[]{"World"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])output.getArrayData())[0].equals("HelloWorld")) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new String[]{"", "Hello", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new String[]{"", "World", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])output.getArrayData())[1].equals("HelloWorld")) {
            Assert.fail((String)"Incorrect output value");
        }
        if (!((String[])output.getArrayData())[0].equals("Init0") || !((String[])output.getArrayData())[2].equals("Init2")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAddStringVector() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> inputA = new DataContainer<String[]>();
        DataContainer<String[]> inputB = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        inputA.setArrayData(new String[]{"Good", "Hello", "Thank"}, 0, new int[]{3});
        inputB.setArrayData(new String[]{"Morning", "World", "You"}, 0, new int[]{3});
        try {
            new ExecutionUnit().add(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!(((String[])output.getArrayData())[0].equals("GoodMorning") && ((String[])output.getArrayData())[1].equals("HelloWorld") && ((String[])output.getArrayData())[2].equals("ThankYou"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAddUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().add(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().add(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().add(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().add(DataType.STRING, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testSubInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().sub(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 5L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 3L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().sub(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testSubInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        inputA.setArrayData(new long[]{5L, 1L, 7L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{3L, 8L, 7L}, 0, new int[]{3});
        try {
            new ExecutionUnit().sub(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L || ((long[])output.getArrayData())[1] != -7L || ((long[])output.getArrayData())[2] != 0L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testSubFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().sub(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.375) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().sub(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[1] != 0.375) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testSubFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        inputA.setArrayData(new double[]{1.0, 0.5, 0.03125}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.125, 0.0625, 0.25}, 0, new int[]{3});
        try {
            new ExecutionUnit().sub(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.875 || ((double[])output.getArrayData())[1] != 0.4375 || ((double[])output.getArrayData())[2] != -0.21875) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testSubUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().sub(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().sub(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().sub(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testMulInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mul(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 15L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 5L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 3L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mul(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != 15L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMulInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        inputA.setArrayData(new long[]{5L, 1L, -7L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{3L, -8L, -2L}, 0, new int[]{3});
        try {
            new ExecutionUnit().mul(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 15L || ((long[])output.getArrayData())[1] != -8L || ((long[])output.getArrayData())[2] != 14L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMulFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mul(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.0625) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mul(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[1] != 0.0625) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMulFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        inputA.setArrayData(new double[]{1.0, -0.5, -0.03125}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.125, 0.0625, -0.25}, 0, new int[]{3});
        try {
            new ExecutionUnit().mul(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.125 || ((double[])output.getArrayData())[1] != -0.03125 || ((double[])output.getArrayData())[2] != 0.0078125) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMulUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mul(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().mul(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().mul(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testDivInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{8L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().div(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 8L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 3L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().div(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testDivInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        inputA.setArrayData(new long[]{8L, 5L, -7L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{3L, -1L, -2L}, 0, new int[]{3});
        try {
            new ExecutionUnit().div(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L || ((long[])output.getArrayData())[1] != -5L || ((long[])output.getArrayData())[2] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testDivFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().div(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 4.0) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().div(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[1] != 4.0) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testDivFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        inputA.setArrayData(new double[]{1.0, -0.5, -0.03125}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.125, 0.0625, -0.25}, 0, new int[]{3});
        try {
            new ExecutionUnit().div(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 8.0 || ((double[])output.getArrayData())[1] != -8.0 || ((double[])output.getArrayData())[2] != 0.125) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testDivUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().div(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().div(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().div(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testRemInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{8L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().rem(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 8L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 3L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().rem(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRemInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L, -1L}, 0, new int[]{4});
        inputA.setArrayData(new long[]{8L, 8L, -8L, -8L}, 0, new int[]{4});
        inputB.setArrayData(new long[]{3L, -3L, 3L, -3L}, 0, new int[]{4});
        try {
            new ExecutionUnit().rem(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L || ((long[])output.getArrayData())[1] != 2L || ((long[])output.getArrayData())[2] != -2L || ((long[])output.getArrayData())[3] != -2L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRemFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.8}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.3}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().rem(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (1.0E-10 < Math.abs(((double[])output.getArrayData())[0] - 0.2)) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.8, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.3, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().rem(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (1.0E-10 < Math.abs(((double[])output.getArrayData())[1] - 0.2)) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRemFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0, -1.0, -1.0}, 0, new int[]{5});
        inputA.setArrayData(new double[]{1.0, 0.8, 0.8, -0.8, -0.8}, 0, new int[]{5});
        inputB.setArrayData(new double[]{0.125, 0.3, -0.3, 0.3, -0.3}, 0, new int[]{5});
        try {
            new ExecutionUnit().rem(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.0 || 1.0E-10 < Math.abs(((double[])output.getArrayData())[1] - 0.2) || 1.0E-10 < Math.abs(((double[])output.getArrayData())[2] - 0.2) || 1.0E-10 < Math.abs(((double[])output.getArrayData())[3] + 0.2) || 1.0E-10 < Math.abs(((double[])output.getArrayData())[4] + 0.2)) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRemUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().rem(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().rem(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().rem(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testNegInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new long[]{8L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neg(DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != -8L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 8L;
        input.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neg(DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != -8L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNegInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        long[] lArray = new long[3];
        lArray[1] = 5L;
        lArray[2] = -7L;
        input.setArrayData(lArray, 0, new int[]{3});
        try {
            new ExecutionUnit().neg(DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 0L || ((long[])output.getArrayData())[1] != -5L || ((long[])output.getArrayData())[2] != 7L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNegFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.8}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neg(DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != -0.8) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.0, 0.8, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neg(DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[1] != -0.8) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNegFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new double[]{0.0, 0.8, -0.2}, 0, new int[]{3});
        try {
            new ExecutionUnit().neg(DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.0 || ((double[])output.getArrayData())[1] != -0.8 || ((double[])output.getArrayData())[2] != 0.2) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNegUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neg(DataType.BOOL, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().neg(DataType.INT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().neg(DataType.FLOAT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testEqInt64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqInt64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        long[] lArray = new long[3];
        lArray[1] = 1L;
        lArray[2] = 2L;
        inputA.setArrayData(lArray, 0, new int[]{3});
        long[] lArray2 = new long[3];
        lArray2[1] = 1L;
        lArray2[2] = 3L;
        inputB.setArrayData(lArray2, 0, new int[]{3});
        try {
            new ExecutionUnit().eq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqFloat64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{-1.0, 0.125, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{-1.0, 0.5, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqFloat64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new double[]{0.0, 0.125, 0.5}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.0, 0.125, 0.25}, 0, new int[]{3});
        try {
            new ExecutionUnit().eq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqStringScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<String[]> inputA = new DataContainer<String[]>();
        DataContainer<String[]> inputB = new DataContainer<String[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new String[]{"World"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.STRING, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new String[]{"", "Hello", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new String[]{"", "World", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.STRING, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqStringVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<String[]> inputA = new DataContainer<String[]>();
        DataContainer<String[]> inputB = new DataContainer<String[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new String[]{"", "Hello", "Good"}, 0, new int[]{3});
        inputB.setArrayData(new String[]{"", "Hello", "Morning"}, 0, new int[]{3});
        try {
            new ExecutionUnit().eq(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        inputA.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().eq(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        inputA.setArrayData(blArray, 0, new int[]{3});
        boolean[] blArray2 = new boolean[3];
        blArray2[1] = true;
        inputB.setArrayData(blArray2, 0, new int[]{3});
        try {
            new ExecutionUnit().eq(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testEqUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<Object[]> inputA = new DataContainer<Object[]>();
        DataContainer<Object[]> inputB = new DataContainer<Object[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new Object[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new Object[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().eq(DataType.VOID, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testNeqInt64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqInt64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        long[] lArray = new long[3];
        lArray[1] = 1L;
        lArray[2] = 2L;
        inputA.setArrayData(lArray, 0, new int[]{3});
        long[] lArray2 = new long[3];
        lArray2[1] = 1L;
        lArray2[2] = 3L;
        inputB.setArrayData(lArray2, 0, new int[]{3});
        try {
            new ExecutionUnit().neq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqFloat64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{-1.0, 0.125, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{-1.0, 0.5, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqFloat64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new double[]{0.0, 0.125, 0.5}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.0, 0.125, 0.25}, 0, new int[]{3});
        try {
            new ExecutionUnit().neq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqStringScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<String[]> inputA = new DataContainer<String[]>();
        DataContainer<String[]> inputB = new DataContainer<String[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new String[]{"World"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.STRING, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new String[]{"", "Hello", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new String[]{"", "World", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.STRING, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqStringVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<String[]> inputA = new DataContainer<String[]>();
        DataContainer<String[]> inputB = new DataContainer<String[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new String[]{"", "Hello", "Good"}, 0, new int[]{3});
        inputB.setArrayData(new String[]{"", "Hello", "Morning"}, 0, new int[]{3});
        try {
            new ExecutionUnit().neq(DataType.STRING, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        inputA.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().neq(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        inputA.setArrayData(blArray, 0, new int[]{3});
        boolean[] blArray2 = new boolean[3];
        blArray2[1] = true;
        inputB.setArrayData(blArray2, 0, new int[]{3});
        try {
            new ExecutionUnit().neq(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNeqUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<Object[]> inputA = new DataContainer<Object[]>();
        DataContainer<Object[]> inputB = new DataContainer<Object[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new Object[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new Object[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().neq(DataType.VOID, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testGeqInt64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGeqInt64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{1L, 3L, 2L}, 0, new int[]{3});
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGeqFloat64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGeqFloat64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new double[]{0.5, 0.125, 0.25}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.5, 0.25, 0.125}, 0, new int[]{3});
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGeqUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().geq(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().geq(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().geq(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testLeqInt64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLeqInt64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{1L, 3L, 2L}, 0, new int[]{3});
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLeqFloat64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLeqFloat64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new double[]{0.5, 0.125, 0.25}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.5, 0.25, 0.125}, 0, new int[]{3});
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLeqUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().leq(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().leq(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().leq(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testGtInt64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGtInt64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{1L, 3L, 2L}, 0, new int[]{3});
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGtFloat64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGtFloat64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new double[]{0.5, 0.125, 0.25}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.5, 0.25, 0.125}, 0, new int[]{3});
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testGtUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().gt(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().gt(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().gt(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testLtInt64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 1L;
        inputA.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray2 = new long[3];
        lArray2[1] = 2L;
        inputB.setArrayData(lArray2, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLtInt64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<long[]> inputA = new DataContainer<long[]>();
        DataContainer<long[]> inputB = new DataContainer<long[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        inputB.setArrayData(new long[]{1L, 3L, 2L}, 0, new int[]{3});
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLtFloat64Scalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.5}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.0, 0.5, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLtFloat64Vector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        inputA.setArrayData(new double[]{0.5, 0.125, 0.25}, 0, new int[]{3});
        inputB.setArrayData(new double[]{0.5, 0.25, 0.125}, 0, new int[]{3});
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testLtUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().lt(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().lt(DataType.INT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().lt(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testAndBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputB, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        inputA.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputB, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAndBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[4], 0, new int[]{4});
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[3] = true;
        inputA.setArrayData(blArray, 0, new int[]{4});
        boolean[] blArray2 = new boolean[4];
        blArray2[2] = true;
        blArray2[3] = true;
        inputB.setArrayData(blArray2, 0, new int[]{4});
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || ((boolean[])output.getArrayData())[2] || !((boolean[])output.getArrayData())[3]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testAndUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().and(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().and(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testOrBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputB, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        inputA.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputB, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputA, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputB, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testOrBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[4], 0, new int[]{4});
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[3] = true;
        inputA.setArrayData(blArray, 0, new int[]{4});
        boolean[] blArray2 = new boolean[4];
        blArray2[2] = true;
        blArray2[3] = true;
        inputB.setArrayData(blArray2, 0, new int[]{4});
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputA, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0] || !((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2] || !((boolean[])output.getArrayData())[3]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testOrUnoperatableData() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<double[]> inputA = new DataContainer<double[]>();
        DataContainer<double[]> inputB = new DataContainer<double[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new double[]{0.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().or(DataType.FLOAT64, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().or(DataType.BOOL, output, inputA, inputB);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testNotBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputA = new DataContainer<boolean[]>();
        DataContainer<boolean[]> inputB = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputA.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().not(DataType.BOOL, output, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().not(DataType.BOOL, output, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        inputA.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        inputB.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().not(DataType.BOOL, output, inputA);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        try {
            new ExecutionUnit().not(DataType.BOOL, output, inputB);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNotBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[2], 0, new int[]{2});
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        input.setArrayData(blArray, 0, new int[]{2});
        try {
            new ExecutionUnit().not(DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testNotUnoperatableData() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.125}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().not(DataType.FLOAT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        try {
            new ExecutionUnit().not(DataType.BOOL, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testAllocInt64Scalar() {
        DataContainer target = new DataContainer();
        try {
            new ExecutionUnit().allocScalar(DataType.INT64, target);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocInt64Array1D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len = new DataContainer<long[]>();
        len.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.INT64, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.INT64, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.INT64, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocInt64Array3D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len0 = new DataContainer<long[]>();
        DataContainer<long[]> len1 = new DataContainer<long[]>();
        DataContainer<long[]> len2 = new DataContainer<long[]>();
        len0.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{4L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.INT64, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.INT64, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.INT64, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocFloat64Scalar() {
        DataContainer target = new DataContainer();
        try {
            new ExecutionUnit().allocScalar(DataType.FLOAT64, target);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocFloat64Array1D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len = new DataContainer<long[]>();
        len.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.FLOAT64, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.FLOAT64, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.FLOAT64, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocFloat64Array3D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len0 = new DataContainer<long[]>();
        DataContainer<long[]> len1 = new DataContainer<long[]>();
        DataContainer<long[]> len2 = new DataContainer<long[]>();
        len0.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{4L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.FLOAT64, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.FLOAT64, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.FLOAT64, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocBoolScalar() {
        DataContainer target = new DataContainer();
        try {
            new ExecutionUnit().allocScalar(DataType.BOOL, target);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocBoolArray1D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len = new DataContainer<long[]>();
        len.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.BOOL, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.BOOL, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.BOOL, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocBoolArray3D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len0 = new DataContainer<long[]>();
        DataContainer<long[]> len1 = new DataContainer<long[]>();
        DataContainer<long[]> len2 = new DataContainer<long[]>();
        len0.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{4L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.BOOL, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.BOOL, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.BOOL, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocStringScalar() {
        DataContainer target = new DataContainer();
        try {
            new ExecutionUnit().allocScalar(DataType.STRING, target);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocStringArray1D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len = new DataContainer<long[]>();
        len.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.STRING, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.STRING, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.STRING, target, len);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocStringArray3D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> len0 = new DataContainer<long[]>();
        DataContainer<long[]> len1 = new DataContainer<long[]>();
        DataContainer<long[]> len2 = new DataContainer<long[]>();
        len0.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{4L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.STRING, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.STRING, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        len0.setArrayData(new long[]{5L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{6L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{7L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.STRING, target, len0, len1, len2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocUnoperatableData() {
        DataContainer target = new DataContainer();
        try {
            new ExecutionUnit().allocScalar(DataType.VOID, target);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        DataContainer<long[]> len = new DataContainer<long[]>();
        len.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().allocVector(DataType.VOID, target, len);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testAllocrInt64Scalar() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> src = new DataContainer<long[]>();
        src.setArrayData(new long[1], 0, new int[0]);
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrInt64Array1D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> src = new DataContainer<long[]>();
        src.setArrayData(new long[3], 0, new int[]{3});
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new long[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new long[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrInt64Array3D() {
        DataContainer target = new DataContainer();
        DataContainer<long[]> src = new DataContainer<long[]>();
        src.setArrayData(new long[24], 0, new int[]{2, 3, 4});
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new long[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new long[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.INT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof long[]) || ((long[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrFloat64Scalar() {
        DataContainer target = new DataContainer();
        DataContainer<double[]> src = new DataContainer<double[]>();
        src.setArrayData(new double[1], 0, new int[0]);
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrFloat64Array1D() {
        DataContainer target = new DataContainer();
        DataContainer<double[]> src = new DataContainer<double[]>();
        src.setArrayData(new double[3], 0, new int[]{3});
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new double[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new double[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrFloat64Array3D() {
        DataContainer target = new DataContainer();
        DataContainer<double[]> src = new DataContainer<double[]>();
        src.setArrayData(new double[24], 0, new int[]{2, 3, 4});
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new double[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new double[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.FLOAT64, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof double[]) || ((double[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrBoolScalar() {
        DataContainer target = new DataContainer();
        DataContainer<boolean[]> src = new DataContainer<boolean[]>();
        src.setArrayData(new boolean[1], 0, new int[0]);
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrBoolArray1D() {
        DataContainer target = new DataContainer();
        DataContainer<boolean[]> src = new DataContainer<boolean[]>();
        src.setArrayData(new boolean[3], 0, new int[]{3});
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new boolean[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new boolean[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrBoolArray3D() {
        DataContainer target = new DataContainer();
        DataContainer<boolean[]> src = new DataContainer<boolean[]>();
        src.setArrayData(new boolean[24], 0, new int[]{2, 3, 4});
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new boolean[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new boolean[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.BOOL, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof boolean[]) || ((boolean[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrStringScalar() {
        DataContainer target = new DataContainer();
        DataContainer<String[]> src = new DataContainer<String[]>();
        src.setArrayData(new String[1], 0, new int[0]);
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length <= target.getArrayOffset() || target.getArraySize() != 1 || target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrStringArray1D() {
        DataContainer target = new DataContainer();
        DataContainer<String[]> src = new DataContainer<String[]>();
        src.setArrayData(new String[3], 0, new int[]{3});
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 3 || target.getArrayOffset() != 0 || target.getArraySize() != 3 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 3) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new String[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new String[5], 0, new int[]{5});
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 5 || target.getArrayOffset() != 0 || target.getArraySize() != 5 || target.getArrayLengths().length != 1 || target.getArrayLengths()[0] != 5) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testAllocrStringArray3D() {
        DataContainer target = new DataContainer();
        DataContainer<String[]> src = new DataContainer<String[]>();
        src.setArrayData(new String[24], 0, new int[]{2, 3, 4});
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        Object data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 24 || target.getArrayOffset() != 0 || target.getArraySize() != 24 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 2 || target.getArrayLengths()[1] != 3 || target.getArrayLengths()[2] != 4) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new String[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
        src.setArrayData(new String[210], 0, new int[]{5, 6, 7});
        try {
            new ExecutionUnit().allocSameLengths(DataType.STRING, target, src);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        data = target.getArrayData();
        if (!(data instanceof String[]) || ((String[])data).length != 210 || target.getArrayOffset() != 0 || target.getArraySize() != 210 || target.getArrayLengths().length != 3 || target.getArrayLengths()[0] != 5 || target.getArrayLengths()[1] != 6 || target.getArrayLengths()[2] != 7) {
            Assert.fail((String)"Incorrect allocated data");
        }
    }

    @Test
    public void testMovInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.INT64, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[3];
        lArray[1] = 2L;
        input.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.INT64, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[1] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        input.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        try {
            new ExecutionUnit().mov(DataType.INT64, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 1L || ((long[])output.getArrayData())[1] != 2L || ((long[])output.getArrayData())[2] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.FLOAT64, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.25) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.0, 0.25, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.FLOAT64, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[1] != 0.25) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new double[]{0.5, -0.25, 0.125}, 0, new int[]{3});
        try {
            new ExecutionUnit().mov(DataType.FLOAT64, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.5 || ((double[])output.getArrayData())[1] != -0.25 || ((double[])output.getArrayData())[2] != 0.125) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.BOOL, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        input.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.BOOL, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[1]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        input.setArrayData(blArray, 0, new int[]{3});
        try {
            new ExecutionUnit().mov(DataType.BOOL, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovStringScalar() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.STRING, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])output.getArrayData())[0].equals("Hello")) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"", "Hello", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.STRING, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])output.getArrayData())[1].equals("Hello")) {
            Assert.fail((String)"Incorrect output value");
        }
        if (!((String[])output.getArrayData())[0].equals("Init0") || !((String[])output.getArrayData())[2].equals("Init2")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovStringVector() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        input.setArrayData(new String[]{"Hello", "World", "!"}, 0, new int[]{3});
        try {
            new ExecutionUnit().mov(DataType.STRING, output, input);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!(((String[])output.getArrayData())[0].equals("Hello") && ((String[])output.getArrayData())[1].equals("World") && ((String[])output.getArrayData())[2].equals("!"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovUnoperatableData() {
        DataContainer<ExecutionUnitTest> output = new DataContainer<ExecutionUnitTest>();
        DataContainer<ExecutionUnitTest> input = new DataContainer<ExecutionUnitTest>();
        output.setArrayData(this, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(this, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().mov(DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
        try {
            new ExecutionUnit().mov(DataType.INT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
        try {
            new ExecutionUnit().mov(DataType.FLOAT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
        try {
            new ExecutionUnit().mov(DataType.BOOL, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
        try {
            new ExecutionUnit().mov(DataType.STRING, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    @Test
    public void testFillInt64() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        input.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 2L || ((long[])output.getArrayData())[1] != 2L || ((long[])output.getArrayData())[2] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        long[] lArray = new long[3];
        lArray[1] = 8L;
        input.setArrayData(lArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])output.getArrayData())[0] != 8L || ((long[])output.getArrayData())[1] != 8L || ((long[])output.getArrayData())[2] != 8L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testFillFloat64() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new double[]{0.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.25 || ((double[])output.getArrayData())[1] != 0.25 || ((double[])output.getArrayData())[2] != 0.25) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new double[]{0.0, 0.125, 0.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])output.getArrayData())[0] != 0.125 || ((double[])output.getArrayData())[1] != 0.125 || ((double[])output.getArrayData())[2] != 0.125) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testFillBool() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        input.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!(((boolean[])output.getArrayData())[0] && ((boolean[])output.getArrayData())[1] && ((boolean[])output.getArrayData())[2])) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 0, new int[]{3});
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        input.setArrayData(blArray, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!(((boolean[])output.getArrayData())[0] && ((boolean[])output.getArrayData())[1] && ((boolean[])output.getArrayData())[2])) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testFillString() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        input.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!(((String[])output.getArrayData())[0].equals("Hello") && ((String[])output.getArrayData())[1].equals("Hello") && ((String[])output.getArrayData())[2].equals("Hello"))) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        input.setArrayData(new String[]{"", "Hello", ""}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().fill(DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!(((String[])output.getArrayData())[0].equals("Hello") && ((String[])output.getArrayData())[1].equals("Hello") && ((String[])output.getArrayData())[2].equals("Hello"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testFillUnoperatableData() {
        DataContainer output = new DataContainer();
        DataContainer input = new DataContainer();
        try {
            new ExecutionUnit().fill(DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    @Test
    public void testRefelmInt64() throws VnanoException {
        DataContainer dest = new DataContainer();
        DataContainer<long[]> src = new DataContainer<long[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        long[] lArray = new long[24];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        lArray[6] = 6L;
        lArray[7] = 7L;
        lArray[8] = 8L;
        lArray[9] = 9L;
        lArray[10] = 10L;
        lArray[11] = 11L;
        lArray[12] = 12L;
        lArray[13] = 13L;
        lArray[14] = 14L;
        lArray[15] = 15L;
        lArray[16] = 16L;
        lArray[17] = 17L;
        lArray[18] = 18L;
        lArray[19] = 19L;
        lArray[20] = 20L;
        lArray[21] = 21L;
        lArray[22] = 22L;
        lArray[23] = 23L;
        long[] arrayData = lArray;
        src.setArrayData(arrayData, 0, srcLengths);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().refelm(DataType.INT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])dest.getArrayData())[dest.getArrayOffset()] != 14L) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().refelm(DataType.INT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])dest.getArrayData())[dest.getArrayOffset()] != 11L) {
            Assert.fail((String)"Incorrect output value");
        }
        ((long[])dest.getArrayData())[dest.getArrayOffset()] = 123L;
        if (arrayData[11] != 123L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRefelmFloat64() throws VnanoException {
        DataContainer dest = new DataContainer();
        DataContainer<double[]> src = new DataContainer<double[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        double[] arrayData = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0};
        src.setArrayData(arrayData, 0, srcLengths);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().refelm(DataType.FLOAT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])dest.getArrayData())[dest.getArrayOffset()] != 14.0) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().refelm(DataType.FLOAT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])dest.getArrayData())[dest.getArrayOffset()] != 11.0) {
            Assert.fail((String)"Incorrect output value");
        }
        ((double[])dest.getArrayData())[dest.getArrayOffset()] = 123.0;
        if (arrayData[11] != 123.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRefelmBool() throws VnanoException {
        DataContainer dest = new DataContainer();
        DataContainer<boolean[]> src = new DataContainer<boolean[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        boolean[] blArray = new boolean[24];
        blArray[14] = true;
        boolean[] arrayData = blArray;
        src.setArrayData(arrayData, 0, srcLengths);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().refelm(DataType.BOOL, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])dest.getArrayData())[dest.getArrayOffset()]) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().refelm(DataType.BOOL, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])dest.getArrayData())[dest.getArrayOffset()]) {
            Assert.fail((String)"Incorrect output value");
        }
        ((boolean[])dest.getArrayData())[dest.getArrayOffset()] = true;
        if (!arrayData[11]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRefelmString() throws VnanoException {
        DataContainer dest = new DataContainer();
        DataContainer<String[]> src = new DataContainer<String[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        String[] arrayData = new String[]{"000", "001", "002", "003", "010", "011", "012", "013", "020", "021", "022", "023", "100", "101", "102", "103", "110", "111", "112", "113", "120", "121", "122", "123"};
        src.setArrayData(arrayData, 0, srcLengths);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().refelm(DataType.STRING, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])dest.getArrayData())[dest.getArrayOffset()].equals("102")) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().refelm(DataType.STRING, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])dest.getArrayData())[dest.getArrayOffset()].equals("023")) {
            Assert.fail((String)"Incorrect output value");
        }
        ((String[])dest.getArrayData())[dest.getArrayOffset()] = "888";
        if (!arrayData[11].equals("888")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testRefelmUnoperatableData() throws VnanoException {
        block2: {
            DataContainer dest = new DataContainer();
            DataContainer<Object> src = new DataContainer<Object>();
            DataContainer<long[]> index0 = new DataContainer<long[]>();
            DataContainer<long[]> index1 = new DataContainer<long[]>();
            DataContainer<long[]> index2 = new DataContainer<long[]>();
            src.setArrayData(null, 0, new int[]{1, 2, 3});
            index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
            try {
                new ExecutionUnit().refelm(DataType.VOID, dest, src, operands, 2);
                Assert.fail((String)"Expected exception did not occured");
            }
            catch (VnanoException e) {
                if (e.getErrorType() == ErrorType.INVALID_ARRAY_INDEX) break block2;
                Assert.fail((String)"Expected exception did not occured");
            }
        }
    }

    @Test
    public void testMovelmInt64() throws VnanoException {
        DataContainer<long[]> dest = new DataContainer<long[]>();
        DataContainer<long[]> src = new DataContainer<long[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        long[] lArray = new long[24];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        lArray[6] = 6L;
        lArray[7] = 7L;
        lArray[8] = 8L;
        lArray[9] = 9L;
        lArray[10] = 10L;
        lArray[11] = 11L;
        lArray[12] = 12L;
        lArray[13] = 13L;
        lArray[14] = 14L;
        lArray[15] = 15L;
        lArray[16] = 16L;
        lArray[17] = 17L;
        lArray[18] = 18L;
        lArray[19] = 19L;
        lArray[20] = 20L;
        lArray[21] = 21L;
        lArray[22] = 22L;
        lArray[23] = 23L;
        long[] arrayData = lArray;
        src.setArrayData(arrayData, 0, srcLengths);
        dest.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().movelm(DataType.INT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])dest.getArrayData())[dest.getArrayOffset()] != 14L) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().movelm(DataType.INT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((long[])dest.getArrayData())[dest.getArrayOffset()] != 11L) {
            Assert.fail((String)"Incorrect output value");
        }
        ((long[])dest.getArrayData())[dest.getArrayOffset()] = 123L;
        if (arrayData[11] != 11L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovelmFloat64() throws VnanoException {
        DataContainer<double[]> dest = new DataContainer<double[]>();
        DataContainer<double[]> src = new DataContainer<double[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        double[] arrayData = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0};
        src.setArrayData(arrayData, 0, srcLengths);
        dest.setArrayData(new double[]{0.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().movelm(DataType.FLOAT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])dest.getArrayData())[dest.getArrayOffset()] != 14.0) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().movelm(DataType.FLOAT64, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((double[])dest.getArrayData())[dest.getArrayOffset()] != 11.0) {
            Assert.fail((String)"Incorrect output value");
        }
        ((double[])dest.getArrayData())[dest.getArrayOffset()] = 123.0;
        if (arrayData[11] != 11.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovelmBool() throws VnanoException {
        DataContainer<boolean[]> dest = new DataContainer<boolean[]>();
        DataContainer<boolean[]> src = new DataContainer<boolean[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        boolean[] blArray = new boolean[24];
        blArray[14] = true;
        boolean[] arrayData = blArray;
        src.setArrayData(arrayData, 0, srcLengths);
        dest.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().movelm(DataType.BOOL, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((boolean[])dest.getArrayData())[dest.getArrayOffset()]) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().movelm(DataType.BOOL, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (((boolean[])dest.getArrayData())[dest.getArrayOffset()]) {
            Assert.fail((String)"Incorrect output value");
        }
        ((boolean[])dest.getArrayData())[dest.getArrayOffset()] = true;
        if (arrayData[11]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovelmString() throws VnanoException {
        DataContainer<String[]> dest = new DataContainer<String[]>();
        DataContainer<String[]> src = new DataContainer<String[]>();
        DataContainer<long[]> index0 = new DataContainer<long[]>();
        DataContainer<long[]> index1 = new DataContainer<long[]>();
        DataContainer<long[]> index2 = new DataContainer<long[]>();
        int[] srcLengths = new int[]{2, 3, 4};
        String[] arrayData = new String[]{"000", "001", "002", "003", "010", "011", "012", "013", "020", "021", "022", "023", "100", "101", "102", "103", "110", "111", "112", "113", "120", "121", "122", "123"};
        src.setArrayData(arrayData, 0, srcLengths);
        dest.setArrayData(new String[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
        try {
            new ExecutionUnit().movelm(DataType.STRING, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])dest.getArrayData())[dest.getArrayOffset()].equals("102")) {
            Assert.fail((String)"Incorrect output value");
        }
        index0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index1.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        index2.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().movelm(DataType.STRING, dest, src, operands, 2);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        if (!((String[])dest.getArrayData())[dest.getArrayOffset()].equals("023")) {
            Assert.fail((String)"Incorrect output value");
        }
        ((String[])dest.getArrayData())[dest.getArrayOffset()] = "888";
        if (!arrayData[11].equals("023")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testMovelmUnoperatableData() throws VnanoException {
        block2: {
            DataContainer dest = new DataContainer();
            DataContainer<Object> src = new DataContainer<Object>();
            DataContainer<long[]> index0 = new DataContainer<long[]>();
            DataContainer<long[]> index1 = new DataContainer<long[]>();
            DataContainer<long[]> index2 = new DataContainer<long[]>();
            src.setArrayData(null, 0, new int[]{1, 2, 3});
            index0.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            index1.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            index2.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            DataContainer[] operands = new DataContainer[]{dest, src, index0, index1, index2};
            try {
                new ExecutionUnit().movelm(DataType.VOID, dest, src, operands, 2);
                Assert.fail((String)"Expected exception did not occured");
            }
            catch (VnanoException e) {
                if (e.getErrorType() == ErrorType.INVALID_ARRAY_INDEX) break block2;
                Assert.fail((String)"Expected exception did not occured");
            }
        }
    }

    @Test
    public void testCastInt64Int64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[5];
        lArray[2] = 2L;
        input.setArrayData(lArray, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[output.getArrayOffset()] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastInt64Int64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        input.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[0] != 1L || ((long[])output.getArrayData())[1] != 2L || ((long[])output.getArrayData())[2] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastInt64Float64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[0] != 2.0) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[5];
        lArray[2] = 2L;
        input.setArrayData(lArray, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[output.getArrayOffset()] != 2.0) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastInt64Float64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[0] != 1.0 || ((double[])output.getArrayData())[1] != 2.0 || ((double[])output.getArrayData())[2] != 3.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastInt64StringScalar() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[0].equals("2")) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        long[] lArray = new long[5];
        lArray[2] = 2L;
        input.setArrayData(lArray, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[output.getArrayOffset()].equals("2")) {
            Assert.fail((String)"Incorrect output value");
        }
        if (!((String[])output.getArrayData())[0].equals("Init0") || !((String[])output.getArrayData())[2].equals("Init2")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastInt64StringVector() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<long[]> input = new DataContainer<long[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        input.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.INT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!(((String[])output.getArrayData())[0].equals("1") && ((String[])output.getArrayData())[1].equals("2") && ((String[])output.getArrayData())[2].equals("3"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastFloat64Float64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{2.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[0] != 2.25) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.0, 0.0, 2.25, 0.0, 0.0}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[output.getArrayOffset()] != 2.25) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastFloat64Float64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new double[]{1.125, 2.25, 3.5}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[0] != 1.125 || ((double[])output.getArrayData())[1] != 2.25 || ((double[])output.getArrayData())[2] != 3.5) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastFloat64Int64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{2.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.0, 0.0, 2.25, 0.0, 0.0}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[output.getArrayOffset()] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastFloat64Int64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        input.setArrayData(new double[]{1.125, 2.25, 3.5}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[0] != 1L || ((long[])output.getArrayData())[1] != 2L || ((long[])output.getArrayData())[2] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastFloat64StringScalar() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{2.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[0].equals("2.25")) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new double[]{0.0, 0.0, 2.25, 0.0, 0.0}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[output.getArrayOffset()].equals("2.25")) {
            Assert.fail((String)"Incorrect output value");
        }
        if (!((String[])output.getArrayData())[0].equals("Init0") || !((String[])output.getArrayData())[2].equals("Init2")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastFloat64StringVector() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<double[]> input = new DataContainer<double[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        input.setArrayData(new double[]{1.125, 2.25, 3.5}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.FLOAT64, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!(((String[])output.getArrayData())[0].equals("1.125") && ((String[])output.getArrayData())[1].equals("2.25") && ((String[])output.getArrayData())[2].equals("3.5"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastBoolBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[5];
        blArray[2] = true;
        input.setArrayData(blArray, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((boolean[])output.getArrayData())[output.getArrayOffset()]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastBoolBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        input.setArrayData(blArray, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastBoolStringScalar() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[0].equals("true")) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        boolean[] blArray = new boolean[5];
        blArray[2] = true;
        input.setArrayData(blArray, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[output.getArrayOffset()].equals("true")) {
            Assert.fail((String)"Incorrect output value");
        }
        if (!((String[])output.getArrayData())[0].equals("Init0") || !((String[])output.getArrayData())[2].equals("Init2")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastBoolStringVector() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<boolean[]> input = new DataContainer<boolean[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        input.setArrayData(blArray, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.BOOL, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!(((String[])output.getArrayData())[0].equals("true") && ((String[])output.getArrayData())[1].equals("false") && ((String[])output.getArrayData())[2].equals("true"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastStringStringScalar() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[0].equals("Hello")) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"", "", "Hello", "", ""}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((String[])output.getArrayData())[output.getArrayOffset()].equals("Hello")) {
            Assert.fail((String)"Incorrect output value");
        }
        if (!((String[])output.getArrayData())[0].equals("Init0") || !((String[])output.getArrayData())[2].equals("Init2")) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastStringStringVector() {
        DataContainer<String[]> output = new DataContainer<String[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new String[]{"Init0", "Init1", "Init2"}, 0, new int[]{3});
        input.setArrayData(new String[]{"Hello", "World", "!"}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.STRING, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!(((String[])output.getArrayData())[0].equals("Hello") && ((String[])output.getArrayData())[1].equals("World") && ((String[])output.getArrayData())[2].equals("!"))) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastStringInt64Scalar() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"2"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[0] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"0", "0", "2", "0", "0"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[output.getArrayOffset()] != 2L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"0", "0", "8.25", "0", "0"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[output.getArrayOffset()] != 8L) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((long[])output.getArrayData())[0] != -1L || ((long[])output.getArrayData())[2] != -1L) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new long[]{-1L, -1L, -1L}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"0", "0", "Hello", "0", "0"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.STRING, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
    }

    @Test
    public void testCastStringInt64Vector() {
        DataContainer<long[]> output = new DataContainer<long[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        input.setArrayData(new String[]{"1", "2", "3"}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.INT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((long[])output.getArrayData())[0] != 1L || ((long[])output.getArrayData())[1] != 2L || ((long[])output.getArrayData())[2] != 3L) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastStringFloat64Scalar() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"2.25"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[0] != 2.25) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"0.0", "0.0", "2.25", "0.0", "0.0"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[output.getArrayOffset()] != 2.25) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((double[])output.getArrayData())[0] != -1.0 || ((double[])output.getArrayData())[2] != -1.0) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"0.0", "0.0", "Hello", "0.0", "0.0"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.STRING, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
    }

    @Test
    public void testCastStringFloat64Vector() {
        DataContainer<double[]> output = new DataContainer<double[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new double[]{-1.0, -1.0, -1.0}, 0, new int[]{3});
        input.setArrayData(new String[]{"1.125", "2.25", "3.5"}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (((double[])output.getArrayData())[0] != 1.125 || ((double[])output.getArrayData())[1] != 2.25 || ((double[])output.getArrayData())[2] != 3.5) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastStringBoolScalar() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"true"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((boolean[])output.getArrayData())[0]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"false", "false", "true", "false", "false"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((boolean[])output.getArrayData())[output.getArrayOffset()]) {
            Assert.fail((String)"Incorrect output value");
        }
        if (((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
        output.setArrayData(new boolean[3], 1, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        input.setArrayData(new String[]{"0.0", "0.0", "Hello", "0.0", "0.0"}, 2, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.STRING, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
    }

    @Test
    public void testCastStringBoolVector() {
        DataContainer<boolean[]> output = new DataContainer<boolean[]>();
        DataContainer<String[]> input = new DataContainer<String[]>();
        output.setArrayData(new boolean[3], 0, new int[]{3});
        input.setArrayData(new String[]{"true", "false", "true"}, 0, new int[]{3});
        try {
            new ExecutionUnit().cast(DataType.BOOL, DataType.STRING, output, input);
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Cast failed");
        }
        if (!((boolean[])output.getArrayData())[0] || ((boolean[])output.getArrayData())[1] || !((boolean[])output.getArrayData())[2]) {
            Assert.fail((String)"Incorrect output value");
        }
    }

    @Test
    public void testCastUnoperatableData() {
        DataContainer<Object[]> output = new DataContainer<Object[]>();
        DataContainer<Object[]> input = new DataContainer<Object[]>();
        try {
            output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.INT64, DataType.BOOL, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new Object[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.INT64, DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.BOOL, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new double[]{-1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new Object[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.FLOAT64, DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new long[]{123L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.BOOL, DataType.INT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new double[]{2.25}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.BOOL, DataType.FLOAT64, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new Object[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.BOOL, DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new String[]{"Init"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new Object[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.STRING, DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
        try {
            output.setArrayData(new Object[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            input.setArrayData(new Object[]{""}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            new ExecutionUnit().cast(DataType.VOID, DataType.VOID, output, input);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoException vnanoException) {
            // empty catch block
        }
    }
}

