/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public class InstructionTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        int[] addresses;
        Memory.Partition[] partitions;
        DataType[] types;
        Instruction instruction = new Instruction(OperationCode.CAST, new DataType[]{DataType.INT64, DataType.FLOAT64}, new Memory.Partition[]{Memory.Partition.REGISTER, Memory.Partition.LOCAL, Memory.Partition.GLOBAL}, new int[]{123, 456, 789}, Memory.Partition.CONSTANT, 888);
        if (instruction.getOperationCode() != OperationCode.CAST) {
            Assert.fail((String)"Incorrect operation code");
        }
        if ((types = instruction.getDataTypes()).length != 2 || types[0] != DataType.INT64 || types[1] != DataType.FLOAT64) {
            Assert.fail((String)"Incorrect data types");
        }
        if ((partitions = instruction.getOperandPartitions()).length != 3 || partitions[0] != Memory.Partition.REGISTER || partitions[1] != Memory.Partition.LOCAL || partitions[2] != Memory.Partition.GLOBAL) {
            Assert.fail((String)"Incorrect operand partitions");
        }
        if ((addresses = instruction.getOperandAddresses()).length != 3 || addresses[0] != 123 || addresses[1] != 456 || addresses[2] != 789) {
            Assert.fail((String)"Incorrect operand addresses");
        }
        if (instruction.getMetaPartition() != Memory.Partition.CONSTANT) {
            Assert.fail((String)"Incorrect meta partition");
        }
        if (instruction.getMetaAddress() != 888) {
            Assert.fail((String)"Incorrect meta address");
        }
        if (!instruction.toString().equals("[ CAST\tINT64:FLOAT64\tR123\tL456\tG789\tC888 ]")) {
            Assert.fail((String)"Incorrect string");
        }
    }
}

