/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rxg2dlegacyimpl;

import com.rinearn.rxg2dlegacyimpl.rg2d;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleSettingWindow
implements ActionListener,
ChangeListener {
    public static final String DEFAULT_SCALE_LENGTH = "0.05";
    public static final String DEFAULT_SCALE_BLANK = "0.05";
    public rg2d rg2d;
    public JFrame scaleWindow;
    public JTabbedPane scaleTabbedPane;
    public JCheckBox[] xScaleBox;
    public JCheckBox[] yScaleBox;
    public JCheckBox[] zScaleBox;
    public JCheckBox xScaleAutoBox;
    public JCheckBox yScaleAutoBox;
    public JCheckBox zScaleAutoBox;
    public JTextField scaleLengthField;
    public JTextField scaleBlankField;
    public JCheckBox scaleInnerBox;
    public JCheckBox scaleInnerBackwallBox;
    public JTextField scaleLineWidthField;
    public JButton scaleButton;
    public Choice boxTypeChoice;
    public JTextField numberFormatXField;
    public JTextField numberFormatXField_sh;
    public JTextField numberFormatYField;
    public JTextField numberFormatYField_sh;
    public JTextField numberFormatZField;
    public JTextField numberFormatZField_sh;
    public JCheckBox numberFormatAutoXBox;
    public JCheckBox numberFormatAutoYBox;
    public JCheckBox numberFormatAutoZBox;
    public JLabel numberFormatXLabel;
    public JLabel numberFormatYLabel;
    public JLabel numberFormatZLabel;
    public JLabel numberFormatXLabel_sh;
    public JLabel numberFormatYLabel_sh;
    public JLabel numberFormatZLabel_sh;
    public JTextField scaleImageField_ZFloor;
    public JButton scaleImageOpenButton_ZFloor;
    public JTextField scaleImageField_ZCeil;
    public JButton scaleImageOpenButton_ZCeil;
    public JTextField scaleImageField_XFloor;
    public JButton scaleImageOpenButton_XFloor;
    public JTextField scaleImageField_XCeil;
    public JButton scaleImageOpenButton_XCeil;
    public JTextField scaleImageField_YFloor;
    public JButton scaleImageOpenButton_YFloor;
    public JTextField scaleImageField_YCeil;
    public JButton scaleImageOpenButton_YCeil;
    public JTextField scaleImageWidthField_ZFloor;
    public JTextField scaleImageHeightField_ZFloor;
    public JTextField scaleImageWidthField_ZCeil;
    public JTextField scaleImageHeightField_ZCeil;
    public JTextField scaleImageWidthField_XFloor;
    public JTextField scaleImageHeightField_XFloor;
    public JTextField scaleImageWidthField_XCeil;
    public JTextField scaleImageHeightField_XCeil;
    public JTextField scaleImageWidthField_YFloor;
    public JTextField scaleImageHeightField_YFloor;
    public JTextField scaleImageWidthField_YCeil;
    public JTextField scaleImageHeightField_YCeil;
    public JCheckBox scaleImageInsideOnlyBox;
    public boolean scaleImageInsideOnly = true;
    public static final String TICK_MODE_EQUAL_DIVISION_JA = "\u7b49\u5206\u5272";
    public static final String TICK_MODE_EQUAL_DIVISION_EN = "EQUAL_DIVISION";
    public static final String TICK_MODE_MANUAL_JA = "\u624b\u52d5";
    public static final String TICK_MODE_MANUAL_EN = "MANUAL";
    public JPanel tickContentPanel;
    public JComboBox<String> xTickModeBox;
    public JComboBox<String> yTickModeBox;
    public JComboBox<String> zTickModeBox;
    public JComboBox<String> cTickModeBox;
    public JTextField scaleNXField;
    public JTextField scaleNYField;
    public JTextField scaleNZField;
    public JTextField scaleNColorBarField;
    public JTextField xTickCoordsField;
    public JTextField yTickCoordsField;
    public JTextField zTickCoordsField;
    public JTextField cTickCoordsField;
    public JTextField xTickLabelsField;
    public JTextField yTickLabelsField;
    public JTextField zTickLabelsField;
    public JTextField cTickLabelsField;
    public JCheckBox xTickLabelsBox;
    public JCheckBox yTickLabelsBox;
    public JCheckBox zTickLabelsBox;
    public JCheckBox cTickLabelsBox;
    public JPanel xTickManualPanel;
    public JPanel yTickManualPanel;
    public JPanel zTickManualPanel;
    public JPanel cTickManualPanel;
    public JPanel xTickEqualDivisionPanel;
    public JPanel yTickEqualDivisionPanel;
    public JPanel zTickEqualDivisionPanel;
    public JPanel cTickEqualDivisionPanel;

    public static TickMode tickModeTextToEnum(String string) {
        if (string.equals(TICK_MODE_EQUAL_DIVISION_JA) || string.equals(TICK_MODE_EQUAL_DIVISION_EN)) {
            return TickMode.EQUAL_DIVISION;
        }
        if (string.equals(TICK_MODE_MANUAL_JA) || string.equals(TICK_MODE_MANUAL_EN)) {
            return TickMode.MANUAL;
        }
        throw new RuntimeException("Unexpected tick mode text: " + string);
    }

    public static String tickModeEnumToText(TickMode tickMode, boolean bl) {
        if (tickMode == TickMode.EQUAL_DIVISION) {
            return bl ? TICK_MODE_EQUAL_DIVISION_JA : TICK_MODE_EQUAL_DIVISION_EN;
        }
        if (tickMode == TickMode.MANUAL) {
            return bl ? TICK_MODE_MANUAL_JA : TICK_MODE_MANUAL_EN;
        }
        throw new RuntimeException("Unexpected tick mode: " + (Object)((Object)tickMode));
    }

    public ScaleSettingWindow(rg2d rg2d2) {
        this.rg2d = rg2d2;
        this.scaleNXField = new JTextField("4");
        this.scaleNYField = new JTextField("10");
        this.scaleNZField = new JTextField("4");
        this.scaleNColorBarField = new JTextField("1");
        this.scaleLengthField = new JTextField("0.05");
        this.scaleBlankField = new JTextField("0.05");
        this.scaleInnerBox = this.rg2d.japanese ? new JCheckBox("\u5185\u5411\u304d\u306b\u63cf\u753b") : new JCheckBox("Draw inside");
        this.scaleInnerBackwallBox = this.rg2d.japanese ? new JCheckBox("\u80cc\u9762\u306e\u8fba\u306b\u3082\u63cf\u753b") : new JCheckBox("Draw on backwall edges");
        this.scaleLineWidthField = new JTextField("1.0");
        this.scaleImageField_XFloor = new JTextField("");
        this.scaleImageField_XCeil = new JTextField("");
        this.scaleImageField_YFloor = new JTextField("");
        this.scaleImageField_YCeil = new JTextField("");
        this.scaleImageField_ZFloor = new JTextField("");
        this.scaleImageField_ZCeil = new JTextField("");
        this.scaleImageWidthField_XFloor = new JTextField("140");
        this.scaleImageHeightField_XFloor = new JTextField("140");
        this.scaleImageWidthField_XCeil = new JTextField("140");
        this.scaleImageHeightField_XCeil = new JTextField("140");
        this.scaleImageWidthField_YFloor = new JTextField("140");
        this.scaleImageHeightField_YFloor = new JTextField("140");
        this.scaleImageWidthField_YCeil = new JTextField("140");
        this.scaleImageHeightField_YCeil = new JTextField("140");
        this.scaleImageWidthField_ZFloor = new JTextField("140");
        this.scaleImageHeightField_ZFloor = new JTextField("140");
        this.scaleImageWidthField_ZCeil = new JTextField("140");
        this.scaleImageHeightField_ZCeil = new JTextField("140");
        this.scaleImageInsideOnlyBox = this.rg2d.japanese ? new JCheckBox("\u5185\u9762\u306e\u307f\u8868\u793a") : new JCheckBox("Inside Only");
        if (this.rg2d.japanese) {
            this.numberFormatAutoXBox = new JCheckBox("\u81ea\u52d5\u8abf\u6574");
            this.numberFormatAutoYBox = new JCheckBox("\u81ea\u52d5\u8abf\u6574");
            this.numberFormatAutoZBox = new JCheckBox("\u81ea\u52d5\u8abf\u6574");
        } else {
            this.numberFormatAutoXBox = new JCheckBox("Auto");
            this.numberFormatAutoYBox = new JCheckBox("Auto");
            this.numberFormatAutoZBox = new JCheckBox("Auto");
        }
        this.numberFormatAutoXBox.setSelected(true);
        this.numberFormatAutoYBox.setSelected(true);
        this.numberFormatAutoZBox.setSelected(true);
        if (this.rg2d.japanese) {
            this.xScaleAutoBox = new JCheckBox("\u81ea\u52d5\u8abf\u6574");
            this.yScaleAutoBox = new JCheckBox("\u81ea\u52d5\u8abf\u6574");
            this.zScaleAutoBox = new JCheckBox("\u81ea\u52d5\u8abf\u6574");
        } else {
            this.xScaleAutoBox = new JCheckBox("Auto");
            this.yScaleAutoBox = new JCheckBox("Auto");
            this.zScaleAutoBox = new JCheckBox("Auto");
        }
        this.xScaleAutoBox.setSelected(true);
        this.yScaleAutoBox.setSelected(true);
        this.zScaleAutoBox.setSelected(true);
        this.numberFormatXField = new JTextField("0.0#E0");
        this.numberFormatXField_sh = new JTextField("0.00");
        this.numberFormatYField = new JTextField("0.0#E0");
        this.numberFormatYField_sh = new JTextField("0.00");
        this.numberFormatZField = new JTextField("0.0#E0");
        this.numberFormatZField_sh = new JTextField("0.00");
        this.boxTypeChoice = new Choice();
        this.boxTypeChoice.add("BOX TYPE");
        this.boxTypeChoice.add("BACK-WALL TYPE");
        this.boxTypeChoice.add("FLOOR TYPE");
        this.boxTypeChoice.add("NONE");
        this.boxTypeChoice.select("BOX TYPE");
        this.xScaleBox = new JCheckBox[4];
        this.yScaleBox = new JCheckBox[4];
        this.zScaleBox = new JCheckBox[4];
        for (int i = 0; i < 4; ++i) {
            if (this.rg2d.japanese) {
                this.xScaleBox[i] = new JCheckBox("\u76ee\u76db\u308aX" + i);
                this.yScaleBox[i] = new JCheckBox("\u76ee\u76db\u308aY" + i);
                this.zScaleBox[i] = new JCheckBox("\u76ee\u76db\u308aZ" + i);
            } else {
                this.xScaleBox[i] = new JCheckBox("Scale-X" + i);
                this.yScaleBox[i] = new JCheckBox("Scale-Y" + i);
                this.zScaleBox[i] = new JCheckBox("Scale-Z" + i);
            }
            this.xScaleBox[i].setSelected(true);
            this.yScaleBox[i].setSelected(true);
            this.zScaleBox[i].setSelected(true);
        }
        this.xTickCoordsField = new JTextField("-1.0, -0.5, 0.0, 0.5, 1.0");
        this.yTickCoordsField = new JTextField("-1.0, -0.5, 0.0, 0.5, 1.0");
        this.zTickCoordsField = new JTextField("-1.0, -0.5, 0.0, 0.5, 1.0");
        this.cTickCoordsField = new JTextField("-1.0, -0.5, 0.0, 0.5, 1.0");
        this.xTickLabelsField = new JTextField("-1, -0.5, 0, 0.5, 1");
        this.yTickLabelsField = new JTextField("-1, -0.5, 0, 0.5, 1");
        this.zTickLabelsField = new JTextField("-1, -0.5, 0, 0.5, 1");
        this.cTickLabelsField = new JTextField("-1, -0.5, 0, 0.5, 1");
        this.xTickModeBox = new JComboBox();
        this.xTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_EQUAL_DIVISION_JA : TICK_MODE_EQUAL_DIVISION_EN);
        this.xTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_MANUAL_JA : TICK_MODE_MANUAL_EN);
        this.yTickModeBox = new JComboBox();
        this.yTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_EQUAL_DIVISION_JA : TICK_MODE_EQUAL_DIVISION_EN);
        this.yTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_MANUAL_JA : TICK_MODE_MANUAL_EN);
        this.zTickModeBox = new JComboBox();
        this.zTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_EQUAL_DIVISION_JA : TICK_MODE_EQUAL_DIVISION_EN);
        this.zTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_MANUAL_JA : TICK_MODE_MANUAL_EN);
        this.cTickModeBox = new JComboBox();
        this.cTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_EQUAL_DIVISION_JA : TICK_MODE_EQUAL_DIVISION_EN);
        this.cTickModeBox.addItem(this.rg2d.japanese ? TICK_MODE_MANUAL_JA : TICK_MODE_MANUAL_EN);
    }

    public void launchScaleWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.launchScaleWindow_internal();
        } else {
            SwingUtilities.invokeLater(new ScaleWindowLauncher());
        }
    }

    private void launchScaleWindow_internal() {
        if (this.scaleWindow == null) {
            this.initScaleWindow_internal();
        }
        this.scaleWindow.setVisible(true);
    }

    private void initScaleWindow_internal() {
        int n = 360;
        int n2 = 0;
        int n3 = (int)this.rg2d.getBounds().getX() + 30;
        int n4 = (int)this.rg2d.getBounds().getY() + 30;
        this.scaleWindow = new JFrame();
        this.scaleWindow.setBounds(n3, n4, n, 420 + n2);
        this.scaleWindow.getContentPane().setLayout(null);
        if (this.rg2d.japanese) {
            this.scaleWindow.setTitle("\u76ee\u76db\u308a\u306e\u8a2d\u5b9a");
        } else {
            this.scaleWindow.setTitle("Set Scale");
        }
        this.scaleWindow.getContentPane().setLayout(null);
        this.scaleTabbedPane = new JTabbedPane();
        this.scaleWindow.getContentPane().add(this.scaleTabbedPane);
        this.scaleTabbedPane.setBounds(7, 7, n - 30, 300 + n2);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        jPanel.setLayout(new GridLayout(1, 1));
        JPanel jPanel2 = this.tickContentPanel = new JPanel();
        jPanel.add(jPanel2);
        jPanel2.setLayout(null);
        int n5 = 5;
        int n6 = 50;
        if (this.rg2d.japanese) {
            this.scaleTabbedPane.addTab("\u523b\u307f", jPanel);
        } else {
            this.scaleTabbedPane.addTab("Ticks", jPanel);
        }
        JLabel jLabel = new JLabel(this.rg2d.japanese ? "- X\u8ef8 -" : "- X Axis -");
        jLabel.setBounds(0, n5, 200, 20);
        jLabel.setFont(this.rg2d.systemFont_big);
        jPanel2.add(jLabel);
        jPanel2.add(new JLabel());
        jLabel = new JLabel(this.rg2d.japanese ? "\u30e2\u30fc\u30c9: " : "Mode: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        jLabel.setBounds(0, n5 += 30, 80, 24);
        jPanel2.add(jLabel);
        this.xTickModeBox.addActionListener(this);
        this.xTickModeBox.setBounds(80, n5, n - 100 - 30, 24);
        this.xTickModeBox.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.xTickModeBox);
        this.xTickEqualDivisionPanel = new JPanel();
        this.xTickEqualDivisionPanel.setBounds(0, n5 += 30, n - 50, n6);
        jPanel2.add(this.xTickEqualDivisionPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.xTickEqualDivisionPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        jLabel = new JLabel(this.rg2d.japanese ? "\u533a\u9593\u6570: " : "Number of Sections: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.xTickEqualDivisionPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.7;
        this.scaleNXField.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(this.scaleNXField, gridBagConstraints);
        this.xTickEqualDivisionPanel.add(this.scaleNXField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.2;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.xTickEqualDivisionPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.7;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.xTickEqualDivisionPanel.add(jLabel);
        this.xTickManualPanel = new JPanel();
        this.xTickManualPanel.setBounds(0, n5, n - 50, n6);
        this.xTickManualPanel.setLayout(new GridLayout(3, 2));
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.xTickManualPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        jLabel = new JLabel(this.rg2d.japanese ? "\u4f4d\u7f6e: " : "Coordinates: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.xTickManualPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.5;
        this.xTickCoordsField.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(this.xTickCoordsField, gridBagConstraints);
        this.xTickManualPanel.add(this.xTickCoordsField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        jLabel = new JLabel(this.rg2d.japanese ? "\u8868\u8a18: " : "Labels: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.xTickManualPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.5;
        this.xTickLabelsField.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(this.xTickLabelsField, gridBagConstraints);
        this.xTickManualPanel.add(this.xTickLabelsField);
        jLabel = new JLabel(this.rg2d.japanese ? "- Y\u8ef8 -" : "- Y Axis -");
        jLabel.setBounds(0, n5 += n6 + 20, 200, 20);
        jLabel.setFont(this.rg2d.systemFont_big);
        jPanel2.add(jLabel);
        jPanel2.add(new JLabel());
        jLabel = new JLabel(this.rg2d.japanese ? "\u30e2\u30fc\u30c9: " : "Mode: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        jLabel.setBounds(0, n5 += 30, 80, 24);
        jPanel2.add(jLabel);
        this.yTickModeBox.addActionListener(this);
        this.yTickModeBox.setBounds(80, n5, n - 100 - 30, 24);
        this.yTickModeBox.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.yTickModeBox);
        this.yTickEqualDivisionPanel = new JPanel();
        this.yTickEqualDivisionPanel.setBounds(0, n5 += 30, n - 50, n6);
        jPanel2.add(this.yTickEqualDivisionPanel);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.yTickEqualDivisionPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        jLabel = new JLabel(this.rg2d.japanese ? "\u533a\u9593\u6570: " : "Number of Sections: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.yTickEqualDivisionPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.7;
        this.scaleNYField.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(this.scaleNYField, gridBagConstraints);
        this.yTickEqualDivisionPanel.add(this.scaleNYField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.2;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.yTickEqualDivisionPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.7;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.yTickEqualDivisionPanel.add(jLabel);
        this.yTickManualPanel = new JPanel();
        this.yTickManualPanel.setBounds(0, n5, n - 50, n6);
        this.yTickManualPanel.setLayout(new GridLayout(3, 2));
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.yTickManualPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        jLabel = new JLabel(this.rg2d.japanese ? "\u4f4d\u7f6e: " : "Coordinates: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.yTickManualPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.5;
        this.yTickCoordsField.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(this.yTickCoordsField, gridBagConstraints);
        this.yTickManualPanel.add(this.yTickCoordsField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        jLabel = new JLabel(this.rg2d.japanese ? "\u8868\u8a18: " : "Labels: ", 4);
        jLabel.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.yTickManualPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.5;
        this.yTickLabelsField.setFont(this.rg2d.systemFont_normal);
        gridBagLayout.setConstraints(this.yTickLabelsField, gridBagConstraints);
        this.yTickManualPanel.add(this.yTickLabelsField);
        jPanel2.add(new JLabel(""));
        jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        jPanel.setLayout(new GridLayout(10, 1));
        JLabel jLabel2 = this.rg2d.japanese ? new JLabel("- X\u8ef8 -") : new JLabel("- X Axis -");
        jLabel2.setFont(this.rg2d.systemFont_big);
        jPanel.add(jLabel2);
        jLabel2.setVisible(true);
        jPanel.add(this.numberFormatAutoXBox);
        this.numberFormatAutoXBox.setFont(this.rg2d.systemFont_normal);
        this.numberFormatAutoXBox.addItemListener(this.rg2d);
        this.numberFormatAutoXBox.setVisible(true);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.setVisible(true);
        this.numberFormatXLabel_sh = new JLabel("0.1\uff5e10: ", 4);
        this.numberFormatXLabel_sh.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatXLabel_sh);
        this.numberFormatXLabel_sh.setVisible(true);
        this.numberFormatXField_sh.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatXField_sh);
        this.numberFormatXField_sh.setVisible(true);
        jPanel2.setVisible(true);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.setVisible(true);
        this.numberFormatXLabel = this.rg2d.japanese ? new JLabel("\u4e0a\u8a18\u4ee5\u5916: ", 4) : new JLabel("Else: ", 4);
        this.numberFormatXLabel.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatXLabel);
        jLabel2.setVisible(true);
        this.numberFormatXField.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatXField);
        this.numberFormatXField.setVisible(true);
        jPanel2.setVisible(true);
        jPanel.add(jPanel2);
        this.numberFormatXField.setVisible(false);
        this.numberFormatXField_sh.setVisible(false);
        this.numberFormatXLabel.setVisible(false);
        this.numberFormatXLabel_sh.setVisible(false);
        jPanel.add(new JLabel(""));
        jLabel2 = this.rg2d.japanese ? new JLabel("- Y\u8ef8 -") : new JLabel("- Y Axis -");
        jLabel2.setFont(this.rg2d.systemFont_big);
        jPanel.add(jLabel2);
        jLabel2.setVisible(true);
        jPanel.add(this.numberFormatAutoYBox);
        this.numberFormatAutoYBox.setFont(this.rg2d.systemFont_normal);
        this.numberFormatAutoYBox.addItemListener(this.rg2d);
        this.numberFormatAutoYBox.setVisible(true);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.setVisible(true);
        this.numberFormatYLabel_sh = new JLabel("0.1\uff5e10: ", 4);
        this.numberFormatYLabel_sh.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatYLabel_sh);
        this.numberFormatYLabel_sh.setVisible(true);
        this.numberFormatYField_sh.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatYField_sh);
        this.numberFormatYField_sh.setVisible(true);
        jPanel2.setVisible(true);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.setVisible(true);
        this.numberFormatYLabel = this.rg2d.japanese ? new JLabel("\u4e0a\u8a18\u4ee5\u5916: ", 4) : new JLabel("Else: ", 4);
        this.numberFormatYLabel.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatYLabel);
        this.numberFormatYLabel.setVisible(true);
        this.numberFormatYField.setFont(this.rg2d.systemFont_normal);
        jPanel2.add(this.numberFormatYField);
        this.numberFormatYField.setVisible(true);
        jPanel2.setVisible(true);
        jPanel.add(jPanel2);
        this.numberFormatYField.setVisible(false);
        this.numberFormatYField_sh.setVisible(false);
        this.numberFormatYLabel.setVisible(false);
        this.numberFormatYLabel_sh.setVisible(false);
        if (this.rg2d.japanese) {
            this.scaleTabbedPane.addTab("\u66f8\u5f0f", jPanel);
        } else {
            this.scaleTabbedPane.addTab("Formats", jPanel);
        }
        jPanel.add(new JLabel(""));
        this.scaleTabbedPane.addChangeListener(this);
        this.scaleButton = new JButton("SET");
        this.scaleButton.setFont(this.rg2d.systemFont_big);
        this.scaleButton.setBounds(10, 300 + n2 + 20, n - 35, 50);
        this.scaleButton.addActionListener(this.rg2d);
        this.scaleButton.setVisible(true);
        this.scaleWindow.getContentPane().add(this.scaleButton);
        this.scaleTabbedPane.setVisible(false);
        this.scaleTabbedPane.setVisible(true);
        for (int i = 0; i < this.scaleTabbedPane.getTabCount(); ++i) {
            this.scaleTabbedPane.setSelectedIndex(i);
        }
        this.scaleTabbedPane.setSelectedIndex(0);
        this.scaleTabbedPane.setVisible(false);
        this.scaleTabbedPane.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.xTickModeBox) {
            this.reflectXTickMode();
        }
        if (object == this.yTickModeBox) {
            this.reflectYTickMode();
        }
        if (object == this.zTickModeBox) {
            this.reflectZTickMode();
        }
        if (object == this.cTickModeBox) {
            this.reflectCTickMode();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.reflectXTickMode();
        this.reflectYTickMode();
        this.reflectZTickMode();
        this.reflectCTickMode();
    }

    public void reflectXTickMode() {
        if (SwingUtilities.isEventDispatchThread()) {
            new XTickModeReflector().run();
        } else {
            SwingUtilities.invokeLater(new XTickModeReflector());
        }
    }

    public void reflectYTickMode() {
        if (SwingUtilities.isEventDispatchThread()) {
            new YTickModeReflector().run();
        } else {
            SwingUtilities.invokeLater(new XTickModeReflector());
        }
    }

    public void reflectZTickMode() {
        if (SwingUtilities.isEventDispatchThread()) {
            new ZTickModeReflector().run();
        } else {
            SwingUtilities.invokeLater(new ZTickModeReflector());
        }
    }

    public void reflectCTickMode() {
        if (SwingUtilities.isEventDispatchThread()) {
            new CTickModeReflector().run();
        } else {
            SwingUtilities.invokeLater(new CTickModeReflector());
        }
    }

    public void setXTicks(double[] dArray, String[] stringArray, boolean bl) {
        TicksSetter ticksSetter = new TicksSetter(dArray, stringArray, this.xTickCoordsField, this.xTickLabelsField, this.xTickModeBox, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            ticksSetter.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(ticksSetter);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                ticksSetter.run();
            }
        }
    }

    public void setYTicks(double[] dArray, String[] stringArray, boolean bl) {
        TicksSetter ticksSetter = new TicksSetter(dArray, stringArray, this.yTickCoordsField, this.yTickLabelsField, this.yTickModeBox, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            ticksSetter.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(ticksSetter);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                ticksSetter.run();
            }
        }
    }

    public void setZTicks(double[] dArray, String[] stringArray, boolean bl) {
        TicksSetter ticksSetter = new TicksSetter(dArray, stringArray, this.zTickCoordsField, this.zTickLabelsField, this.zTickModeBox, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            ticksSetter.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(ticksSetter);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                ticksSetter.run();
            }
        }
    }

    public void setColorBarTicks(double[] dArray, String[] stringArray, boolean bl) {
        TicksSetter ticksSetter = new TicksSetter(dArray, stringArray, this.cTickCoordsField, this.cTickLabelsField, this.cTickModeBox, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            ticksSetter.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(ticksSetter);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                ticksSetter.run();
            }
        }
    }

    public static enum TickMode {
        EQUAL_DIVISION,
        MANUAL;

    }

    private class ScaleWindowLauncher
    implements Runnable {
        private ScaleWindowLauncher() {
        }

        @Override
        public void run() {
            ScaleSettingWindow.this.launchScaleWindow_internal();
        }
    }

    private class XTickModeReflector
    implements Runnable {
        private XTickModeReflector() {
        }

        @Override
        public void run() {
            if (ScaleSettingWindow.this.xTickEqualDivisionPanel == null || ScaleSettingWindow.this.xTickManualPanel == null) {
                return;
            }
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.xTickEqualDivisionPanel);
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.xTickManualPanel);
            String string = (String)String.class.cast(ScaleSettingWindow.this.xTickModeBox.getSelectedItem());
            if (string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_EN) || string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.xTickEqualDivisionPanel);
            }
            if (string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_EN) || string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.xTickManualPanel);
            }
            ScaleSettingWindow.this.tickContentPanel.repaint();
            ScaleSettingWindow.this.scaleWindow.repaint();
        }
    }

    private class YTickModeReflector
    implements Runnable {
        private YTickModeReflector() {
        }

        @Override
        public void run() {
            if (ScaleSettingWindow.this.yTickEqualDivisionPanel == null || ScaleSettingWindow.this.yTickManualPanel == null) {
                return;
            }
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.yTickEqualDivisionPanel);
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.yTickManualPanel);
            String string = (String)String.class.cast(ScaleSettingWindow.this.yTickModeBox.getSelectedItem());
            if (string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_EN) || string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.yTickEqualDivisionPanel);
            }
            if (string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_EN) || string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.yTickManualPanel);
            }
            ScaleSettingWindow.this.tickContentPanel.repaint();
            ScaleSettingWindow.this.scaleWindow.repaint();
        }
    }

    private class ZTickModeReflector
    implements Runnable {
        private ZTickModeReflector() {
        }

        @Override
        public void run() {
            if (ScaleSettingWindow.this.zTickEqualDivisionPanel == null || ScaleSettingWindow.this.zTickManualPanel == null) {
                return;
            }
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.zTickEqualDivisionPanel);
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.zTickManualPanel);
            String string = (String)String.class.cast(ScaleSettingWindow.this.zTickModeBox.getSelectedItem());
            if (string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_EN) || string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.zTickEqualDivisionPanel);
            }
            if (string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_EN) || string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.zTickManualPanel);
            }
            ScaleSettingWindow.this.tickContentPanel.repaint();
            ScaleSettingWindow.this.scaleWindow.repaint();
        }
    }

    private class CTickModeReflector
    implements Runnable {
        private CTickModeReflector() {
        }

        @Override
        public void run() {
            if (ScaleSettingWindow.this.cTickEqualDivisionPanel == null || ScaleSettingWindow.this.cTickManualPanel == null) {
                return;
            }
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.cTickEqualDivisionPanel);
            ScaleSettingWindow.this.tickContentPanel.remove(ScaleSettingWindow.this.cTickManualPanel);
            String string = (String)String.class.cast(ScaleSettingWindow.this.cTickModeBox.getSelectedItem());
            if (string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_EN) || string.equals(ScaleSettingWindow.TICK_MODE_EQUAL_DIVISION_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.cTickEqualDivisionPanel);
            }
            if (string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_EN) || string.equals(ScaleSettingWindow.TICK_MODE_MANUAL_JA)) {
                ScaleSettingWindow.this.tickContentPanel.add(ScaleSettingWindow.this.cTickManualPanel);
            }
            ScaleSettingWindow.this.tickContentPanel.repaint();
            ScaleSettingWindow.this.scaleWindow.repaint();
        }
    }

    private class TicksSetter
    implements Runnable {
        private volatile double[] tickCoords;
        private volatile String[] tickLabels;
        private volatile boolean isJapanese;
        private JTextField tickCoordTextField;
        private JTextField tickLabelTextField;
        private JComboBox<String> tickModeBox;

        public TicksSetter(double[] dArray, String[] stringArray, JTextField jTextField, JTextField jTextField2, JComboBox<String> jComboBox, boolean bl) {
            this.tickCoords = dArray;
            this.tickLabels = stringArray;
            this.tickCoordTextField = jTextField;
            this.tickLabelTextField = jTextField2;
            this.tickModeBox = jComboBox;
            this.isJapanese = bl;
        }

        @Override
        public void run() {
            String string = "";
            for (int i = 0; i < this.tickCoords.length; ++i) {
                string = string + this.tickCoords[i];
                if (i == this.tickCoords.length - 1) continue;
                string = string + ", ";
            }
            String string2 = "";
            for (int i = 0; i < this.tickLabels.length; ++i) {
                String string3 = this.tickLabels[i].replaceAll(",", "\\,");
                string2 = string2 + string3;
                if (i == this.tickLabels.length - 1) continue;
                string2 = string2 + ", ";
            }
            this.tickModeBox.setSelectedItem(ScaleSettingWindow.tickModeEnumToText(TickMode.MANUAL, this.isJapanese));
            this.tickCoordTextField.setText(string);
            this.tickLabelTextField.setText(string2);
            if (ScaleSettingWindow.this.scaleWindow != null) {
                ScaleSettingWindow.this.scaleWindow.repaint();
            }
        }
    }
}

